/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.MutableContextInfo;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import org.jetbrains.kotlin.contracts.model.structure.ESType;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.TypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0014\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ!\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/InfoCollector;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/MutableContextInfo;", "observedEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/contracts/model/ESEffect;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "isInverted", "", "collectFromEffect", "effect", "collectFromSchema", "schema", "", "inverted", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "visitAnd", "and", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitConstant", "esConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "visitEqual", "equal", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitIs", "isOperator", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitLambda", "lambda", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "visitNot", "not", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitOr", "or", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitReceiver", "esReceiver", "Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "visitVariable", "esVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "resolution"})
@SourceDebugExtension(value={"SMAP\nInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfoCollector.kt\norg/jetbrains/kotlin/contracts/model/visitors/InfoCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1603#2,9:93\n1855#2:102\n1856#2:104\n1612#2:105\n1789#2,3:106\n1#3:103\n1#3:109\n*S KotlinDebug\n*F\n+ 1 InfoCollector.kt\norg/jetbrains/kotlin/contracts/model/visitors/InfoCollector\n*L\n27#1:93,9\n27#1:102\n27#1:104\n27#1:105\n27#1:106,3\n27#1:103\n*E\n"})
public final class InfoCollector
implements ESExpressionVisitor<MutableContextInfo> {
    @NotNull
    private final ESEffect observedEffect;
    @NotNull
    private final KotlinBuiltIns builtIns;
    private boolean isInverted;

    public InfoCollector(@NotNull ESEffect observedEffect, @NotNull KotlinBuiltIns builtIns2) {
        Intrinsics.checkNotNullParameter((Object)observedEffect, (String)"observedEffect");
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        this.observedEffect = observedEffect;
        this.builtIns = builtIns2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableContextInfo collectFromSchema(@NotNull List<? extends ESEffect> schema) {
        void $this$fold$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Iterable $this$mapNotNull$iv = schema;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MutableContextInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ESEffect it = (ESEffect)element$iv$iv;
            boolean bl2 = false;
            if (this.collectFromEffect(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        MutableContextInfo initial$iv = MutableContextInfo.Companion.getEMPTY();
        boolean $i$f$fold = false;
        MutableContextInfo accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void clauseInfo;
            MutableContextInfo $i$f$forEach2 = (MutableContextInfo)element$iv;
            MutableContextInfo resultingInfo = accumulator$iv;
            boolean bl = false;
            accumulator$iv = resultingInfo.and((MutableContextInfo)clauseInfo);
        }
        return accumulator$iv;
    }

    private final MutableContextInfo collectFromEffect(ESEffect effect) {
        MutableContextInfo mutableContextInfo;
        if (!(effect instanceof ConditionalEffect)) {
            return MutableContextInfo.Companion.getEMPTY().fire(effect);
        }
        Boolean bl = this.observedEffect.isImplies(((ConditionalEffect)effect).getSimpleEffect());
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            mutableContextInfo = (MutableContextInfo)((ConditionalEffect)effect).getCondition().accept(this);
        } else {
            Boolean bl2 = bl;
            if (bl2 == null ? true : Intrinsics.areEqual((Object)bl2, (Object)false)) {
                mutableContextInfo = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mutableContextInfo;
    }

    @Override
    @NotNull
    public MutableContextInfo visitIs(@NotNull ESIs isOperator) {
        Intrinsics.checkNotNullParameter((Object)isOperator, (String)"isOperator");
        ESIs $this$visitIs_u24lambda_u242 = isOperator;
        boolean bl = false;
        KotlinType isType = $this$visitIs_u24lambda_u242.getType().toKotlinType(this.builtIns);
        return $this$visitIs_u24lambda_u242.getFunctor().isNegated() != this.isInverted ? MutableContextInfo.Companion.getEMPTY().notSubtype($this$visitIs_u24lambda_u242.getLeft(), isType) : MutableContextInfo.Companion.getEMPTY().subtype($this$visitIs_u24lambda_u242.getLeft(), isType);
    }

    @Override
    @NotNull
    public MutableContextInfo visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkNotNullParameter((Object)equal, (String)"equal");
        ESEqual $this$visitEqual_u24lambda_u243 = equal;
        boolean bl = false;
        return $this$visitEqual_u24lambda_u243.getFunctor().isNegated() != this.isInverted ? MutableContextInfo.Companion.getEMPTY().notEqual($this$visitEqual_u24lambda_u243.getLeft(), $this$visitEqual_u24lambda_u243.getRight()) : MutableContextInfo.Companion.getEMPTY().equal($this$visitEqual_u24lambda_u243.getLeft(), $this$visitEqual_u24lambda_u243.getRight());
    }

    @Override
    @NotNull
    public MutableContextInfo visitAnd(@NotNull ESAnd and) {
        Intrinsics.checkNotNullParameter((Object)and, (String)"and");
        MutableContextInfo leftInfo = (MutableContextInfo)and.getLeft().accept(this);
        MutableContextInfo rightInfo = (MutableContextInfo)and.getRight().accept(this);
        return this.isInverted ? leftInfo.or(rightInfo) : leftInfo.and(rightInfo);
    }

    @Override
    @NotNull
    public MutableContextInfo visitNot(@NotNull ESNot not) {
        Intrinsics.checkNotNullParameter((Object)not, (String)"not");
        return (MutableContextInfo)this.inverted((Function0)new Function0<MutableContextInfo>(not, this){
            final /* synthetic */ ESNot $not;
            final /* synthetic */ InfoCollector this$0;
            {
                this.$not = $not;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MutableContextInfo invoke() {
                return (MutableContextInfo)this.$not.getArg().accept(this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public MutableContextInfo visitOr(@NotNull ESOr or2) {
        Intrinsics.checkNotNullParameter((Object)or2, (String)"or");
        MutableContextInfo leftInfo = (MutableContextInfo)or2.getLeft().accept(this);
        MutableContextInfo rightInfo = (MutableContextInfo)or2.getRight().accept(this);
        return this.isInverted ? leftInfo.and(rightInfo) : leftInfo.or(rightInfo);
    }

    @Override
    @NotNull
    public MutableContextInfo visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkNotNullParameter((Object)esVariable, (String)"esVariable");
        ESType it = esVariable.getType();
        boolean bl = false;
        return !TypesKt.isBoolean(it) ? MutableContextInfo.Companion.getEMPTY() : MutableContextInfo.Companion.getEMPTY().equal(esVariable, ESConstants.INSTANCE.booleanValue(!this.isInverted));
    }

    @Override
    @NotNull
    public MutableContextInfo visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkNotNullParameter((Object)esConstant, (String)"esConstant");
        return MutableContextInfo.Companion.getEMPTY();
    }

    @Override
    @NotNull
    public MutableContextInfo visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkNotNullParameter((Object)esReceiver, (String)"esReceiver");
        return MutableContextInfo.Companion.getEMPTY();
    }

    @Override
    @NotNull
    public MutableContextInfo visitLambda(@NotNull ESValue lambda2) {
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        return MutableContextInfo.Companion.getEMPTY();
    }

    private final <R> R inverted(Function0<? extends R> block) {
        this.isInverted = !this.isInverted;
        Object result2 = block.invoke();
        this.isInverted = !this.isInverted;
        return (R)result2;
    }
}

