/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.File;
import net.i2p.crypto.ChaCha20;
import net.i2p.crypto.EncType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class BuildMessageProcessor {
    private final RouterContext ctx;
    private final Log log;
    private final DecayingBloomFilter _filter;

    public BuildMessageProcessor(RouterContext ctx) {
        this.ctx = ctx;
        this.log = ctx.logManager().getLog(this.getClass());
        this._filter = this.selectFilter();
    }

    private DecayingBloomFilter selectFilter() {
        int duration;
        boolean isEC;
        long maxMemory = SystemVersion.getMaxMemory();
        int m = SystemVersion.isAndroid() || SystemVersion.isARM() || maxMemory < 0x6000000L ? 17 : (this.ctx.getProperty("router.maxParticipatingTunnels", 10000) > 10000 && maxMemory > 0x10000000L ? 23 : (maxMemory > 0x10000000L ? 22 : (maxMemory > 0x8000000L ? 21 : 19)));
        File f = new File(this.ctx.getConfigDir(), "router.keys.dat");
        boolean bl = isEC = f.length() < 663L;
        if (isEC) {
            duration = 480000;
            m = Math.max(m - 3, 17);
        } else {
            duration = 3600000;
        }
        if (this.log.shouldInfo()) {
            this.log.info("Selected Bloom filter m = " + m);
        }
        return new DecayingBloomFilter(this.ctx, duration, 32, "TunnelBMP", m);
    }

    public BuildRequestRecord decrypt(TunnelBuildMessage msg, Hash ourHash, PrivateKey privKey) {
        EncryptedBuildRecord data;
        int i;
        byte[] iv;
        BuildRequestRecord rv = null;
        int ourHop = -1;
        byte[] ourHashData = ourHash.getData();
        boolean isShort = msg.getType() == 25;
        for (int i2 = 0; i2 < msg.getRecordCount(); ++i2) {
            EncryptedBuildRecord rec = msg.getRecord(i2);
            boolean eq = DataHelper.eq(ourHashData, 0, rec.getData(), 0, 16);
            if (!eq) continue;
            try {
                rv = new BuildRequestRecord(this.ctx, privKey, rec);
                if (isShort) {
                    SessionKey sk = rv.getChaChaReplyKey();
                    boolean isDup = this._filter.add(sk.getData(), 0, 32);
                    if (isDup) {
                        if (this.log.shouldWarn()) {
                            this.log.warn(msg.getUniqueId() + ": Dup record: " + rv);
                        }
                        this.ctx.statManager().addRateData("tunnel.buildRequestDup", 1L);
                        return null;
                    }
                } else {
                    boolean isBad = SessionKey.INVALID_KEY.equals(rv.readReplyKey());
                    if (isBad) {
                        if (this.log.shouldLog(30)) {
                            this.log.warn(msg.getUniqueId() + ": Bad reply key: " + rv);
                        }
                        this.ctx.statManager().addRateData("tunnel.buildRequestBadReplyKey", 1L);
                        return null;
                    }
                    boolean isEC = this.ctx.keyManager().getPrivateKey().getType() == EncType.ECIES_X25519;
                    int off = isEC ? 104 : 136;
                    boolean isDup = this._filter.add(rv.getData(), off, 32);
                    if (isDup) {
                        if (this.log.shouldLog(30)) {
                            this.log.warn(msg.getUniqueId() + ": Dup record: " + rv);
                        }
                        this.ctx.statManager().addRateData("tunnel.buildRequestDup", 1L);
                        return null;
                    }
                }
                if (this.log.shouldLog(10)) {
                    this.log.debug(msg.getUniqueId() + ": Matching record: " + rv);
                }
                ourHop = i2;
                break;
            }
            catch (DataFormatException dfe) {
                if (!this.log.shouldLog(30)) continue;
                this.log.warn(msg.getUniqueId() + ": Matching record decrypt failure " + (Object)((Object)privKey.getType()), dfe);
            }
        }
        if (rv == null) {
            if (this.log.shouldLog(30)) {
                this.log.warn(msg.getUniqueId() + ": No record decrypted");
            }
            return null;
        }
        if (isShort) {
            byte[] replyKey = rv.getChaChaReplyKey().getData();
            iv = new byte[12];
            for (i = 0; i < msg.getRecordCount(); ++i) {
                if (i == ourHop) continue;
                data = msg.getRecord(i);
                byte[] bytes = data.getData();
                iv[4] = (byte)i;
                ChaCha20.encrypt(replyKey, iv, bytes, 0, bytes, 0, 218);
            }
        } else {
            SessionKey replyKey = rv.readReplyKey();
            iv = rv.readReplyIV();
            for (i = 0; i < msg.getRecordCount(); ++i) {
                if (i == ourHop) continue;
                data = msg.getRecord(i);
                byte[] bytes = data.getData();
                this.ctx.aes().encrypt(bytes, 0, bytes, 0, replyKey, iv, 0, 528);
            }
        }
        msg.setRecord(ourHop, null);
        return rv;
    }
}

