/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.GeneratorState;
import json.ext.RuntimeInfo;
import json.ext.StringEncoder;
import json.ext.Utils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class Generator {
    static final Handler<RubyBignum> BIGNUM_HANDLER = new Handler<RubyBignum>(){

        @Override
        void generate(Session session, RubyBignum rubyBignum, ByteList byteList) {
            byteList.append(((RubyString)rubyBignum.to_s(IRubyObject.NULL_ARRAY)).getByteList());
        }
    };
    static final Handler<RubyFixnum> FIXNUM_HANDLER = new Handler<RubyFixnum>(){

        @Override
        void generate(Session session, RubyFixnum rubyFixnum, ByteList byteList) {
            byteList.append(rubyFixnum.to_s().getByteList());
        }
    };
    static final Handler<RubyFloat> FLOAT_HANDLER = new Handler<RubyFloat>(){

        @Override
        void generate(Session session, RubyFloat rubyFloat, ByteList byteList) {
            double d = RubyFloat.num2dbl((IRubyObject)rubyFloat);
            if ((Double.isInfinite(d) || Double.isNaN(d)) && !session.getState().allowNaN()) {
                throw Utils.newException(session.getContext(), "GeneratorError", rubyFloat + " not allowed in JSON");
            }
            byteList.append(((RubyString)rubyFloat.to_s()).getByteList());
        }
    };
    static final Handler<RubyArray> ARRAY_HANDLER = new Handler<RubyArray>(){

        @Override
        int guessSize(Session session, RubyArray rubyArray) {
            GeneratorState generatorState = session.getState();
            int n = generatorState.getDepth();
            int n2 = 4 + (n + 1) * generatorState.getIndent().length() + 1 + generatorState.getArrayNl().length();
            return 2 + rubyArray.size() * n2;
        }

        @Override
        void generate(Session session, RubyArray rubyArray, ByteList byteList) {
            ThreadContext threadContext = session.getContext();
            Ruby ruby = threadContext.getRuntime();
            GeneratorState generatorState = session.getState();
            int n = generatorState.increaseDepth();
            ByteList byteList2 = generatorState.getIndent();
            byte[] byArray = Utils.repeat(byteList2, n);
            ByteList byteList3 = generatorState.getArrayNl();
            byte[] byArray2 = new byte[1 + byteList3.length()];
            byArray2[0] = 44;
            System.arraycopy(byteList3.unsafeBytes(), byteList3.begin(), byArray2, 1, byteList3.length());
            session.infectBy((IRubyObject)rubyArray);
            byteList.append((byte)91);
            byteList.append(byteList3);
            boolean bl = true;
            int n2 = rubyArray.getLength();
            for (int i = 0; i < n2; ++i) {
                IRubyObject iRubyObject = rubyArray.eltInternal(i);
                session.infectBy(iRubyObject);
                if (bl) {
                    bl = false;
                } else {
                    byteList.append(byArray2);
                }
                byteList.append(byArray);
                Handler handler = Generator.getHandlerFor(ruby, iRubyObject);
                handler.generate(session, iRubyObject, byteList);
            }
            generatorState.decreaseDepth();
            if (byteList3.length() != 0) {
                byteList.append(byteList3);
                byteList.append(byArray, 0, generatorState.getDepth() * byteList2.length());
            }
            byteList.append((byte)93);
        }
    };
    static final Handler<RubyHash> HASH_HANDLER = new Handler<RubyHash>(){

        @Override
        int guessSize(Session session, RubyHash rubyHash) {
            GeneratorState generatorState = session.getState();
            int n = 12 + (generatorState.getDepth() + 1) * generatorState.getIndent().length() + generatorState.getSpaceBefore().length() + generatorState.getSpace().length();
            return 2 + rubyHash.size() * n;
        }

        @Override
        void generate(final Session session, RubyHash rubyHash, final ByteList byteList) {
            ThreadContext threadContext = session.getContext();
            final Ruby ruby = threadContext.getRuntime();
            GeneratorState generatorState = session.getState();
            int n = generatorState.increaseDepth();
            final ByteList byteList2 = generatorState.getObjectNl();
            final byte[] byArray = Utils.repeat(generatorState.getIndent(), n);
            final ByteList byteList3 = generatorState.getSpaceBefore();
            final ByteList byteList4 = generatorState.getSpace();
            byteList.append((byte)123);
            byteList.append(byteList2);
            final boolean[] blArray = new boolean[]{true};
            rubyHash.visitAll(new RubyHash.Visitor(this){
                final /* synthetic */ 5 this$0;
                {
                    this.this$0 = var1_1;
                }

                public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                    if (blArray[0]) {
                        blArray[0] = false;
                    } else {
                        byteList.append((byte)44);
                        byteList.append(byteList2);
                    }
                    if (byteList2.length() != 0) {
                        byteList.append(byArray);
                    }
                    STRING_HANDLER.generate(session, iRubyObject.asString(), byteList);
                    session.infectBy(iRubyObject);
                    byteList.append(byteList3);
                    byteList.append((byte)58);
                    byteList.append(byteList4);
                    Handler handler = Generator.getHandlerFor(ruby, iRubyObject2);
                    handler.generate(session, iRubyObject2, byteList);
                    session.infectBy(iRubyObject2);
                }
            });
            generatorState.decreaseDepth();
            if (!blArray[0] && byteList2.length() != 0) {
                byteList.append(byteList2);
            }
            byteList.append(Utils.repeat(generatorState.getIndent(), generatorState.getDepth()));
            byteList.append((byte)125);
        }
    };
    static final Handler<RubyString> STRING_HANDLER = new Handler<RubyString>(){

        @Override
        int guessSize(Session session, RubyString rubyString) {
            return 2 + rubyString.getByteList().length();
        }

        @Override
        void generate(Session session, RubyString rubyString, ByteList byteList) {
            RuntimeInfo runtimeInfo = session.getInfo();
            RubyString rubyString2 = rubyString.encoding(session.getContext()) != runtimeInfo.utf8.get() ? (RubyString)rubyString.encode(session.getContext(), (IRubyObject)runtimeInfo.utf8.get()) : rubyString;
            session.getStringEncoder().encode(rubyString2.getByteList(), byteList);
        }
    };
    static final Handler<RubyBoolean> TRUE_HANDLER = new KeywordHandler<RubyBoolean>("true");
    static final Handler<RubyBoolean> FALSE_HANDLER = new KeywordHandler<RubyBoolean>("false");
    static final Handler<IRubyObject> NIL_HANDLER = new KeywordHandler<IRubyObject>("null");
    static final Handler<IRubyObject> OBJECT_HANDLER = new Handler<IRubyObject>(){

        @Override
        RubyString generateNew(Session session, IRubyObject iRubyObject) {
            RubyString rubyString = iRubyObject.asString();
            return STRING_HANDLER.generateNew(session, rubyString);
        }

        @Override
        void generate(Session session, IRubyObject iRubyObject, ByteList byteList) {
            RubyString rubyString = iRubyObject.asString();
            STRING_HANDLER.generate(session, rubyString, byteList);
        }
    };
    static final Handler<IRubyObject> GENERIC_HANDLER = new Handler<IRubyObject>(){

        @Override
        RubyString generateNew(Session session, IRubyObject iRubyObject) {
            if (session.getState().strict()) {
                throw Utils.newException(session.getContext(), "GeneratorError", iRubyObject + " not allowed in JSON");
            }
            if (iRubyObject.respondsTo("to_json")) {
                IRubyObject iRubyObject2 = iRubyObject.callMethod(session.getContext(), "to_json", new IRubyObject[]{session.getState()});
                if (iRubyObject2 instanceof RubyString) {
                    return (RubyString)iRubyObject2;
                }
                throw session.getRuntime().newTypeError("to_json must return a String");
            }
            return OBJECT_HANDLER.generateNew(session, iRubyObject);
        }

        @Override
        void generate(Session session, IRubyObject iRubyObject, ByteList byteList) {
            RubyString rubyString = this.generateNew(session, iRubyObject);
            byteList.append(rubyString.getByteList());
        }
    };

    private Generator() {
        throw new RuntimeException();
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, Handler<? super T> handler, IRubyObject[] iRubyObjectArray) {
        Session session = new Session(threadContext, iRubyObjectArray.length > 0 ? iRubyObjectArray[0] : null);
        return session.infect(handler.generateNew(session, t));
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, IRubyObject[] iRubyObjectArray) {
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        return Generator.generateJson(threadContext, t, handler, iRubyObjectArray);
    }

    public static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, GeneratorState generatorState) {
        Session session = new Session(threadContext, generatorState);
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        return handler.generateNew(session, t);
    }

    private static <T extends IRubyObject> Handler<? super T> getHandlerFor(Ruby ruby, T t) {
        switch (((RubyBasicObject)t).getNativeClassIndex()) {
            case NIL: {
                return NIL_HANDLER;
            }
            case TRUE: {
                return TRUE_HANDLER;
            }
            case FALSE: {
                return FALSE_HANDLER;
            }
            case FLOAT: {
                return FLOAT_HANDLER;
            }
            case FIXNUM: {
                return FIXNUM_HANDLER;
            }
            case BIGNUM: {
                return BIGNUM_HANDLER;
            }
            case STRING: {
                if (((RubyBasicObject)t).getMetaClass() != ruby.getString()) break;
                return STRING_HANDLER;
            }
            case ARRAY: {
                if (((RubyBasicObject)t).getMetaClass() != ruby.getArray()) break;
                return ARRAY_HANDLER;
            }
            case HASH: {
                if (((RubyBasicObject)t).getMetaClass() != ruby.getHash()) break;
                return HASH_HANDLER;
            }
        }
        return GENERIC_HANDLER;
    }

    private static abstract class Handler<T extends IRubyObject> {
        private Handler() {
        }

        int guessSize(Session session, T t) {
            return 4;
        }

        RubyString generateNew(Session session, T t) {
            ByteList byteList = new ByteList(this.guessSize(session, t));
            this.generate(session, t, byteList);
            RubyString rubyString = RubyString.newString((Ruby)session.getRuntime(), (ByteList)byteList);
            ThreadContext threadContext = session.getContext();
            RuntimeInfo runtimeInfo = session.getInfo();
            rubyString.force_encoding(threadContext, (IRubyObject)runtimeInfo.utf8.get());
            return rubyString;
        }

        abstract void generate(Session var1, T var2, ByteList var3);
    }

    static class Session {
        private final ThreadContext context;
        private GeneratorState state;
        private IRubyObject possibleState;
        private RuntimeInfo info;
        private StringEncoder stringEncoder;
        private boolean tainted = false;
        private boolean untrusted = false;

        Session(ThreadContext threadContext, GeneratorState generatorState) {
            this.context = threadContext;
            this.state = generatorState;
        }

        Session(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.context = threadContext;
            this.possibleState = iRubyObject == null || iRubyObject.isNil() ? null : iRubyObject;
        }

        public ThreadContext getContext() {
            return this.context;
        }

        public Ruby getRuntime() {
            return this.context.getRuntime();
        }

        public GeneratorState getState() {
            if (this.state == null) {
                this.state = GeneratorState.fromState(this.context, this.getInfo(), this.possibleState);
            }
            return this.state;
        }

        public RuntimeInfo getInfo() {
            if (this.info == null) {
                this.info = RuntimeInfo.forRuntime(this.getRuntime());
            }
            return this.info;
        }

        public StringEncoder getStringEncoder() {
            if (this.stringEncoder == null) {
                this.stringEncoder = new StringEncoder(this.context, this.getState().asciiOnly(), this.getState().scriptSafe());
            }
            return this.stringEncoder;
        }

        public void infectBy(IRubyObject iRubyObject) {
            if (iRubyObject.isTaint()) {
                this.tainted = true;
            }
            if (iRubyObject.isUntrusted()) {
                this.untrusted = true;
            }
        }

        public <T extends IRubyObject> T infect(T t) {
            if (this.tainted) {
                t.setTaint(true);
            }
            if (this.untrusted) {
                t.setUntrusted(true);
            }
            return t;
        }
    }

    private static class KeywordHandler<T extends IRubyObject>
    extends Handler<T> {
        private final ByteList keyword;

        private KeywordHandler(String string) {
            this.keyword = new ByteList(ByteList.plain((CharSequence)string), false);
        }

        @Override
        int guessSize(Session session, T t) {
            return this.keyword.length();
        }

        @Override
        RubyString generateNew(Session session, T t) {
            return RubyString.newStringShared((Ruby)session.getRuntime(), (ByteList)this.keyword);
        }

        @Override
        void generate(Session session, T t, ByteList byteList) {
            byteList.append(this.keyword);
        }
    }
}

