/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Row;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BaseActivation;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class GenericActivationHolder
implements Activation {
    public BaseActivation ac;
    ExecPreparedStatement ps;
    GeneratedClass gc;
    DataTypeDescriptor[] paramTypes;
    private final LanguageConnectionContext lcc;

    GenericActivationHolder(LanguageConnectionContext lcc, GeneratedClass gc, ExecPreparedStatement ps, boolean scrollable) throws StandardException {
        this.lcc = lcc;
        SanityManager.ASSERT((gc != null ? 1 : 0) != 0, (String)("generated class is null , ps is a " + ps.getClass()));
        this.gc = gc;
        this.ps = ps;
        this.ac = (BaseActivation)gc.newInstance(lcc);
        this.ac.setupActivation(ps, scrollable);
        this.paramTypes = ps.getParameterTypes();
    }

    @Override
    public void reset() throws StandardException {
        this.ac.reset();
    }

    @Override
    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        return this.ac.checkIfThisActivationHasHoldCursor(tableName);
    }

    @Override
    public void setCursorName(String cursorName) {
        this.ac.setCursorName(cursorName);
    }

    @Override
    public String getCursorName() {
        return this.ac.getCursorName();
    }

    @Override
    public void setResultSetHoldability(boolean resultSetHoldability) {
        this.ac.setResultSetHoldability(resultSetHoldability);
    }

    @Override
    public boolean getResultSetHoldability() {
        return this.ac.getResultSetHoldability();
    }

    @Override
    public void setAutoGeneratedKeysResultsetInfo(int[] columnIndexes, String[] columnNames) {
        this.ac.setAutoGeneratedKeysResultsetInfo(columnIndexes, columnNames);
    }

    @Override
    public boolean getAutoGeneratedKeysResultsetMode() {
        return this.ac.getAutoGeneratedKeysResultsetMode();
    }

    @Override
    public int[] getAutoGeneratedKeysColumnIndexes() {
        return this.ac.getAutoGeneratedKeysColumnIndexes();
    }

    @Override
    public String[] getAutoGeneratedKeysColumnNames() {
        return this.ac.getAutoGeneratedKeysColumnNames();
    }

    @Override
    public LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    @Override
    public TransactionController getTransactionController() {
        return this.ac.getTransactionController();
    }

    @Override
    public ExecutionFactory getExecutionFactory() {
        return this.ac.getExecutionFactory();
    }

    @Override
    public ParameterValueSet getParameterValueSet() {
        return this.ac.getParameterValueSet();
    }

    @Override
    public void setParameters(ParameterValueSet parameterValues, DataTypeDescriptor[] parameterTypes) throws StandardException {
        this.ac.setParameters(parameterValues, parameterTypes);
    }

    @Override
    public ResultSet execute() throws StandardException {
        CursorActivation activeCursor;
        String cursorName;
        boolean needNewClass;
        boolean bl = needNewClass = this.gc == null || this.gc != this.ps.getActivationClass();
        if (needNewClass || !this.ac.isValid()) {
            GeneratedClass newGC;
            if (needNewClass) {
                newGC = this.ps.getActivationClass();
                if (newGC == null) {
                    throw StandardException.newException((String)"XCL32.S", (Object[])new Object[0]);
                }
            } else {
                newGC = this.gc;
            }
            BaseActivation newAC = (BaseActivation)newGC.newInstance(this.lcc);
            DataTypeDescriptor[] newParamTypes = this.ps.getParameterTypes();
            newAC.setupActivation(this.ps, this.ac.getScrollable());
            newAC.setParameters(this.ac.getParameterValueSet(), this.paramTypes);
            if (this.ac.isSingleExecution()) {
                newAC.setSingleExecution();
            }
            newAC.setCursorName(this.ac.getCursorName());
            newAC.setResultSetHoldability(this.ac.getResultSetHoldability());
            if (this.ac.getAutoGeneratedKeysResultsetMode()) {
                newAC.setAutoGeneratedKeysResultsetInfo(this.ac.getAutoGeneratedKeysColumnIndexes(), this.ac.getAutoGeneratedKeysColumnNames());
            }
            newAC.setMaxRows(this.ac.getMaxRows());
            this.ac.setupActivation(null, false);
            this.ac.close();
            this.ac = newAC;
            this.gc = newGC;
            this.paramTypes = newParamTypes;
        }
        if ((cursorName = this.ac.getCursorName()) != null && (activeCursor = this.lcc.lookupCursorActivation(cursorName)) != null && activeCursor != this.ac) {
            throw StandardException.newException((String)"X0X60.S", (Object[])new Object[]{cursorName});
        }
        return this.ac.execute();
    }

    @Override
    public ResultSet getResultSet() {
        return this.ac.getResultSet();
    }

    @Override
    public void setCurrentRow(ExecRow currentRow, int resultSetNumber) {
        this.ac.setCurrentRow(currentRow, resultSetNumber);
    }

    @Override
    public Row getCurrentRow(int resultSetNumber) {
        return this.ac.getCurrentRow(resultSetNumber);
    }

    @Override
    public void clearCurrentRow(int resultSetNumber) {
        this.ac.clearCurrentRow(resultSetNumber);
    }

    @Override
    public ExecPreparedStatement getPreparedStatement() {
        return this.ps;
    }

    @Override
    public void checkStatementValidity() throws StandardException {
        this.ac.checkStatementValidity();
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.ac.getResultDescription();
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.ac.getDataValueFactory();
    }

    @Override
    public RowLocation getRowLocationTemplate(int itemNumber) {
        return this.ac.getRowLocationTemplate(itemNumber);
    }

    @Override
    public ConglomerateController getHeapConglomerateController() {
        return this.ac.getHeapConglomerateController();
    }

    @Override
    public void setHeapConglomerateController(ConglomerateController updateHeapCC) {
        this.ac.setHeapConglomerateController(updateHeapCC);
    }

    @Override
    public void clearHeapConglomerateController() {
        this.ac.clearHeapConglomerateController();
    }

    @Override
    public ScanController getIndexScanController() {
        return this.ac.getIndexScanController();
    }

    @Override
    public void setIndexScanController(ScanController indexSC) {
        this.ac.setIndexScanController(indexSC);
    }

    @Override
    public long getIndexConglomerateNumber() {
        return this.ac.getIndexConglomerateNumber();
    }

    @Override
    public void setIndexConglomerateNumber(long indexConglomerateNumber) {
        this.ac.setIndexConglomerateNumber(indexConglomerateNumber);
    }

    @Override
    public void clearIndexScanInfo() {
        this.ac.clearIndexScanInfo();
    }

    @Override
    public void close() throws StandardException {
        this.ac.close();
    }

    @Override
    public boolean isClosed() {
        return this.ac.isClosed();
    }

    @Override
    public void setSingleExecution() {
        this.ac.setSingleExecution();
    }

    @Override
    public boolean isSingleExecution() {
        return this.ac.isSingleExecution();
    }

    @Override
    public int getNumSubqueries() {
        return this.ac.getNumSubqueries();
    }

    @Override
    public void setForCreateTable() {
        this.ac.setForCreateTable();
    }

    @Override
    public boolean getForCreateTable() {
        return this.ac.getForCreateTable();
    }

    @Override
    public void setDDLTableDescriptor(TableDescriptor td) {
        this.ac.setDDLTableDescriptor(td);
    }

    @Override
    public TableDescriptor getDDLTableDescriptor() {
        return this.ac.getDDLTableDescriptor();
    }

    @Override
    public void setMaxRows(long maxRows) {
        this.ac.setMaxRows(maxRows);
    }

    @Override
    public long getMaxRows() {
        return this.ac.getMaxRows();
    }

    @Override
    public void setTargetVTI(java.sql.ResultSet targetVTI) {
        this.ac.setTargetVTI(targetVTI);
    }

    @Override
    public java.sql.ResultSet getTargetVTI() {
        return this.ac.getTargetVTI();
    }

    @Override
    public SQLSessionContext getSQLSessionContextForChildren() {
        return this.ac.getSQLSessionContextForChildren();
    }

    @Override
    public SQLSessionContext setupSQLSessionContextForChildren(boolean push) {
        return this.ac.setupSQLSessionContextForChildren(push);
    }

    @Override
    public void setParentActivation(Activation a) {
        this.ac.setParentActivation(a);
    }

    @Override
    public Activation getParentActivation() {
        return this.ac.getParentActivation();
    }

    @Override
    public DependableFinder getDependableFinder() {
        SanityManager.NOTREACHED();
        return null;
    }

    @Override
    public String getObjectName() {
        SanityManager.NOTREACHED();
        return null;
    }

    @Override
    public UUID getObjectID() {
        SanityManager.NOTREACHED();
        return null;
    }

    @Override
    public String getClassType() {
        SanityManager.NOTREACHED();
        return null;
    }

    @Override
    public boolean isPersistent() {
        SanityManager.NOTREACHED();
        return false;
    }

    @Override
    public boolean isValid() {
        SanityManager.NOTREACHED();
        return false;
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        SanityManager.NOTREACHED();
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        SanityManager.NOTREACHED();
    }

    @Override
    public void markUnused() {
        this.ac.markUnused();
    }

    @Override
    public boolean isInUse() {
        return this.ac.isInUse();
    }

    @Override
    public void addWarning(SQLWarning w) {
        this.ac.addWarning(w);
    }

    @Override
    public SQLWarning getWarnings() {
        return this.ac.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.ac.clearWarnings();
    }

    @Override
    public void informOfRowCount(NoPutResultSet resultSet, long rowCount) throws StandardException {
        this.ac.informOfRowCount(resultSet, rowCount);
    }

    @Override
    public boolean isCursorActivation() {
        return this.ac.isCursorActivation();
    }

    @Override
    public ConstantAction pushConstantAction(ConstantAction newConstantAction) {
        return this.ac.pushConstantAction(newConstantAction);
    }

    @Override
    public ConstantAction popConstantAction() {
        return this.ac.popConstantAction();
    }

    @Override
    public ConstantAction getConstantAction() {
        return this.ac.getConstantAction();
    }

    @Override
    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        this.ac.setParentResultSet(rs, resultSetId);
    }

    @Override
    public Vector<TemporaryRowHolder> getParentResultSet(String resultSetId) {
        return this.ac.getParentResultSet(resultSetId);
    }

    @Override
    public void clearParentResultSets() {
        this.ac.clearParentResultSets();
    }

    @Override
    public Enumeration<String> getParentResultSetKeys() {
        return this.ac.getParentResultSetKeys();
    }

    @Override
    public void setForUpdateIndexScan(CursorResultSet forUpdateResultSet) {
        this.ac.setForUpdateIndexScan(forUpdateResultSet);
    }

    @Override
    public CursorResultSet getForUpdateIndexScan() {
        return this.ac.getForUpdateIndexScan();
    }

    @Override
    public java.sql.ResultSet[][] getDynamicResults() {
        return this.ac.getDynamicResults();
    }

    @Override
    public int getMaxDynamicResults() {
        return this.ac.getMaxDynamicResults();
    }

    @Override
    public NumberDataValue getCurrentValueAndAdvance(String sequenceUUIDstring, int typeFormatID) throws StandardException {
        return this.ac.getCurrentValueAndAdvance(sequenceUUIDstring, typeFormatID);
    }
}

