/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class OrderByList
extends OrderedColumnList<OrderByColumn>
implements RequiredRowOrdering {
    private boolean allAscending = true;
    private boolean alwaysSort;
    private ResultSetNode resultToSort;
    private SortCostController scc;
    private Object[] resultRow;
    private ColumnOrdering[] columnOrdering;
    private int estimatedRowSize;
    private boolean sortNeeded = true;
    private int resultSetNumber = -1;
    private boolean isTableValueCtorOrdering;

    OrderByList(ResultSetNode rs, ContextManager cm) {
        super(OrderByColumn.class, cm);
        this.isTableValueCtorOrdering = rs instanceof UnionNode && ((UnionNode)rs).tableConstructor() || rs instanceof RowResultSetNode;
    }

    void addOrderByColumn(OrderByColumn column) {
        this.addElement(column);
        if (!column.isAscending()) {
            this.allAscending = false;
        }
    }

    boolean allAscending() {
        return this.allAscending;
    }

    OrderByColumn getOrderByColumn(int position) {
        SanityManager.ASSERT((position >= 0 && position < this.size() ? 1 : 0) != 0);
        return (OrderByColumn)this.elementAt(position);
    }

    void bindOrderByColumns(ResultSetNode target) throws StandardException {
        this.resultToSort = target;
        if (this.size() > 1012) {
            throw StandardException.newException((String)"54004", (Object[])new Object[0]);
        }
        for (OrderByColumn obc : this) {
            obc.bindOrderByColumn(target, this);
            if (obc.getResultColumn().getExpression() instanceof ColumnReference) continue;
            this.alwaysSort = true;
        }
    }

    void closeGap(int gap) {
        for (OrderByColumn obc : this) {
            obc.collapseAddedColumnGap(gap);
        }
    }

    void pullUpOrderByColumns(ResultSetNode target) throws StandardException {
        this.resultToSort = target;
        for (OrderByColumn obc : this) {
            obc.pullUpOrderByColumn(target);
        }
    }

    boolean isInOrderPrefix(ResultColumnList sourceRCL) {
        int rclSize = sourceRCL.size();
        if (this.size() > rclSize) {
            SanityManager.THROWASSERT((String)("size() (" + this.size() + ") expected to be <= sourceRCL.size() (" + sourceRCL.size() + ")"));
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((OrderByColumn)this.elementAt(index)).getResultColumn() == sourceRCL.elementAt(index)) continue;
            return false;
        }
        return true;
    }

    void resetToSourceRCs() {
        for (OrderByColumn obc : this) {
            obc.resetToSourceRC();
        }
    }

    ResultColumnList reorderRCL(ResultColumnList resultColumns) throws StandardException {
        ResultColumnList newRCL = new ResultColumnList(this.getContextManager());
        for (OrderByColumn obc : this) {
            newRCL.addElement(obc.getResultColumn());
            resultColumns.removeElement(obc.getResultColumn());
        }
        newRCL.destructiveAppend(resultColumns);
        newRCL.resetVirtualColumnIds();
        newRCL.copyOrderBySelect(resultColumns);
        return newRCL;
    }

    void removeConstantColumns(PredicateList whereClause) {
        for (int loc = this.size() - 1; loc >= 0; --loc) {
            if (!((OrderByColumn)this.elementAt(loc)).constantColumn(whereClause)) continue;
            this.removeElementAt(loc);
        }
    }

    void removeDupColumns() {
        block0: for (int loc = this.size() - 1; loc > 0; --loc) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(loc);
            int colPosition = obc.getColumnPosition();
            for (int inner = 0; inner < loc; ++inner) {
                OrderByColumn prev_obc = (OrderByColumn)this.elementAt(inner);
                if (colPosition != prev_obc.getColumnPosition()) continue;
                this.removeElementAt(loc);
                continue block0;
            }
        }
    }

    void generate(ActivationClassBuilder acb, MethodBuilder mb, ResultSetNode child) throws StandardException {
        if (!this.sortNeeded) {
            child.generate(acb, mb);
            return;
        }
        CompilerContext cc = this.getCompilerContext();
        int orderItem = acb.addItem(acb.getColumnOrdering(this));
        acb.pushGetResultSetFactoryExpression(mb);
        child.generate(acb, mb);
        this.resultSetNumber = cc.getNextResultSetNumber();
        mb.push(false);
        mb.push(false);
        mb.push(orderItem);
        mb.push(acb.addItem(child.getResultColumns().buildRowTemplate()));
        mb.push(child.getResultColumns().getTotalColumnSize());
        mb.push(this.resultSetNumber);
        CostEstimate costEstimate = child.getFinalCostEstimate();
        mb.push(costEstimate.rowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getSortResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering, OptimizableList optimizableList, int[] proposedJoinOrder) throws StandardException {
        return this.sortRequired(rowOrdering, null, optimizableList, proposedJoinOrder);
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering, JBitSet tableMap, OptimizableList optimizableList, int[] proposedJoinOrder) throws StandardException {
        if (this.alwaysSort) {
            return 1;
        }
        int position = 0;
        int size = this.size();
        for (int loc = 0; loc < size; ++loc) {
            boolean moreThanOneTableInJoinOrder;
            OrderByColumn obc = this.getOrderByColumn(loc);
            if (obc.isNullsOrderedLow()) {
                return 1;
            }
            ValueNode expr = obc.getResultColumn().getExpression();
            if (!(expr instanceof ColumnReference)) {
                return 1;
            }
            ColumnReference cr = (ColumnReference)expr;
            if (tableMap != null && !tableMap.get(cr.getTableNumber())) {
                for (int remainingPosition = loc + 1; remainingPosition < this.size(); ++remainingPosition) {
                    ColumnReference remainingcr;
                    OrderByColumn remainingobc = this.getOrderByColumn(loc);
                    ResultColumn remainingrc = remainingobc.getResultColumn();
                    ValueNode remainingexpr = remainingrc.getExpression();
                    if (!(remainingexpr instanceof ColumnReference) || !tableMap.get((remainingcr = (ColumnReference)remainingexpr).getTableNumber())) continue;
                    return 1;
                }
                return 3;
            }
            boolean bl = tableMap != null ? !tableMap.hasSingleBitSet() : (moreThanOneTableInJoinOrder = false);
            if (moreThanOneTableInJoinOrder && !rowOrdering.alwaysOrdered(cr.getTableNumber()) && !rowOrdering.isColumnAlwaysOrdered(cr.getTableNumber(), cr.getColumnNumber())) {
                Optimizable considerOptimizable;
                for (int i = 0; i < proposedJoinOrder.length && proposedJoinOrder[i] != -1 && (considerOptimizable = optimizableList.getOptimizable(proposedJoinOrder[i])).getTableNumber() != cr.getTableNumber(); ++i) {
                    if (rowOrdering.alwaysOrdered(considerOptimizable.getTableNumber())) continue;
                    return 1;
                }
            }
            if (rowOrdering.alwaysOrdered(cr.getTableNumber())) continue;
            if (!rowOrdering.orderedOnColumn(obc.isAscending() ? 1 : 2, position, cr.getTableNumber(), cr.getColumnNumber())) {
                return 1;
            }
            ++position;
        }
        return 3;
    }

    @Override
    public void estimateCost(double estimatedInputRows, RowOrdering rowOrdering, CostEstimate resultCost) throws StandardException {
        long inputRows;
        if (this.scc == null) {
            this.scc = this.getCompilerContext().getSortCostController();
            this.resultRow = this.resultToSort.getResultColumns().buildEmptyRow().getRowArray();
            this.columnOrdering = this.getColumnOrdering();
            this.estimatedRowSize = this.resultToSort.getResultColumns().getTotalColumnSize();
        }
        long exportRows = inputRows = (long)estimatedInputRows;
        double sortCost = this.scc.getSortCost((DataValueDescriptor[])this.resultRow, this.columnOrdering, false, inputRows, exportRows, this.estimatedRowSize);
        resultCost.setCost(sortCost, estimatedInputRows, estimatedInputRows);
    }

    @Override
    public void sortNeeded() {
        this.sortNeeded = true;
    }

    @Override
    public void sortNotNeeded() {
        this.sortNeeded = false;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
    }

    @Override
    public boolean getSortNeeded() {
        return this.sortNeeded;
    }

    boolean requiresDescending(ColumnReference cRef, int numOptimizables) throws StandardException {
        int size = this.size();
        JBitSet tNum = new JBitSet(numOptimizables);
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tNum);
        cRef.accept(btnVis);
        int crTableNumber = tNum.getFirstSetBit();
        int crColPosition = btnVis.getColumnNumber();
        if (crTableNumber < 0 || crColPosition < 0) {
            SanityManager.THROWASSERT((String)("Failed to find table/column number for column '" + cRef.getColumnName() + "' when checking for an ORDER BY requirement."));
        }
        if (!tNum.hasSingleBitSet()) {
            SanityManager.THROWASSERT((String)("Expected ColumnReference '" + cRef.getColumnName() + "' to reference exactly one table, but tables found were: " + tNum));
        }
        for (int loc = 0; loc < size; ++loc) {
            OrderByColumn obc = this.getOrderByColumn(loc);
            ResultColumn rcOrderBy = obc.getResultColumn();
            btnVis.reset();
            rcOrderBy.accept(btnVis);
            int obTableNumber = tNum.getFirstSetBit();
            int obColPosition = btnVis.getColumnNumber();
            if (!tNum.hasSingleBitSet()) {
                SanityManager.THROWASSERT((String)("Expected ResultColumn '" + rcOrderBy.getColumnName() + "' to reference exactly one table, but found: " + tNum));
            }
            if (obColPosition < 0) {
                SanityManager.THROWASSERT((String)("Failed to find orderBy column number for ORDER BY check on column '" + cRef.getColumnName() + "'."));
            }
            if (crTableNumber != obTableNumber || crColPosition != obColPosition) continue;
            return !obc.isAscending();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.columnOrdering != null) {
            for (int i = 0; i < this.columnOrdering.length; ++i) {
                buff.append("[" + i + "] " + this.columnOrdering[i] + "\n");
            }
        }
        return "allAscending: " + this.allAscending + "\nalwaysSort:" + this.allAscending + "\nsortNeeded: " + this.sortNeeded + "\ncolumnOrdering: \n" + buff.toString() + "\n" + super.toString();
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public boolean isTableValueCtorOrdering() {
        return this.isTableValueCtorOrdering;
    }
}

