/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DDUtils;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class CreateConstraintConstantAction
extends ConstraintConstantAction {
    private final boolean forCreateTable;
    private String[] columnNames;
    private String constraintText;
    private ConstraintInfo otherConstraintInfo;
    private ClassFactory cf;
    private boolean enabled;
    private boolean[] characteristics;
    private ProviderInfo[] providerInfo;

    CreateConstraintConstantAction(String constraintName, int constraintType, boolean[] characteristics, boolean forCreateTable, String tableName, UUID tableId, String schemaName, String[] columnNames, IndexConstantAction indexAction, String constraintText, ConstraintInfo otherConstraint, ProviderInfo[] providerInfo) {
        super(constraintName, constraintType, tableName, tableId, schemaName, indexAction);
        this.forCreateTable = forCreateTable;
        this.columnNames = columnNames;
        this.constraintText = constraintText;
        this.characteristics = (boolean[])characteristics.clone();
        this.otherConstraintInfo = otherConstraint;
        this.providerInfo = providerInfo;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        ConglomerateDescriptor conglomDesc = null;
        ConglomerateDescriptor[] conglomDescs = null;
        Object conDesc = null;
        TableDescriptor td = null;
        UUID indexId = null;
        if (this.constraintType == 1) {
            return;
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        this.cf = lcc.getLanguageConnectionFactory().getClassFactory();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        td = activation.getDDLTableDescriptor();
        if (td == null) {
            td = this.tableId != null ? dd.getTableDescriptor(this.tableId) : dd.getTableDescriptor(this.tableName, sd, tc);
            if (td == null) {
                throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{this.tableName});
            }
            activation.setDDLTableDescriptor(td);
        }
        UUIDFactory uuidFactory = dd.getUUIDFactory();
        UUID constrId = uuidFactory.createUUID();
        if (this.indexAction != null) {
            String backingIndexName;
            if (this.indexAction.getIndexName() == null) {
                backingIndexName = uuidFactory.createUUID().toString();
                this.indexAction.setIndexName(backingIndexName);
            } else {
                backingIndexName = this.indexAction.getIndexName();
            }
            this.indexAction.setConstraintID(constrId);
            this.indexAction.executeConstantAction(activation);
            conglomDescs = td.getConglomerateDescriptors();
            for (int index = 0; !(index >= conglomDescs.length || (conglomDesc = conglomDescs[index]).isIndex() && backingIndexName.equals(conglomDesc.getConglomerateName())); ++index) {
            }
            SanityManager.ASSERT((conglomDesc != null ? 1 : 0) != 0, (String)"conglomDesc is expected to be non-null after search for backing index");
            SanityManager.ASSERT((boolean)conglomDesc.isIndex(), (String)"conglomDesc is expected to be indexable after search for backing index");
            SanityManager.ASSERT((boolean)conglomDesc.getConglomerateName().equals(backingIndexName), (String)"conglomDesc name expected to be the same as backing index name after search for backing index");
            indexId = conglomDesc.getUUID();
        }
        boolean[] defaults = new boolean[]{false, false, true};
        for (int i = 0; i < this.characteristics.length; ++i) {
            if (this.characteristics[i] == defaults[i]) continue;
            dd.checkVersion(230, "DEFERRED CONSTRAINTS");
            if (this.constraintType != 1 && this.characteristics[2] || PropertyUtil.getSystemProperty("derby.constraintsTesting", "false").equals("true")) continue;
            throw StandardException.newException((String)"0A000.S", (Object[])new Object[]{"non-default constraint characteristics"});
        }
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        switch (this.constraintType) {
            case 2: {
                conDesc = ddg.newPrimaryKeyConstraintDescriptor(td, this.constraintName, this.characteristics[0], this.characteristics[1], this.genColumnPositions(td, false), constrId, indexId, sd, this.characteristics[2], 0);
                dd.addConstraintDescriptor((ConstraintDescriptor)conDesc, tc);
                break;
            }
            case 3: {
                conDesc = ddg.newUniqueConstraintDescriptor(td, this.constraintName, this.characteristics[0], this.characteristics[1], this.genColumnPositions(td, false), constrId, indexId, sd, this.characteristics[2], 0);
                dd.addConstraintDescriptor((ConstraintDescriptor)conDesc, tc);
                break;
            }
            case 4: {
                conDesc = ddg.newCheckConstraintDescriptor(td, this.constraintName, this.characteristics[0], this.characteristics[1], constrId, this.constraintText, new ReferencedColumnsDescriptorImpl(this.genColumnPositions(td, false)), sd, this.characteristics[2]);
                dd.addConstraintDescriptor((ConstraintDescriptor)conDesc, tc);
                this.storeConstraintDependenciesOnPrivileges(activation, (Dependent)conDesc, null, this.providerInfo);
                break;
            }
            case 6: {
                ReferencedKeyConstraintDescriptor referencedConstraint = DDUtils.locateReferencedConstraint(dd, td, this.constraintName, this.columnNames, this.otherConstraintInfo);
                DDUtils.validateReferentialActions(dd, td, this.constraintName, this.otherConstraintInfo, this.columnNames);
                conDesc = ddg.newForeignKeyConstraintDescriptor(td, this.constraintName, this.characteristics[0], this.characteristics[1], this.genColumnPositions(td, false), constrId, indexId, sd, referencedConstraint, this.characteristics[2], this.otherConstraintInfo.getReferentialActionDeleteRule(), this.otherConstraintInfo.getReferentialActionUpdateRule());
                dd.addConstraintDescriptor((ConstraintDescriptor)conDesc, tc);
                if (!this.forCreateTable && dd.activeConstraint((ConstraintDescriptor)conDesc)) {
                    CreateConstraintConstantAction.validateFKConstraint(activation, tc, dd, (ForeignKeyConstraintDescriptor)conDesc, referencedConstraint, ((CreateIndexConstantAction)this.indexAction).getIndexTemplateRow());
                }
                dm.addDependency((Dependent)conDesc, referencedConstraint, lcc.getContextManager());
                this.storeConstraintDependenciesOnPrivileges(activation, (Dependent)conDesc, referencedConstraint.getTableId(), this.providerInfo);
                break;
            }
            case 7: {
                throw StandardException.newException((String)"0A000.S", (Object[])new Object[]{"ALTER CONSTRAINT"});
            }
            default: {
                SanityManager.THROWASSERT((String)("contraintType (" + this.constraintType + ") has unexpected value"));
            }
        }
        if (this.providerInfo != null) {
            for (int ix = 0; ix < this.providerInfo.length; ++ix) {
                Provider provider = null;
                provider = (Provider)this.providerInfo[ix].getDependableFinder().getDependable(dd, this.providerInfo[ix].getObjectId());
                dm.addDependency((Dependent)conDesc, provider, lcc.getContextManager());
            }
        }
        if (!this.forCreateTable) {
            dm.invalidateFor(td, 22, lcc);
        }
        if (this.constraintType == 6) {
            SanityManager.ASSERT((conDesc != null ? 1 : 0) != 0, (String)"conDesc expected to be non-null");
            if (!(conDesc instanceof ForeignKeyConstraintDescriptor)) {
                SanityManager.THROWASSERT((String)("conDesc expected to be instance of ForeignKeyConstraintDescriptor, not " + conDesc.getClass().getName()));
            }
            dm.invalidateFor(((ForeignKeyConstraintDescriptor)conDesc).getReferencedConstraint().getTableDescriptor(), 22, lcc);
        }
        this.constraintId = constrId;
    }

    boolean isForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    boolean isInitiallyDeferred() {
        return this.characteristics[1];
    }

    private int[] genColumnPositions(TableDescriptor td, boolean columnsMustBeOrderable) throws StandardException {
        int[] baseColumnPositions = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ColumnDescriptor columnDescriptor = td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException((String)"42X14", (Object[])new Object[]{this.columnNames[i], this.tableName});
            }
            if (columnsMustBeOrderable && !columnDescriptor.getType().getTypeId().orderable(this.cf)) {
                throw StandardException.newException((String)"X0X67.S", (Object[])new Object[]{columnDescriptor.getType().getTypeId().getSQLTypeName()});
            }
            baseColumnPositions[i] = columnDescriptor.getPosition();
        }
        return baseColumnPositions;
    }

    String getConstraintText() {
        return this.constraintText;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("CREATE CONSTRAINT " + this.constraintName);
        strbuf.append("\n=========================\n");
        if (this.columnNames == null) {
            strbuf.append("columnNames == null\n");
        } else {
            for (int ix = 0; ix < this.columnNames.length; ++ix) {
                strbuf.append("\n\tcol[" + ix + "]" + this.columnNames[ix].toString());
            }
        }
        strbuf.append("\n");
        strbuf.append(this.constraintText);
        strbuf.append("\n");
        if (this.otherConstraintInfo != null) {
            strbuf.append(this.otherConstraintInfo.toString());
        }
        strbuf.append("\n");
        return strbuf.toString();
    }
}

