/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.AggregateSortObserver;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class GroupedAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    private ColumnOrdering[] order;
    public boolean hasDistinctAggregate;
    public boolean isInSortedOrder;
    private int numDistinctAggs = 0;
    private int maxRowSize;
    private ScanController scanController;
    private ExecIndexRow sourceExecIndexRow;
    private ExecIndexRow sortResultRow;
    private boolean resultsComplete;
    private List<ExecRow> finishedResults;
    private ExecIndexRow[] resultRows;
    private List<List<Set<DataValueDescriptor>>> distinctValues;
    private boolean rollup;
    private boolean usingAggregateObserver = false;
    private long genericSortId;
    private TransactionController tc;
    public Properties sortProperties = new Properties();

    GroupedAggregateResultSet(NoPutResultSet s, boolean isInSortedOrder, int aggregateItem, int orderingItem, Activation a, int ra, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean isRollup) throws StandardException {
        super(s, aggregateItem, a, ra, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.isInSortedOrder = isInSortedOrder;
        this.rollup = isRollup;
        this.finishedResults = new ArrayList<ExecRow>();
        this.order = (ColumnOrdering[])((FormatableArrayHolder)a.getPreparedStatement().getSavedObject(orderingItem)).getArray(ColumnOrdering[].class);
        SanityManager.DEBUG((String)"AggregateTrace", (String)("execution time: " + a.getPreparedStatement().getSavedObject(aggregateItem)));
        this.hasDistinctAggregate = this.aggInfoList.hasDistinct();
        this.usingAggregateObserver = !isInSortedOrder && !this.rollup && !this.hasDistinctAggregate;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"GroupedAggregateResultSet already open");
        this.sortResultRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.sourceExecIndexRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.source.openCore();
        try {
            ExecIndexRow currSortedRow;
            if (!this.isInSortedOrder) {
                this.scanController = this.loadSorter();
            }
            boolean bl = this.resultsComplete = (currSortedRow = this.getNextRowFromRS()) == null;
            if (this.usingAggregateObserver) {
                if (currSortedRow != null) {
                    this.finishedResults.add(this.finishAggregation(currSortedRow).getClone());
                }
            } else if (!this.resultsComplete) {
                this.resultRows = this.rollup ? new ExecIndexRow[this.numGCols() + 1] : new ExecIndexRow[1];
                if (this.aggInfoList.hasDistinct()) {
                    this.distinctValues = new ArrayList<List<Set<DataValueDescriptor>>>(this.resultRows.length);
                }
                for (int r = 0; r < this.resultRows.length; ++r) {
                    this.resultRows[r] = (ExecIndexRow)currSortedRow.getClone();
                    this.initializeVectorAggregation(this.resultRows[r]);
                    if (!this.aggInfoList.hasDistinct()) continue;
                    this.distinctValues.add(new ArrayList(this.aggregates.length));
                    this.initializeDistinctMaps(r, true);
                }
            }
        }
        catch (StandardException e) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw e;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecIndexRow inputRow;
        int inputRowCountEstimate = (int)this.optimizerEstimatedRowCount;
        ExecIndexRow sortTemplateRow = this.getRowTemplate();
        this.tc = this.getTransactionController();
        BasicSortObserver observer = this.usingAggregateObserver ? new AggregateSortObserver(true, this.aggregates, this.aggregates, sortTemplateRow) : new BasicSortObserver(true, false, sortTemplateRow, true);
        this.genericSortId = this.tc.createSort(null, sortTemplateRow.getRowArray(), this.order, observer, false, inputRowCountEstimate, this.maxRowSize);
        SortController sorter = this.tc.openSort(this.genericSortId);
        while ((inputRow = this.getNextRowFromRS()) != null) {
            sorter.insert(inputRow.getRowArray());
        }
        this.source.close();
        sorter.completedInserts();
        this.sortProperties = sorter.getSortInfo().getAllSortInfo(this.sortProperties);
        if (this.aggInfoList.hasDistinct()) {
            this.numDistinctAggs = 1;
        }
        return this.tc.openSortScan(this.genericSortId, this.activation.getResultSetHoldability());
    }

    private int numGCols() {
        return this.order.length - this.numDistinctAggs;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.finishedResults.size() > 0) {
            return this.makeCurrent(this.finishedResults.remove(0));
        }
        if (this.resultsComplete) {
            return null;
        }
        ExecIndexRow nextRow = this.getNextRowFromRS();
        if (nextRow == null) {
            return this.finalizeResults();
        }
        if (this.usingAggregateObserver) {
            return this.finishAggregation(nextRow);
        }
        while (nextRow != null) {
            ExecIndexRow currSortedRow = this.resultRows[this.resultRows.length - 1];
            ExecRow origRow = nextRow.getClone();
            this.initializeVectorAggregation(nextRow);
            int distinguisherCol = this.sameGroupingValues(currSortedRow, nextRow);
            for (int r = 0; r < this.resultRows.length; ++r) {
                boolean sameGroup;
                boolean bl = this.rollup ? r <= distinguisherCol : (sameGroup = distinguisherCol == this.numGCols());
                if (sameGroup) {
                    this.mergeVectorAggregates(nextRow, this.resultRows[r], r);
                    continue;
                }
                this.setRollupColumnsToNull(this.resultRows[r], r);
                this.finishedResults.add(this.finishAggregation(this.resultRows[r]));
                this.resultRows[r] = (ExecIndexRow)origRow.getClone();
                this.initializeVectorAggregation(this.resultRows[r]);
                this.initializeDistinctMaps(r, false);
            }
            if (this.finishedResults.size() > 0) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                ++this.rowsReturned;
                return this.makeCurrent(this.finishedResults.remove(0));
            }
            nextRow = this.getNextRowFromRS();
        }
        return this.finalizeResults();
    }

    private ExecRow makeCurrent(Object row) throws StandardException {
        ExecRow resultRow = (ExecRow)row;
        this.setCurrentRow(resultRow);
        return resultRow;
    }

    private ExecRow finalizeResults() throws StandardException {
        this.resultsComplete = true;
        if (!this.usingAggregateObserver) {
            for (int r = 0; r < this.resultRows.length; ++r) {
                this.setRollupColumnsToNull(this.resultRows[r], r);
                this.finishedResults.add(this.finishAggregation(this.resultRows[r]));
            }
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        if (this.finishedResults.size() > 0) {
            return this.makeCurrent(this.finishedResults.remove(0));
        }
        return null;
    }

    private int sameGroupingValues(ExecRow currRow, ExecRow newRow) throws StandardException {
        for (int index = 0; index < this.numGCols(); ++index) {
            DataValueDescriptor newOrderable;
            DataValueDescriptor currOrderable = currRow.getColumn(this.order[index].getColumnId() + 1);
            if (currOrderable.compare(2, newOrderable = newRow.getColumn(this.order[index].getColumnId() + 1), true, true)) continue;
            return index;
        }
        return this.numGCols();
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.sourceExecIndexRow = null;
            this.closeSource();
            if (!this.isInSortedOrder) {
                this.tc.dropSort(this.genericSortId);
            }
            super.close();
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of SortResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.originalSource.getTimeSpent(1);
        }
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rl = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rl);
        return rl;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"SortResultSet expected to be open");
        return this.currentRow;
    }

    private ExecIndexRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecIndexRow getRowFromResultSet() throws StandardException {
        ExecIndexRow inputRow = null;
        ExecRow sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(sourceRow);
            inputRow = this.sourceExecIndexRow;
        }
        return inputRow;
    }

    private void setRollupColumnsToNull(ExecRow row, int resultNum) throws StandardException {
        int numRolledUpCols = this.resultRows.length - resultNum - 1;
        for (int i = 0; i < numRolledUpCols; ++i) {
            int rolledUpColIdx = this.numGCols() - 1 - i;
            DataValueDescriptor rolledUpColumn = row.getColumn(this.order[rolledUpColIdx].getColumnId() + 1);
            rolledUpColumn.setToNull();
        }
    }

    private ExecIndexRow getRowFromSorter() throws StandardException {
        ExecIndexRow inputRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            inputRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(inputRow.getRowArray());
        }
        return inputRow;
    }

    public void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }

    private void initializeVectorAggregation(ExecRow row) throws StandardException {
        int size = this.aggregates.length;
        SanityManager.ASSERT((row != null ? 1 : 0) != 0, (String)"Null row passed to initializeVectorAggregation");
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            currAggregate.initialize(row);
            currAggregate.accumulate(row, row);
        }
    }

    private void mergeVectorAggregates(ExecRow newRow, ExecRow currRow, int level) throws StandardException {
        for (int i = 0; i < this.aggregates.length; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            AggregatorInfo aInfo = (AggregatorInfo)this.aggInfoList.elementAt(i);
            if (aInfo.isDistinct()) {
                SanityManager.ASSERT((!this.isInSortedOrder ? 1 : 0) != 0);
                SanityManager.ASSERT((this.scanController != null ? 1 : 0) != 0);
                DataValueDescriptor newValue = currAggregate.getInputColumnValue(newRow);
                if (!newValue.isNull() && !this.distinctValues.get(level).get(i).add(newValue)) continue;
            }
            currAggregate.merge(newRow, currRow);
        }
    }

    private void initializeDistinctMaps(int r, boolean allocate) throws StandardException {
        for (int a = 0; a < this.aggregates.length; ++a) {
            AggregatorInfo aInfo = (AggregatorInfo)this.aggInfoList.elementAt(a);
            if (allocate) {
                this.distinctValues.get(r).add(aInfo.isDistinct() ? new HashSet() : null);
            }
            if (!aInfo.isDistinct()) continue;
            Set<DataValueDescriptor> set = this.distinctValues.get(r).get(a);
            set.clear();
            DataValueDescriptor newValue = this.aggregates[a].getInputColumnValue(this.resultRows[r]);
            set.add(newValue);
        }
    }
}

