/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_name_version")
public class CLNameVersion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int NAME;

    public CLNameVersion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CLNameVersion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_version")
    public int version() {
        return CLNameVersion.nversion(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer name() {
        return CLNameVersion.nname(this.address());
    }

    @NativeType(value="char[64]")
    public String nameString() {
        return CLNameVersion.nnameString(this.address());
    }

    public static CLNameVersion malloc() {
        return (CLNameVersion)CLNameVersion.wrap(CLNameVersion.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CLNameVersion calloc() {
        return (CLNameVersion)CLNameVersion.wrap(CLNameVersion.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CLNameVersion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CLNameVersion)CLNameVersion.wrap(CLNameVersion.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CLNameVersion create(long address) {
        return (CLNameVersion)CLNameVersion.wrap(CLNameVersion.class, (long)address);
    }

    @Nullable
    public static CLNameVersion createSafe(long address) {
        return address == 0L ? null : (CLNameVersion)CLNameVersion.wrap(CLNameVersion.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CLNameVersion.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CLNameVersion.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CLNameVersion.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLNameVersion.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CLNameVersion.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CLNameVersion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CLNameVersion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CLNameVersion malloc(MemoryStack stack) {
        return (CLNameVersion)CLNameVersion.wrap(CLNameVersion.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLNameVersion calloc(MemoryStack stack) {
        return (CLNameVersion)CLNameVersion.wrap(CLNameVersion.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CLNameVersion.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CLNameVersion.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nversion(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERSION);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)64);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = CLNameVersion.__struct((Struct.Member[])new Struct.Member[]{CLNameVersion.__member((int)4), CLNameVersion.__array((int)1, (int)64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        NAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLNameVersion, Buffer>
    implements NativeResource {
        private static final CLNameVersion ELEMENT_FACTORY = CLNameVersion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CLNameVersion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_version")
        public int version() {
            return CLNameVersion.nversion(this.address());
        }

        @NativeType(value="char[64]")
        public ByteBuffer name() {
            return CLNameVersion.nname(this.address());
        }

        @NativeType(value="char[64]")
        public String nameString() {
            return CLNameVersion.nnameString(this.address());
        }
    }
}

