/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.handlers;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.xml.handlers.LocationHandler;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.SAXException;

public class DeclarationHandler
extends LocationHandler {
    private final Report report;
    private final String mimeType;
    private final EPUBVersion version;
    private boolean firstStartDTDInvocation = true;
    private final Set<String> entities = new HashSet<String>();

    public DeclarationHandler(ValidationContext context) {
        super(context);
        this.report = context.report;
        this.mimeType = context.mimeType;
        this.version = context.version;
        this.entities.add("gt");
        this.entities.add("lt");
        this.entities.add("amp");
        this.entities.add("quot");
        this.entities.add("apos");
    }

    @Override
    public void startDTD(String root, String publicId, String systemId) throws SAXException {
        if (!this.firstStartDTDInvocation) {
            return;
        }
        this.handleDocTypeUserInfo(root, publicId, systemId);
        this.firstStartDTDInvocation = false;
    }

    private void handleDocTypeUserInfo(String root, String publicId, String systemId) {
        if (this.version == EPUBVersion.VERSION_2) {
            String complete;
            if ("application/xhtml+xml".equals(this.mimeType) && root.equals("html") && this.matchDoctypeId("-//W3C//DTD XHTML 1.1//EN", publicId, complete = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \n\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">")) {
                this.matchDoctypeId("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", systemId, complete);
            }
            if ("opf".equals(this.mimeType) && (publicId != null || systemId != null) && (!"package".equals(root) || publicId != null && !publicId.equals("+//ISBN 0-9673008-1-9//DTD OEB 1.2 Package//EN") || systemId != null && !systemId.equals("http://openebook.org/dtds/oeb-1.2/oebpkg12.dtd"))) {
                this.report.message(MessageId.HTM_009, this.location(), new Object[0]);
            }
            if ("application/x-dtbncx+xml".equals(this.mimeType) && this.matchDoctypeId("-//NISO//DTD ncx 2005-1//EN", publicId, complete = "<!DOCTYPE ncx PUBLIC \"-//NISO//DTD ncx 2005-1//EN\" \n \"http://www.daisy.org/z3986/2005/ncx-2005-1.dtd\">")) {
                this.matchDoctypeId("http://www.daisy.org/z3986/2005/ncx-2005-1.dtd", systemId, complete);
            }
        } else if (this.version == EPUBVersion.VERSION_3) {
            if ("application/xhtml+xml".equals(this.mimeType) && "html".equalsIgnoreCase(root)) {
                String complete = "<!DOCTYPE html>";
                if (publicId != null || systemId != null && !systemId.equals("about:legacy-compat")) {
                    this.report.message(MessageId.HTM_004, this.location(), publicId, complete);
                }
            } else if (publicId != null || systemId != null) {
                boolean isAllowed;
                switch (this.mimeType) {
                    case "image/svg+xml": {
                        isAllowed = "-//W3C//DTD SVG 1.1//EN".equals(publicId) && "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd".equals(systemId);
                        break;
                    }
                    case "application/mathml+xml": 
                    case "application/mathml-content+xml": 
                    case "application/mathml-presentation+xml": {
                        isAllowed = "-//W3C//DTD MathML 3.0//EN".equals(publicId) && "http://www.w3.org/Math/DTD/mathml3/mathml3.dtd".equals(systemId);
                        break;
                    }
                    case "application/x-dtbncx+xml": {
                        isAllowed = "-//NISO//DTD ncx 2005-1//EN".equals(publicId) && "http://www.daisy.org/z3986/2005/ncx-2005-1.dtd".equals(systemId);
                        break;
                    }
                    default: {
                        isAllowed = false;
                    }
                }
                if (!isAllowed) {
                    this.report.message(MessageId.OPF_073, this.location(), new Object[0]);
                }
            }
        }
    }

    private boolean matchDoctypeId(String expected, String given, String messageParam) {
        if (!expected.equals(given)) {
            this.report.message(MessageId.HTM_004, this.location(), given == null ? "" : given, messageParam);
            return false;
        }
        return true;
    }

    @Override
    public void startEntity(String ent) throws SAXException {
        if (!this.entities.contains(ent) && !ent.equals("[dtd]")) {
            this.report.message(MessageId.HTM_011, this.location(), new Object[0]);
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.version == EPUBVersion.VERSION_3) {
            this.report.message(MessageId.HTM_003, this.location(), name);
            return;
        }
        this.entities.add(name);
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        this.entities.add(name);
    }
}

