/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.controller.NextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.RemoteNextGenBuildCacheServiceHandler;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedThreadPoolExecutor;
import org.gradle.internal.file.BufferProvider;
import org.slf4j.Logger;

public class DefaultNextGenBuildCacheAccess
implements NextGenBuildCacheAccess {
    public static final int THREAD_POOL_SIZE = 256;
    private final NextGenBuildCacheService local;
    private final RemoteNextGenBuildCacheServiceHandler remote;
    private final BufferProvider bufferProvider;
    private final ManagedThreadPoolExecutor remoteProcessor;
    private final Logger logger;
    private final ConcurrencyCounter counter;

    public DefaultNextGenBuildCacheAccess(NextGenBuildCacheService local, RemoteNextGenBuildCacheServiceHandler remote, BufferProvider bufferProvider, ExecutorFactory executorFactory, Logger logger) {
        this.local = local;
        this.remote = remote;
        this.bufferProvider = bufferProvider;
        this.remoteProcessor = executorFactory.createThreadPool("Build cache access", 256, 256, 10L, TimeUnit.SECONDS);
        this.logger = logger;
        this.counter = new ConcurrencyCounter(this.remoteProcessor);
    }

    @Override
    public <T> void load(Map<BuildCacheKey, T> entries, NextGenBuildCacheAccess.LoadHandler<T> handler) {
        CompletableFuture[] asyncLoads = (CompletableFuture[])entries.entrySet().stream().flatMap(entry -> {
            boolean foundLocally;
            BuildCacheKey key = (BuildCacheKey)entry.getKey();
            Object payload = entry.getValue();
            try {
                foundLocally = this.local.load(key, input -> handler.handle(input, payload));
            }
            catch (Exception e) {
                handler.recordUnpackFailure(key, e);
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            if (!foundLocally && this.remote.canLoad()) {
                handler.ensureLoadOperationStarted(key);
                return Stream.of(CompletableFuture.runAsync(this.counter.wrap(new RemoteDownload(key, payload, handler)), (Executor)this.remoteProcessor));
            }
            return Stream.empty();
        }).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(asyncLoads).join();
    }

    @Override
    public <T> void store(Map<BuildCacheKey, T> entries, NextGenBuildCacheAccess.StoreHandler<T> handler) {
        CompletableFuture[] asyncStores = (CompletableFuture[])entries.entrySet().stream().flatMap(entry -> {
            BuildCacheKey key = (BuildCacheKey)entry.getKey();
            Object payload = entry.getValue();
            if (!this.local.contains(key)) {
                try {
                    this.local.store(key, handler.createWriter(payload));
                }
                catch (Exception e) {
                    handler.recordPackFailure(key, e);
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            if (this.remote.canStore()) {
                handler.ensureStoreOperationStarted(key);
                return Stream.of(CompletableFuture.runAsync(this.counter.wrap(new RemoteUpload(key, handler)), (Executor)this.remoteProcessor));
            }
            return Stream.empty();
        }).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(asyncStores).join();
    }

    @Override
    public void close() throws IOException {
        Closer closer = Closer.create();
        closer.register(() -> {
            if (!this.remoteProcessor.getQueue().isEmpty() || this.remoteProcessor.getActiveCount() > 0) {
                this.logger.warn("Waiting for remote cache uploads to finish");
            }
            try {
                this.remoteProcessor.stop(5, TimeUnit.MINUTES);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Couldn't finish uploading all remote entries", e);
            }
        });
        closer.register((Closeable)((Object)this.local));
        closer.register((Closeable)((Object)this.remote));
        closer.register((Closeable)this.counter);
        closer.close();
    }

    private class RemoteUpload
    implements Runnable {
        private final BuildCacheKey key;
        private final NextGenBuildCacheAccess.StoreHandler<?> handler;

        public RemoteUpload(BuildCacheKey key, NextGenBuildCacheAccess.StoreHandler<?> handler) {
            this.key = key;
            this.handler = handler;
        }

        @Override
        public void run() {
            if (DefaultNextGenBuildCacheAccess.this.remote.contains(this.key)) {
                DefaultNextGenBuildCacheAccess.this.logger.warn("Not storing {} in remote", (Object)this.key);
                return;
            }
            UnsynchronizedByteArrayOutputStream data = new UnsynchronizedByteArrayOutputStream();
            boolean foundLocally = DefaultNextGenBuildCacheAccess.this.local.load(this.key, input -> IOUtils.copyLarge((InputStream)input, (OutputStream)data, (byte[])DefaultNextGenBuildCacheAccess.this.bufferProvider.getBuffer()));
            if (!foundLocally) {
                throw new IllegalStateException("Couldn't store " + this.key + " in remote cache because it was missing from local cache");
            }
            this.store(data);
        }

        private void store(UnsynchronizedByteArrayOutputStream data) {
            try {
                DefaultNextGenBuildCacheAccess.this.logger.warn("Storing {} in remote (size: {})", (Object)this.key, (Object)data.size());
                boolean stored = this.storeInner(data);
                DefaultNextGenBuildCacheAccess.this.logger.warn("Stored {} in remote: {}", (Object)this.key, (Object)stored);
                this.handler.recordStoreFinished(this.key, stored);
            }
            catch (Exception e) {
                this.handler.recordStoreFailure(this.key, e);
                DefaultNextGenBuildCacheAccess.this.logger.warn("Store {} failed", (Object)this.key, (Object)e);
                DefaultNextGenBuildCacheAccess.this.remote.disableOnError();
            }
        }

        private boolean storeInner(final UnsynchronizedByteArrayOutputStream data) {
            final AtomicBoolean stored = new AtomicBoolean(false);
            DefaultNextGenBuildCacheAccess.this.remote.store(this.key, new NextGenBuildCacheService.NextGenWriter(){

                @Override
                public InputStream openStream() {
                    return data.toInputStream();
                }

                public void writeTo(OutputStream output) throws IOException {
                    data.writeTo(output);
                    stored.set(true);
                }

                public long getSize() {
                    return data.size();
                }
            });
            return stored.get();
        }
    }

    private class RemoteDownload<T>
    implements Runnable {
        private final BuildCacheKey key;
        private final T payload;
        private final NextGenBuildCacheAccess.LoadHandler<T> handler;

        public RemoteDownload(BuildCacheKey key, T payload, NextGenBuildCacheAccess.LoadHandler<T> handler) {
            this.key = key;
            this.payload = payload;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                DefaultNextGenBuildCacheAccess.this.logger.warn("Loading {} from remote", (Object)this.key);
                long size = this.load();
                if (size >= 0L) {
                    this.handler.recordLoadHit(this.key, size);
                    DefaultNextGenBuildCacheAccess.this.logger.warn("Found {} in remote (size: {})", (Object)this.key, (Object)size);
                } else {
                    this.handler.recordLoadMiss(this.key);
                    DefaultNextGenBuildCacheAccess.this.logger.warn("Not found {} in remote", (Object)this.key);
                }
            }
            catch (Exception e) {
                this.handler.recordLoadFailure(this.key, e);
                DefaultNextGenBuildCacheAccess.this.remote.disableOnError();
            }
        }

        private long load() {
            AtomicLong size = new AtomicLong(-1L);
            DefaultNextGenBuildCacheAccess.this.remote.load(this.key, input -> {
                final UnsynchronizedByteArrayOutputStream data = new UnsynchronizedByteArrayOutputStream();
                byte[] buffer = DefaultNextGenBuildCacheAccess.this.bufferProvider.getBuffer();
                IOUtils.copyLarge((InputStream)input, (OutputStream)data, (byte[])buffer);
                size.set(data.size());
                DefaultNextGenBuildCacheAccess.this.local.store(this.key, new NextGenBuildCacheService.NextGenWriter(){

                    @Override
                    public InputStream openStream() {
                        return data.toInputStream();
                    }

                    public void writeTo(OutputStream output) throws IOException {
                        data.writeTo(output);
                    }

                    public long getSize() {
                        return data.size();
                    }
                });
                this.handler.handle(data.toInputStream(), this.payload);
            });
            return size.get();
        }
    }

    private class ConcurrencyCounter
    implements Closeable {
        private final AtomicInteger maxQueueLength = new AtomicInteger(0);
        private final AtomicInteger maxActiveCount = new AtomicInteger(0);
        private final ManagedThreadPoolExecutor processor;

        public ConcurrencyCounter(ManagedThreadPoolExecutor processor) {
            this.processor = processor;
        }

        public Runnable wrap(Runnable delegate) {
            return () -> {
                this.maxQueueLength.updateAndGet(max -> Integer.max(max, this.processor.getQueue().size()));
                this.maxActiveCount.updateAndGet(max -> Integer.max(max, this.processor.getActiveCount()));
                delegate.run();
            };
        }

        @Override
        public void close() {
            DefaultNextGenBuildCacheAccess.this.logger.warn("Max concurrency encountered while processing remote cache entries: {}, max queue length: {}", (Object)this.maxActiveCount.get(), (Object)this.maxQueueLength.get());
        }
    }
}

