/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmEqRef;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI31Ref;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011J\f\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\u0011J\n\u0010\u0013\u001a\u00020\u0010*\u00020\u0011J\f\u0010\u0014\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\u0011J\n\u0010\u0016\u001a\u00020\u0010*\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;Lorg/jetbrains/kotlin/ir/IrBuiltIns;)V", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "toBoxedInlineClassType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toWasmBlockResultType", "toWasmFieldType", "toWasmGcRefType", "toWasmResultType", "toWasmValueType", "backend.wasm"})
public final class WasmTypeTransformer {
    @NotNull
    private final WasmModuleCodegenContext context;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final WasmSymbols symbols;

    public WasmTypeTransformer(@NotNull WasmModuleCodegenContext context, @NotNull IrBuiltIns builtIns2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        this.context = context;
        this.builtIns = builtIns2;
        this.symbols = this.context.getBackendContext().getWasmSymbols();
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    @Nullable
    public final WasmType toWasmResultType(@NotNull IrType $this$toWasmResultType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmResultType, (String)"<this>");
        IrType irType = $this$toWasmResultType;
        return (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getUnitType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType())) ? null : this.toWasmValueType($this$toWasmResultType);
    }

    @Nullable
    public final WasmType toWasmBlockResultType(@NotNull IrType $this$toWasmBlockResultType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmBlockResultType, (String)"<this>");
        IrType irType = $this$toWasmBlockResultType;
        return Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType()) ? (WasmType)WasmUnreachableType.INSTANCE : (Intrinsics.areEqual((Object)irType, (Object)this.symbols.getVoidType()) ? null : this.toWasmValueType($this$toWasmBlockResultType));
    }

    private final WasmType toWasmGcRefType(IrType $this$toWasmGcRefType) {
        return new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass($this$toWasmGcRefType, this.context.getBackendContext().getIrBuiltIns()).getSymbol())));
    }

    @NotNull
    public final WasmType toBoxedInlineClassType(@NotNull IrType $this$toBoxedInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$toBoxedInlineClassType, (String)"<this>");
        return this.toWasmGcRefType($this$toBoxedInlineClassType);
    }

    @NotNull
    public final WasmType toWasmFieldType(@NotNull IrType $this$toWasmFieldType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmFieldType, (String)"<this>");
        IrType irType = $this$toWasmFieldType;
        return (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType())) ? (WasmType)WasmI8.INSTANCE : ((Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getCharType())) ? (WasmType)WasmI16.INSTANCE : this.toWasmValueType($this$toWasmFieldType));
    }

    @NotNull
    public final WasmType toWasmValueType(@NotNull IrType $this$toWasmValueType) {
        WasmType wasmType;
        block22: {
            IrClass ic;
            block29: {
                IrClass klass;
                block28: {
                    IrType irType;
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block21: {
                                            Intrinsics.checkNotNullParameter((Object)$this$toWasmValueType, (String)"<this>");
                                            irType = $this$toWasmValueType;
                                            if (!((((Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getIntType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getCharType()))) break block21;
                                            wasmType = WasmI32.INSTANCE;
                                            break block22;
                                        }
                                        if (!Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getLongType())) break block23;
                                        wasmType = WasmI64.INSTANCE;
                                        break block22;
                                    }
                                    if (!Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getFloatType())) break block24;
                                    wasmType = WasmF32.INSTANCE;
                                    break block22;
                                }
                                if (!Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getDoubleType())) break block25;
                                wasmType = WasmF64.INSTANCE;
                                break block22;
                            }
                            if (!Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingNType())) break block26;
                            wasmType = WasmAnyRef.INSTANCE;
                            break block22;
                        }
                        if (!Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType())) break block27;
                        wasmType = WasmAnyRef.INSTANCE;
                        break block22;
                    }
                    if (Intrinsics.areEqual((Object)irType, (Object)this.symbols.getVoidType())) {
                        throw new IllegalStateException("Void type can't be used as a value".toString());
                    }
                    IrClass irClass2 = TypeTranformerKt.getErasedUpperBound($this$toWasmValueType);
                    if (irClass2 == null) {
                        irClass2 = (IrClass)this.builtIns.getAnyClass().getOwner();
                    }
                    klass = irClass2;
                    ic = this.context.getBackendContext().getInlineClassesUtils().getInlinedClass($this$toWasmValueType);
                    if (!klass.isExternal()) break block28;
                    wasmType = WasmExternRef.INSTANCE;
                    break block22;
                }
                if (!TypeTransformerKt.isBuiltInWasmRefType($this$toWasmValueType)) break block29;
                String string2 = klass.getName().getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"klass.name.identifier");
                switch (string2) {
                    case "anyref": {
                        wasmType = WasmAnyRef.INSTANCE;
                        break block22;
                    }
                    case "eqref": {
                        wasmType = WasmEqRef.INSTANCE;
                        break block22;
                    }
                    case "dataref": {
                        wasmType = new WasmRefNullType(WasmHeapType.Simple.Data.INSTANCE);
                        break block22;
                    }
                    case "i31ref": {
                        wasmType = WasmI31Ref.INSTANCE;
                        break block22;
                    }
                    case "funcref": {
                        wasmType = new WasmRefNullType(WasmHeapType.Simple.Func.INSTANCE);
                        break block22;
                    }
                    default: {
                        String name2;
                        throw new IllegalStateException(("Unknown reference type " + name2).toString());
                    }
                }
            }
            wasmType = ic != null ? this.toWasmValueType(this.context.getBackendContext().getInlineClassesUtils().getInlineClassUnderlyingType(ic)) : this.toWasmGcRefType($this$toWasmValueType);
        }
        return wasmType;
    }
}

