/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson.internal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.com.google.gson.ExclusionStrategy;
import org.jetbrains.kotlin.com.google.gson.FieldAttributes;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.TypeAdapter;
import org.jetbrains.kotlin.com.google.gson.TypeAdapterFactory;
import org.jetbrains.kotlin.com.google.gson.annotations.Expose;
import org.jetbrains.kotlin.com.google.gson.annotations.Since;
import org.jetbrains.kotlin.com.google.gson.annotations.Until;
import org.jetbrains.kotlin.com.google.gson.reflect.TypeToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonWriter;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    private List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public <T> TypeAdapter<T> create(final Gson gson, final TypeToken<T> type2) {
        boolean skipDeserialize;
        Class<T> rawType = type2.getRawType();
        boolean excludeClass = this.excludeClassChecks(rawType);
        final boolean skipSerialize = excludeClass || this.excludeClassInStrategy(rawType, true);
        boolean bl = skipDeserialize = excludeClass || this.excludeClassInStrategy(rawType, false);
        if (!skipSerialize && !skipDeserialize) {
            return null;
        }
        return new TypeAdapter<T>(){
            private TypeAdapter<T> delegate;

            @Override
            public void write(JsonWriter out, T value2) throws IOException {
                if (skipSerialize) {
                    out.nullValue();
                    return;
                }
                this.delegate().write(out, value2);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter d = this.delegate;
                return d != null ? d : (this.delegate = gson.getDelegateAdapter(Excluder.this, type2));
            }
        };
    }

    public boolean excludeField(Field field2, boolean serialize2) {
        List<ExclusionStrategy> list2;
        Expose annotation2;
        if ((this.modifiers & field2.getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(field2.getAnnotation(Since.class), field2.getAnnotation(Until.class))) {
            return true;
        }
        if (field2.isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((annotation2 = field2.getAnnotation(Expose.class)) == null || (serialize2 ? !annotation2.serialize() : !annotation2.deserialize()))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(field2.getType())) {
            return true;
        }
        if (this.isAnonymousOrNonStaticLocal(field2.getType())) {
            return true;
        }
        List<ExclusionStrategy> list3 = list2 = serialize2 ? this.serializationStrategies : this.deserializationStrategies;
        if (!list2.isEmpty()) {
            FieldAttributes fieldAttributes = new FieldAttributes(field2);
            for (ExclusionStrategy exclusionStrategy : list2) {
                if (!exclusionStrategy.shouldSkipField(fieldAttributes)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean excludeClassChecks(Class<?> clazz) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        return this.isAnonymousOrNonStaticLocal(clazz);
    }

    public boolean excludeClass(Class<?> clazz, boolean serialize2) {
        return this.excludeClassChecks(clazz) || this.excludeClassInStrategy(clazz, serialize2);
    }

    private boolean excludeClassInStrategy(Class<?> clazz, boolean serialize2) {
        List<ExclusionStrategy> list2 = serialize2 ? this.serializationStrategies : this.deserializationStrategies;
        for (ExclusionStrategy exclusionStrategy : list2) {
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnonymousOrNonStaticLocal(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && !this.isStatic(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    private boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !this.isStatic(clazz);
    }

    private boolean isStatic(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since annotation2) {
        double annotationVersion;
        return annotation2 == null || !((annotationVersion = annotation2.value()) > this.version);
    }

    private boolean isValidUntil(Until annotation2) {
        double annotationVersion;
        return annotation2 == null || !((annotationVersion = annotation2.value()) <= this.version);
    }
}

