/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.Snapshot;
import org.gradle.internal.snapshot.SnapshottingService;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultSnapshottingService
implements SnapshottingService {
    private final FileSystemAccess fileSystemAccess;

    @Inject
    public DefaultSnapshottingService(FileSystemAccess fileSystemAccess) {
        this.fileSystemAccess = fileSystemAccess;
    }

    @Override
    public Snapshot snapshotFor(Path filePath) {
        String absolutePath = filePath.toAbsolutePath().toString();
        HashCode hash = this.fileSystemAccess.read(absolutePath).getHash();
        return new DefaultSnapshot(hash);
    }

    private static class DefaultSnapshot
    implements Snapshot {
        private final HashCode hashCode;

        public DefaultSnapshot(HashCode hashCode) {
            this.hashCode = hashCode;
        }

        @Override
        public String getHashValue() {
            return this.hashCode.toString();
        }

        public String toString() {
            return String.format("DefaultSnapshot { hashValue='%s' }", this.getHashValue());
        }
    }
}

