/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;

public class PropertyReportRenderer
extends TextReportRenderer {
    private static final Logger LOGGER = Logging.getLogger(PropertyReportRenderer.class);

    public void addProperty(String name, @Nullable Object value) {
        String strValue;
        try {
            strValue = String.valueOf(value);
        }
        catch (Exception e) {
            String valueClass = value != null ? String.valueOf(value.getClass()) : "null";
            LOGGER.warn("Rendering of the property '{}' with value type '{}' failed with exception", new Object[]{name, valueClass, e});
            strValue = valueClass + " [Rendering failed]";
        }
        this.getTextOutput().formatln("%s: %s", new Object[]{name, strValue});
    }
}

