/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogKt;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0003J\u001b\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u000fH\u0096\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLog;", "", "", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "()V", "history", "Ljava/util/TreeMap;", "<set-?>", "lastKnownVersion", "contains", "", "version", "getChange", "iterator", "", "put", "", "change", "rollbackHistoryToVersion", "v", "shrinkHistory", "updateLastKnownVersion", "newVersion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLog.kt\ncom/jetbrains/rd/ide/document/DocumentLog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n1#2:72\n53#3,4:73\n53#3,4:77\n*S KotlinDebug\n*F\n+ 1 DocumentLog.kt\ncom/jetbrains/rd/ide/document/DocumentLog\n*L\n47#1:73,4\n63#1:77,4\n*E\n"})
public class DocumentLog
implements Iterable<Map.Entry<? extends RdDocumentVersion, ? extends RdDocumentChangeBase>>,
KMappedMarker {
    @NotNull
    private final TreeMap<RdDocumentVersion, RdDocumentChangeBase> history = new TreeMap((arg_0, arg_1) -> DocumentLog.history$lambda$0(history.1.INSTANCE, arg_0, arg_1));
    @NotNull
    private RdDocumentVersion lastKnownVersion = DocumentVersionsKt.getInitialDocVersion();

    public void updateLastKnownVersion(@NotNull RdDocumentVersion newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        if (this.lastKnownVersion.getValue() < newVersion.getValue()) {
            this.lastKnownVersion = newVersion;
            this.shrinkHistory(newVersion);
        }
    }

    public final boolean contains(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return ((Map)this.history).containsKey(version);
    }

    @Nullable
    public final RdDocumentChangeBase getChange(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.history.get(version);
    }

    public final void put(@NotNull RdDocumentVersion version, @NotNull RdDocumentChangeBase change) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (!(!this.history.containsKey(version))) {
            boolean bl = false;
            String string = "Document log already contains change on " + version;
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)this.history).put(version, change);
    }

    private final void shrinkHistory(RdDocumentVersion lastKnownVersion) {
        Iterator<RdDocumentVersion> it = this.history.keySet().iterator();
        int removedEntries = 0;
        while (it.hasNext()) {
            RdDocumentVersion version;
            Intrinsics.checkNotNullExpressionValue((Object)it.next(), (String)"next(...)");
            if (version.getValue() >= lastKnownVersion.getValue()) break;
            it.remove();
            int n = removedEntries;
            removedEntries = n + 1;
        }
        if (removedEntries > 0) {
            Logger $this$trace$iv = DocumentLogKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("DocumentLog was shrunk to " + lastKnownVersion + " version; removed entries: " + removedEntries + ", new size: " + this.history.size());
            }
        }
    }

    public void rollbackHistoryToVersion(@NotNull RdDocumentVersion v) {
        RdDocumentVersion version;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Iterator<RdDocumentVersion> iterator = this.history.descendingKeySet().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RdDocumentVersion> it = iterator;
        int removedEntries = 0;
        while (it.hasNext() && (version = it.next()).getValue() > v.getValue()) {
            it.remove();
            int n = removedEntries;
            removedEntries = n + 1;
        }
        if (removedEntries > 0) {
            Logger $this$trace$iv = DocumentLogKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("DocumentLog rollback history to " + v + "; removed entries: " + removedEntries + ", new size: " + this.history.size());
            }
        }
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<RdDocumentVersion, RdDocumentChangeBase>> iterator() {
        return ((Map)this.history).entrySet().iterator();
    }

    private static final int history$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

