/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceCacheFillService;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceFileChangesListener;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceImportDetectionListener;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceLibraryImportChecker;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.psi.PyFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/python/community/impl/huggingFace/service/HuggingFaceImportedLibrariesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cacheFillService", "Lcom/intellij/python/community/impl/huggingFace/cache/HuggingFaceCacheFillService;", "cacheTimestamp", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "documentListener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "librariesChecker", "Lcom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibraryImportChecker;", "libraryImportStatus", "Lcom/intellij/python/community/impl/huggingFace/service/HuggingFaceImportedLibrariesManager$LibraryImportStatus;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkLibraryImportStatusInFile", "", "pyFile", "Lcom/jetbrains/python/psi/PyFile;", "checkLibraryImportStatusInProject", "detachListeners", "dispose", "isLibraryImported", "", "setupListeners", "updateLibraryImportStatus", "newStatus", "LibraryImportStatus", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceImportedLibrariesManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private LibraryImportStatus libraryImportStatus;
    private long cacheTimestamp;
    @NotNull
    private final MessageBusConnection connection;
    @Nullable
    private DocumentListener documentListener;
    @NotNull
    private final HuggingFaceCacheFillService cacheFillService;
    @NotNull
    private final HuggingFaceLibraryImportChecker librariesChecker;

    public HuggingFaceImportedLibrariesManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.libraryImportStatus = LibraryImportStatus.NOT_CHECKED;
        this.connection = this.project.getMessageBus().connect((Disposable)this);
        Object object = this.project.getService(HuggingFaceCacheFillService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.cacheFillService = (HuggingFaceCacheFillService)object;
        this.librariesChecker = new HuggingFaceLibraryImportChecker(this.project);
        this.setupListeners();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void setupListeners() {
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        this.connection.subscribe(topic, (Object)new HuggingFaceFileChangesListener((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ HuggingFaceImportedLibrariesManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                HuggingFaceImportedLibrariesManager.access$checkLibraryImportStatusInProject(this.this$0);
            }
        })));
        HuggingFaceImportDetectionListener documentListener2 = new HuggingFaceImportDetectionListener(this.project, (Function1<? super PyFile, Unit>)((Function1)new Function1<PyFile, Unit>(this){
            final /* synthetic */ HuggingFaceImportedLibrariesManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PyFile pyFile) {
                Intrinsics.checkNotNullParameter((Object)pyFile, (String)"pyFile");
                HuggingFaceImportedLibrariesManager.access$checkLibraryImportStatusInFile(this.this$0, pyFile);
            }
        }));
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener2, (Disposable)this.connection);
        this.documentListener = documentListener2;
    }

    @RequiresBackgroundThread
    public final boolean isLibraryImported() {
        if (this.libraryImportStatus != LibraryImportStatus.IMPORTED) {
            this.checkLibraryImportStatusInProject();
        }
        return this.libraryImportStatus == LibraryImportStatus.IMPORTED;
    }

    private final void checkLibraryImportStatusInFile(PyFile pyFile) {
        boolean isImported = this.librariesChecker.isAnyHFLibraryImportedInFile(pyFile);
        this.updateLibraryImportStatus(isImported);
    }

    private final void checkLibraryImportStatusInProject() {
        boolean isUpdateTime;
        if (this.libraryImportStatus == LibraryImportStatus.IMPORTED) {
            return;
        }
        boolean bl = isUpdateTime = System.currentTimeMillis() - this.cacheTimestamp > 300000L;
        if (this.libraryImportStatus == LibraryImportStatus.NOT_CHECKED || isUpdateTime) {
            boolean isImported = this.librariesChecker.isAnyHFLibraryImportedInProject();
            this.updateLibraryImportStatus(isImported);
            this.cacheTimestamp = System.currentTimeMillis();
        }
    }

    private final void updateLibraryImportStatus(boolean newStatus) {
        LibraryImportStatus libraryImportStatus;
        if (newStatus) {
            this.cacheFillService.triggerCacheFillIfNeeded();
            this.detachListeners();
            libraryImportStatus = LibraryImportStatus.IMPORTED;
        } else {
            libraryImportStatus = LibraryImportStatus.NOT_IMPORTED;
        }
        this.libraryImportStatus = libraryImportStatus;
    }

    private final void detachListeners() {
        DocumentListener documentListener2 = this.documentListener;
        if (documentListener2 != null) {
            DocumentListener listener2 = documentListener2;
            boolean bl = false;
            EditorFactory.getInstance().getEventMulticaster().removeDocumentListener(listener2);
            this.documentListener = null;
        }
        this.connection.disconnect();
    }

    public void dispose() {
        this.detachListeners();
    }

    public static final /* synthetic */ void access$checkLibraryImportStatusInProject(HuggingFaceImportedLibrariesManager $this) {
        $this.checkLibraryImportStatusInProject();
    }

    public static final /* synthetic */ void access$checkLibraryImportStatusInFile(HuggingFaceImportedLibrariesManager $this, PyFile pyFile) {
        $this.checkLibraryImportStatusInFile(pyFile);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/community/impl/huggingFace/service/HuggingFaceImportedLibrariesManager$LibraryImportStatus;", "", "(Ljava/lang/String;I)V", "NOT_CHECKED", "IMPORTED", "NOT_IMPORTED", "intellij.python.community.impl.huggingFace"})
    private static final class LibraryImportStatus
    extends Enum<LibraryImportStatus> {
        public static final /* enum */ LibraryImportStatus NOT_CHECKED = new LibraryImportStatus();
        public static final /* enum */ LibraryImportStatus IMPORTED = new LibraryImportStatus();
        public static final /* enum */ LibraryImportStatus NOT_IMPORTED = new LibraryImportStatus();
        private static final /* synthetic */ LibraryImportStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LibraryImportStatus[] values() {
            return (LibraryImportStatus[])$VALUES.clone();
        }

        public static LibraryImportStatus valueOf(String value) {
            return Enum.valueOf(LibraryImportStatus.class, value);
        }

        @NotNull
        public static EnumEntries<LibraryImportStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = libraryImportStatusArray = new LibraryImportStatus[]{LibraryImportStatus.NOT_CHECKED, LibraryImportStatus.IMPORTED, LibraryImportStatus.NOT_IMPORTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

