/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonHelpersLocator {
    private static final Logger LOG = Logger.getInstance(PythonHelpersLocator.class);
    private static final String PROPERTY_HELPERS_LOCATION = "idea.python.helpers.path";
    private static final String EXPECTED_PRO_HELPER_PACKAGE = "jupyter_debug";

    private PythonHelpersLocator() {
    }

    @NotNull
    public static File getHelpersRoot() {
        String property = System.getProperty(PROPERTY_HELPERS_LOCATION);
        if (property != null) {
            return new File(property);
        }
        return PythonHelpersLocator.assertHelpersLayout(PythonHelpersLocator.getHelperRoot("intellij.python.helpers", "/python/helpers"));
    }

    @NotNull
    public static Path getHelpersProRoot() {
        Path path2 = PythonHelpersLocator.assertHelpersProLayout(PythonHelpersLocator.getExpectedHelpersProRootLocation()).toPath().normalize();
        if (path2 == null) {
            PythonHelpersLocator.$$$reportNull$$$0(0);
        }
        return path2;
    }

    @ApiStatus.Internal
    public static boolean hasHelpersPro() {
        return new File(PythonHelpersLocator.getExpectedHelpersProRootLocation(), EXPECTED_PRO_HELPER_PACKAGE).exists();
    }

    @NotNull
    private static File getExpectedHelpersProRootLocation() {
        return PythonHelpersLocator.getHelperRoot("intellij.python.helpers.pro", "/../python/helpers-pro");
    }

    @NotNull
    private static File getHelperRoot(@NotNull String moduleName, @NotNull String relativePath) {
        if (moduleName == null) {
            PythonHelpersLocator.$$$reportNull$$$0(1);
        }
        if (relativePath == null) {
            PythonHelpersLocator.$$$reportNull$$$0(2);
        }
        @NonNls String jarPath = PathUtil.getJarPathForClass(PythonHelpersLocator.class);
        if (PluginManagerCore.isRunningFromSources()) {
            return new File(PathManager.getCommunityHomePath() + relativePath);
        }
        File pluginBaseDir = PythonHelpersLocator.getPluginBaseDir(jarPath);
        if (pluginBaseDir != null) {
            return new File(pluginBaseDir, PathUtil.getFileName((String)relativePath));
        }
        return new File(new File(jarPath).getParentFile(), moduleName);
    }

    @Nullable
    private static File getPluginBaseDir(@NonNls String jarPath) {
        if (jarPath.endsWith(".jar")) {
            File jarFile = new File(jarPath);
            LOG.assertTrue(jarFile.exists(), (Object)"jar file cannot be null");
            return jarFile.getParentFile().getParentFile();
        }
        return null;
    }

    @NotNull
    private static File assertHelpersLayout(@NotNull File root) {
        if (root == null) {
            PythonHelpersLocator.$$$reportNull$$$0(3);
        }
        String path2 = root.getAbsolutePath();
        LOG.assertTrue(root.exists(), (Object)("Helpers root does not exist " + path2));
        for (String child : List.of("generator3", "pycharm", "pycodestyle.py", "pydev", "syspath.py", "typeshed")) {
            LOG.assertTrue(new File(root, child).exists(), (Object)("No '" + child + "' inside " + path2));
        }
        File file = root;
        if (file == null) {
            PythonHelpersLocator.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    private static File assertHelpersProLayout(@NotNull File root) {
        if (root == null) {
            PythonHelpersLocator.$$$reportNull$$$0(5);
        }
        String path2 = root.getAbsolutePath();
        LOG.assertTrue(root.exists(), (Object)("Helpers pro root does not exist " + path2));
        LOG.assertTrue(new File(root, EXPECTED_PRO_HELPER_PACKAGE).exists(), (Object)("No 'jupyter_debug' inside " + path2));
        File file = root;
        if (file == null) {
            PythonHelpersLocator.$$$reportNull$$$0(6);
        }
        return file;
    }

    public static String getHelperPath(@NonNls @NotNull String resourceName) {
        if (resourceName == null) {
            PythonHelpersLocator.$$$reportNull$$$0(7);
        }
        return PythonHelpersLocator.getHelperFile(resourceName).getAbsolutePath();
    }

    @NotNull
    public static File getHelperFile(@NotNull String resourceName) {
        if (resourceName == null) {
            PythonHelpersLocator.$$$reportNull$$$0(8);
        }
        return new File(PythonHelpersLocator.getHelpersRoot(), resourceName);
    }

    public static String getPythonCommunityPath() {
        File pathFromUltimate = new File(PathManager.getHomePath(), "community/python");
        if (pathFromUltimate.exists()) {
            return pathFromUltimate.getPath();
        }
        return new File(PathManager.getHomePath(), "python").getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonHelpersLocator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersProRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonHelpersLocator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "assertHelpersLayout";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "assertHelpersProLayout";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHelperRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "assertHelpersLayout";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertHelpersProLayout";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHelperPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHelperFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

