/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PySignatureCacheManagerImpl
extends PySignatureCacheManager {
    private static final Logger LOG = Logger.getInstance((String)PySignatureCacheManagerImpl.class.getName());
    private static final boolean SHOULD_OVERWRITE_TYPES = false;
    public static final FileAttribute CALL_SIGNATURES_ATTRIBUTE = new FileAttribute("call.signatures.attribute", 1, true);
    private final Project myProject;
    private final LoadingCache<VirtualFile, String> mySignatureCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<VirtualFile, String>(){

        @NotNull
        public String load(@NotNull VirtualFile key) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = PySignatureCacheManagerImpl.readAttributeFromFile(key);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PySignatureCacheManagerImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PySignatureCacheManagerImpl$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    });

    public PySignatureCacheManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void recordSignature(@NotNull PySignature signature) {
        if (signature == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = ProjectScope.getProjectScope((Project)this.myProject);
        VirtualFile file = PySignatureCacheManagerImpl.getFile(signature);
        if (file != null && ((Boolean)ReadAction.compute(() -> scope.contains(file))).booleanValue()) {
            this.recordSignature(file, signature);
        }
    }

    private void recordSignature(VirtualFile file, PySignature signature) {
        String dataString = this.readAttribute(file);
        String[] lines = dataString != null ? dataString.split("\n") : ArrayUtilRt.EMPTY_STRING_ARRAY;
        boolean found = false;
        int i = 0;
        for (String sign : lines) {
            String[] parts = sign.split("\t");
            if (parts.length > 0 && parts[0].equals(signature.getFunctionName())) {
                found = true;
                lines[i] = PySignatureCacheManagerImpl.changeSignatureString(file.getCanonicalPath(), signature, lines[i]);
            }
            ++i;
        }
        if (!found) {
            String[] lines2 = new String[lines.length + 1];
            System.arraycopy(lines, 0, lines2, 0, lines.length);
            lines2[lines2.length - 1] = PySignatureCacheManagerImpl.signatureToString(signature);
            lines = lines2;
        }
        String attrString = StringUtil.join((String[])lines, (String)"\n");
        this.writeAttribute(file, attrString);
    }

    static String changeSignatureString(@NotNull String filePath, @NotNull PySignature signature, @NotNull String oldSignatureString) {
        if (filePath == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(2);
        }
        if (oldSignatureString == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(3);
        }
        return PySignatureCacheManagerImpl.signatureToString(PySignatureCacheManagerImpl.stringToSignature(filePath, oldSignatureString).addAllArgs(signature).addReturnType(signature.getReturnTypeQualifiedName()));
    }

    private void writeAttribute(@NotNull VirtualFile file, @NotNull String attrString) {
        String cachedValue;
        if (file == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(4);
        }
        if (attrString == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (!attrString.equals(cachedValue = (String)this.mySignatureCache.asMap().get(file))) {
            this.mySignatureCache.put((Object)file, (Object)attrString);
            PySignatureCacheManagerImpl.writeAttributeToAFile(file, attrString);
        }
    }

    private static void writeAttributeToAFile(@NotNull VirtualFile file, @NotNull String attrString) {
        if (file == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(6);
        }
        if (attrString == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(7);
        }
        try {
            CALL_SIGNATURES_ATTRIBUTE.writeAttributeBytes(file, attrString.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.warn("Can't write attribute " + file.getCanonicalPath() + " " + attrString);
        }
    }

    @Override
    @Nullable
    public String findParameterType(@NotNull PyAstFunction function, @NotNull String name2) {
        PySignature signature;
        if (function == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if ((signature = this.findSignature(function)) != null) {
            return signature.getArgTypeQualifiedName(name2);
        }
        return null;
    }

    @Override
    @Nullable
    public PySignature findSignature(@NotNull PyAstFunction function) {
        VirtualFile file;
        if (function == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if ((file = PySignatureCacheManagerImpl.getFile((PyFunction)function)) != null) {
            return this.readSignatureAttributeFromFile(file, PySignatureCacheManagerImpl.getFunctionName((PyFunction)function));
        }
        return null;
    }

    private static String getFunctionName(PyFunction function) {
        Object name2 = function.getName();
        if (name2 == null) {
            return "";
        }
        PyClass cls = function.getContainingClass();
        if (cls != null) {
            name2 = cls.getName() + "." + (String)name2;
        }
        return name2;
    }

    @Nullable
    private PySignature readSignatureAttributeFromFile(@NotNull VirtualFile file, @NotNull String name2) {
        String content2;
        if (file == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (name2 == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(12);
        }
        if ((content2 = this.readAttribute(file)) != null) {
            String[] lines;
            for (String sign : lines = content2.split("\n")) {
                String[] parts = sign.split("\t");
                if (parts.length <= 0 || !parts[0].equals(name2)) continue;
                return PySignatureCacheManagerImpl.stringToSignature(file.getCanonicalPath(), sign);
            }
        }
        return null;
    }

    @Nullable
    private String readAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(13);
        }
        try {
            String attrContent = (String)this.mySignatureCache.get((Object)file);
            if (!StringUtil.isEmpty((String)attrContent)) {
                return attrContent;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static String readAttributeFromFile(@NotNull VirtualFile file) {
        byte[] data;
        if (file == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(14);
        }
        try {
            data = CALL_SIGNATURES_ATTRIBUTE.readAttributeBytes(file);
        }
        catch (Exception e) {
            data = null;
        }
        String content2 = data != null && data.length > 0 ? new String(data, StandardCharsets.UTF_8) : null;
        return content2 != null ? content2 : "";
    }

    @Nullable
    private static PySignature stringToSignature(@NotNull String path2, @NotNull String string) {
        String[] parts;
        if (path2 == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(15);
        }
        if (string == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(16);
        }
        if ((parts = string.split("\t")).length > 0) {
            PySignature signature = new PySignature(path2, parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i];
                if (part.isEmpty()) continue;
                String[] var = part.split(":");
                if (var.length == 2) {
                    if ("<RETURN_TYPE>".equals(var[0])) {
                        signature = signature.addReturnType(var[1]);
                        continue;
                    }
                    signature = signature.addArgument(var[0], var[1]);
                    continue;
                }
                throw new IllegalStateException("Should be <name>:<type> format for arg or <RETURN_TYPE>:<type> for return type; '" + part + "' instead.");
            }
            return signature;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getFile(@NotNull PySignature signature) {
        if (signature == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(17);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(signature.getFile());
    }

    @Nullable
    private static VirtualFile getFile(@NotNull PyFunction function) {
        PsiFile file;
        if (function == null) {
            PySignatureCacheManagerImpl.$$$reportNull$$$0(18);
        }
        return (file = function.getContainingFile()) != null ? file.getOriginalFile().getVirtualFile() : null;
    }

    @Override
    public boolean clearCache() {
        Ref deleted = Ref.create((Object)false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ProjectFileIndex.getInstance((Project)this.myProject).iterateContent(fileOrDir -> {
            if (this.readAttribute(fileOrDir) != null) {
                this.writeAttribute(fileOrDir, "");
                deleted.set((Object)true);
            }
            return !ProgressManager.getInstance().getProgressIndicator().isCanceled();
        }), PyPsiBundle.message("debugger.cleaning.signature.cache", new Object[0]), true, this.myProject);
        return (Boolean)deleted.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSignatureString";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrString";
                break;
            }
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PySignatureCacheManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "recordSignature";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "changeSignatureString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeAttribute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeAttributeToAFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findParameterType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findSignature";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "readSignatureAttributeFromFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "readAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "readAttributeFromFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "stringToSignature";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

