/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstDecoratorList;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyUpdatePropertySignatureQuickFix;
import com.jetbrains.python.inspections.quickfix.RenameParameterQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyPropertyDefinitionInspection
extends PyInspection {
    private static final ImmutableList<String> SUFFIXES = ImmutableList.of((Object)"setter", (Object)"deleter");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPropertyDefinitionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyPropertyDefinitionInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyPropertyDefinitionInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private final LanguageLevel myLevel;
        private final List<PyClass> myStringClasses;
        private PyFunction myOneParamFunction;
        private PyFunction myTwoParamFunction;

        public Visitor(ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
            PsiFile psiFile = holder.getFile();
            this.myLevel = LanguageLevel.forElement((PsiElement)psiFile);
            ArrayList<PyClass> stringClasses = new ArrayList<PyClass>(2);
            PyBuiltinCache builtins = PyBuiltinCache.getInstance((PsiElement)psiFile);
            PyClass cls = builtins.getClass("str");
            if (cls != null) {
                stringClasses.add(cls);
            }
            if ((cls = builtins.getClass("unicode")) != null) {
                stringClasses.add(cls);
            }
            this.myStringClasses = stringClasses;
            PyClass objectClass = builtins.getClass("object");
            if (objectClass != null) {
                PyFunction methodDelattr;
                PyFunction methodRepr = objectClass.findMethodByName("__repr__", false, null);
                if (methodRepr != null) {
                    this.myOneParamFunction = methodRepr;
                }
                if ((methodDelattr = objectClass.findMethodByName("__delattr__", false, null)) != null) {
                    this.myTwoParamFunction = methodDelattr;
                }
            }
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitPyClass(node);
            node.scanProperties((Processor<? super Property>)((Processor)property -> {
                PyTargetExpression target = property.getDefinitionSite();
                if (target != null) {
                    PyCallExpression call = (PyCallExpression)target.findAssignedValue();
                    assert (call != null) : "Property has a null call assigned to it";
                    PyArgumentList arglist = call.getArgumentList();
                    assert (arglist != null) : "Property call has null arglist";
                    PyCallExpression.PyArgumentsMapping mapping = (PyCallExpression.PyArgumentsMapping)ContainerUtil.getFirstItem(call.multiMapArguments(this.getResolveContext()));
                    if (mapping != null) {
                        for (Map.Entry<PyExpression, PyCallableParameter> entry : mapping.getMappedParameters().entrySet()) {
                            String paramName = entry.getValue().getName();
                            PyExpression argument = PyUtil.peelArgument(entry.getKey());
                            this.checkPropertyCallArgument(paramName, argument, node.getContainingFile());
                        }
                    }
                } else {
                    PyCallable callable = property.getGetter().valueOrNull();
                    if (callable instanceof PyFunction) {
                        this.checkGetter(callable, Visitor.getFunctionMarkingElement((PyFunction)callable));
                    }
                }
                return false;
            }), false);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private void checkPropertyCallArgument(String paramName, PyExpression argument, PsiFile containingFile) {
            void var4_7;
            assert (argument != null) : "Parameter mapped to null argument";
            Object var4_4 = null;
            if (argument instanceof PyReferenceExpression) {
                PsiPolyVariantReference reference = ((PyReferenceExpression)argument).getReference(this.getResolveContext());
                PsiElement resolved = reference.resolve();
                if (!(resolved instanceof PyCallable)) {
                    this.reportNonCallableArg(resolved, (PsiElement)argument);
                    return;
                }
                PyCallable pyCallable = (PyCallable)resolved;
            } else if (argument instanceof PyLambdaExpression) {
                PyLambdaExpression pyLambdaExpression = (PyLambdaExpression)argument;
            } else if (!"doc".equals(paramName)) {
                this.reportNonCallableArg((PsiElement)argument, (PsiElement)argument);
                return;
            }
            if (var4_7 != null && var4_7.getContainingFile() != containingFile) {
                return;
            }
            if ("fget".equals(paramName)) {
                this.checkGetter((PyCallable)var4_7, (PsiElement)argument);
                return;
            }
            if ("fset".equals(paramName)) {
                this.checkSetter((PyCallable)var4_7, (PsiElement)argument);
                return;
            }
            if ("fdel".equals(paramName)) {
                this.checkDeleter((PyCallable)var4_7, (PsiElement)argument);
                return;
            }
            if (!"doc".equals(paramName)) return;
            PyType type2 = this.myTypeEvalContext.getType(argument);
            if (type2 instanceof PyClassType) {
                if (this.myStringClasses.contains(((PyClassType)type2).getPyClass())) return;
            }
            this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.doc.param.should.be.str", new Object[0]));
        }

        private void reportNonCallableArg(PsiElement resolved, PsiElement element) {
            PyType type2;
            Boolean isCallable;
            if (resolved instanceof PySubscriptionExpression || resolved instanceof PyNoneLiteralExpression) {
                return;
            }
            if ("None".equals(element.getText())) {
                return;
            }
            if (resolved instanceof PyTypedElement && (isCallable = PyTypeChecker.isCallable(type2 = this.myTypeEvalContext.getType((PyTypedElement)resolved))) != null && !isCallable.booleanValue()) {
                this.registerProblem(element, PyPsiBundle.message("INSP.strange.arg.want.callable", new Object[0]));
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            PyAstDecoratorList decos;
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitPyFunction(node);
            PyClass cls = node.getContainingClass();
            if (cls != null && (decos = node.getDecoratorList()) != null) {
                String name2 = node.getName();
                for (PyDecorator deco : decos.getDecorators()) {
                    int suffixIndex;
                    List nameParts;
                    QualifiedName qName = deco.getQualifiedName();
                    if (qName == null || (nameParts = qName.getComponents()).size() != 2 || (suffixIndex = SUFFIXES.indexOf(nameParts.get(1))) < 0) continue;
                    if (Objects.equals(name2, nameParts.get(0))) {
                        PsiElement markable = Visitor.getFunctionMarkingElement(node);
                        if (suffixIndex == 0) {
                            this.checkSetter(node, markable);
                            continue;
                        }
                        this.checkDeleter(node, markable);
                        continue;
                    }
                    this.registerProblem((PsiElement)deco, PyPsiBundle.message("INSP.func.property.name.mismatch", new Object[0]));
                }
            }
        }

        @Nullable
        private static PsiElement getFunctionMarkingElement(PyFunction node) {
            if (node == null) {
                return null;
            }
            ASTNode nameNode = node.getNameNode();
            PyFunction markable = node;
            if (nameNode != null) {
                markable = nameNode.getPsi();
            }
            return markable;
        }

        private void checkGetter(PyCallable callable, PsiElement beingChecked) {
            if (callable != null) {
                this.checkOneParameter(callable, beingChecked, true);
                this.checkReturnValueAllowed(callable, beingChecked, true, PyPsiBundle.message("INSP.getter.return.smth", new Object[0]));
            }
        }

        private void checkSetter(PyCallable callable, PsiElement beingChecked) {
            if (callable != null) {
                PyParameterList paramList = callable.getParameterList();
                if (this.myTwoParamFunction != null && !PyUtil.isSignatureCompatibleTo(callable, this.myTwoParamFunction, this.myTypeEvalContext)) {
                    this.registerProblem(beingChecked, PyPsiBundle.message("INSP.setter.signature.advice", new Object[0]), new LocalQuickFix[]{new PyUpdatePropertySignatureQuickFix(true)});
                }
                this.checkForSelf(paramList);
                this.checkReturnValueAllowed(callable, beingChecked, false, PyPsiBundle.message("INSP.setter.should.not.return", new Object[0]));
            }
        }

        private void checkDeleter(PyCallable callable, PsiElement beingChecked) {
            if (callable != null) {
                this.checkOneParameter(callable, beingChecked, false);
                this.checkReturnValueAllowed(callable, beingChecked, false, PyPsiBundle.message("INSP.deleter.should.not.return", new Object[0]));
            }
        }

        private void checkOneParameter(PyCallable callable, PsiElement beingChecked, boolean isGetter) {
            PyParameterList parameterList = callable.getParameterList();
            if (this.myOneParamFunction != null && !PyUtil.isSignatureCompatibleTo(callable, this.myOneParamFunction, this.myTypeEvalContext)) {
                if (isGetter) {
                    this.registerProblem(beingChecked, PyPsiBundle.message("INSP.getter.signature.advice", new Object[0]), new LocalQuickFix[]{new PyUpdatePropertySignatureQuickFix(false)});
                } else {
                    this.registerProblem(beingChecked, PyPsiBundle.message("INSP.deleter.signature.advice", new Object[0]), new LocalQuickFix[]{new PyUpdatePropertySignatureQuickFix(false)});
                }
            }
            this.checkForSelf(parameterList);
        }

        private void checkForSelf(PyParameterList paramList) {
            PyParameter[] parameters = paramList.getParameters();
            PyClass cls = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)paramList, PyClass.class);
            if (cls != null && cls.isSubclass("type", this.myTypeEvalContext)) {
                return;
            }
            if (parameters.length > 0 && !"self".equals(parameters[0].getName())) {
                this.registerProblem((PsiElement)parameters[0], PyPsiBundle.message("INSP.property.cannot.be.deleted", "self"), ProblemHighlightType.WEAK_WARNING, null, new LocalQuickFix[]{new RenameParameterQuickFix("self")});
            }
        }

        private void checkReturnValueAllowed(@NotNull PyCallable callable, @NotNull PsiElement beingChecked, boolean allowed, @NotNull @InspectionMessage String message) {
            if (callable == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (beingChecked == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (message == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (callable instanceof PyFunction) {
                PyFunction function = (PyFunction)callable;
                if (PyKnownDecoratorUtil.hasAbstractDecorator(function, this.myTypeEvalContext)) {
                    return;
                }
                PyClass containingClass = function.getContainingClass();
                if (containingClass != null && PyProtocolsKt.isProtocol(containingClass, this.myTypeEvalContext)) {
                    return;
                }
                if (allowed && !Visitor.someFlowHasExitPoint(function, Visitor::isAllowedExitPoint) || !allowed && Visitor.someFlowHasExitPoint(function, Visitor::isDisallowedExitPoint)) {
                    this.registerProblem(beingChecked, message);
                }
            } else {
                boolean hasReturns;
                PyType type2 = this.myTypeEvalContext.getReturnType(callable);
                boolean bl = hasReturns = !(type2 instanceof PyNoneType);
                if (allowed ^ hasReturns) {
                    this.registerProblem(beingChecked, message);
                }
            }
        }

        private static boolean someFlowHasExitPoint(@NotNull PyFunction function, @NotNull Predicate<PsiElement> exitPointPredicate) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (exitPointPredicate == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            Ref result2 = new Ref((Object)false);
            ControlFlowUtil.process((Instruction[])ControlFlowCache.getControlFlow(function).getInstructions(), (int)0, instruction -> {
                result2.set((Object)exitPointPredicate.test(instruction.getElement()));
                return (Boolean)result2.get() == false;
            });
            return (Boolean)result2.get();
        }

        private static boolean isAllowedExitPoint(@Nullable PsiElement element) {
            return element instanceof PyRaiseStatement || element instanceof PyReturnStatement || element instanceof PyYieldExpression;
        }

        private static boolean isDisallowedExitPoint(@Nullable PsiElement element) {
            return element instanceof PyReturnStatement && ((PyReturnStatement)element).getExpression() != null || element instanceof PyYieldExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beingChecked";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exitPointPredicate";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPropertyDefinitionInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkReturnValueAllowed";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "someFlowHasExitPoint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

