/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstTargetExpression;
import com.jetbrains.python.psi.PyAsPattern;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyDoubleStarPattern;
import com.jetbrains.python.psi.PyGroupPattern;
import com.jetbrains.python.psi.PyKeyValuePattern;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyLiteralPattern;
import com.jetbrains.python.psi.PyMappingPattern;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyOrPattern;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyPatternArgumentList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PySequencePattern;
import com.jetbrains.python.psi.PySingleStarPattern;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyValuePattern;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PyPatternAnnotator
extends PyAnnotator {
    @Override
    public void visitPySingleStarPattern(@NotNull PySingleStarPattern starPattern) {
        PsiElement parent;
        if (starPattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(0);
        }
        if (!((parent = starPattern.getParent()) instanceof PySequencePattern)) {
            this.markError((PsiElement)starPattern, PyPsiBundle.message("ANN.patterns.single.star.pattern.cannot.be.used.outside.sequence.patterns", new Object[0]));
        }
    }

    @Override
    public void visitPyDoubleStarPattern(@NotNull PyDoubleStarPattern starPattern) {
        PsiElement parent;
        if (starPattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(1);
        }
        if (!((parent = starPattern.getParent()) instanceof PyMappingPattern)) {
            this.markError((PsiElement)starPattern, PyPsiBundle.message("ANN.patterns.double.star.pattern.cannot.be.used.outside.mapping.patterns", new Object[0]));
        }
    }

    @Override
    public void visitPyLiteralPattern(@NotNull PyLiteralPattern literalPattern) {
        PyNumericLiteralExpression rightOperand;
        PyBinaryExpression expression;
        if (literalPattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(2);
        }
        if ((expression = PyUtil.as(literalPattern.getExpression(), PyBinaryExpression.class)) != null && (rightOperand = PyUtil.as(expression.getRightExpression(), PyNumericLiteralExpression.class)) != null && rightOperand.getFirstChild().getNode().getElementType() != PyTokenTypes.IMAGINARY_LITERAL) {
            this.markError((PsiElement)expression, PyPsiBundle.message("ANN.patterns.invalid.complex.number.literal", new Object[0]));
        }
    }

    @Override
    public void visitPyKeyValuePattern(@NotNull PyKeyValuePattern keyValuePattern) {
        PyPattern keyPattern;
        if (keyValuePattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(3);
        }
        if (!((keyPattern = keyValuePattern.getKeyPattern()) instanceof PyValuePattern) && !(keyPattern instanceof PyLiteralPattern)) {
            this.markError((PsiElement)keyPattern, PyPsiBundle.message("ANN.patterns.key.pattern.can.only.be.value.or.literal.pattern", new Object[0]));
        }
    }

    @Override
    public void visitPyOrPattern(@NotNull PyOrPattern orPattern) {
        Set boundNames;
        if (orPattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(4);
        }
        List<PyPattern> alternatives = orPattern.getAlternatives();
        PyPattern lastAlternative = alternatives.get(alternatives.size() - 1);
        HashMap<PyPattern, Set> patternToBoundNames = new HashMap<PyPattern, Set>();
        HashSet allBoundNames = new HashSet();
        for (PyPattern pyPattern : alternatives) {
            boundNames = SyntaxTraverser.psiTraverser((PsiElement)pyPattern).filter(PyTargetExpression.class).map(PyAstTargetExpression::getName).toSet();
            patternToBoundNames.put(pyPattern, boundNames);
            allBoundNames.addAll(boundNames);
            if (pyPattern == lastAlternative || !pyPattern.isIrrefutable()) continue;
            this.markError((PsiElement)pyPattern, PyPsiBundle.message("ANN.patterns.pattern.makes.remaining.alternatives.unreachable", new Object[0]));
        }
        for (Map.Entry entry : patternToBoundNames.entrySet()) {
            boundNames = (Set)entry.getValue();
            if (boundNames.equals(allBoundNames)) continue;
            Collection missingNames = ContainerUtil.subtract(allBoundNames, (Collection)boundNames);
            String nameList = StringUtil.join((Collection)ContainerUtil.sorted((Collection)missingNames), (String)", ");
            this.markError((PsiElement)entry.getKey(), PyPsiBundle.message("ANN.patterns.pattern.does.not.bind.names", missingNames.size(), nameList));
        }
    }

    @Override
    public void visitPyMatchStatement(@NotNull PyMatchStatement matchStatement) {
        List<PyCaseClause> clauses;
        if (matchStatement == null) {
            PyPatternAnnotator.$$$reportNull$$$0(5);
        }
        if ((clauses = matchStatement.getCaseClauses()).isEmpty()) {
            return;
        }
        for (PyCaseClause clause : clauses.subList(0, clauses.size() - 1)) {
            PyPattern unwrappedPattern;
            PyPattern pattern = clause.getPattern();
            if (pattern == null || (unwrappedPattern = PyPatternAnnotator.unwrapGroupAndAsPatterns(pattern)) instanceof PySingleStarPattern || unwrappedPattern instanceof PyDoubleStarPattern || clause.getGuardCondition() != null || !pattern.isIrrefutable()) continue;
            this.markError((PsiElement)pattern, PyPsiBundle.message("ANN.patterns.pattern.makes.remaining.case.clauses.unreachable", new Object[0]));
        }
    }

    @Override
    public void visitPyPatternArgumentList(@NotNull PyPatternArgumentList argumentList) {
        if (argumentList == null) {
            PyPatternAnnotator.$$$reportNull$$$0(6);
        }
        HashSet<String> usedAttrNames = new HashSet<String>();
        for (PyPattern attrPattern : argumentList.getPatterns()) {
            PyKeywordPattern keywordPattern = PyUtil.as(attrPattern, PyKeywordPattern.class);
            if (keywordPattern == null || usedAttrNames.add(keywordPattern.getKeyword())) continue;
            this.markError(keywordPattern.getKeywordElement(), PyPsiBundle.message("ANN.patterns.attribute.name.is.repeated", keywordPattern.getKeyword()));
        }
    }

    @Override
    public void visitPyCaseClause(@NotNull PyCaseClause caseClause) {
        PyPattern pattern;
        if (caseClause == null) {
            PyPatternAnnotator.$$$reportNull$$$0(7);
        }
        if ((pattern = caseClause.getPattern()) == null) {
            return;
        }
        final Stack boundNamesPerOrBranch = new Stack();
        boundNamesPerOrBranch.push(new HashSet());
        pattern.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyOrPattern(@NotNull PyOrPattern orPattern) {
                if (orPattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashSet allBoundNamesInOrPattern = new HashSet();
                for (PyPattern alternative : orPattern.getAlternatives()) {
                    boundNamesPerOrBranch.push(new HashSet());
                    alternative.accept(this);
                    allBoundNamesInOrPattern.addAll((Collection)boundNamesPerOrBranch.peek());
                    boundNamesPerOrBranch.pop();
                }
                ((Set)boundNamesPerOrBranch.peek()).addAll(allBoundNamesInOrPattern);
            }

            @Override
            public void visitPyTargetExpression(@NotNull PyTargetExpression target) {
                String name2;
                boolean alreadyBound;
                if (target == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (alreadyBound = ContainerUtil.exists((Iterable)boundNamesPerOrBranch, arg_0 -> 1.lambda$visitPyTargetExpression$0(name2 = target.getName(), arg_0))) {
                    PyPatternAnnotator.this.markError(target, PyPsiBundle.message("ANN.patterns.name.already.bound", name2));
                }
                ((Set)boundNamesPerOrBranch.peek()).add(name2);
            }

            private static /* synthetic */ boolean lambda$visitPyTargetExpression$0(String name2, Set names2) {
                return names2.contains(name2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orPattern";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/validation/PyPatternAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyOrPattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyTargetExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void visitPySequencePattern(@NotNull PySequencePattern sequencePattern) {
        List starPatterns;
        if (sequencePattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(8);
        }
        if ((starPatterns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)sequencePattern, PySingleStarPattern.class)).size() > 1) {
            for (PySingleStarPattern pattern : starPatterns.subList(1, starPatterns.size())) {
                this.markError((PsiElement)pattern, PyPsiBundle.message("ANN.patterns.repeated.star.pattern", new Object[0]));
            }
        }
    }

    @Override
    public void visitPyMappingPattern(@NotNull PyMappingPattern mappingPattern) {
        List starPatterns;
        if (mappingPattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(9);
        }
        if ((starPatterns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)mappingPattern, PyDoubleStarPattern.class)).size() > 1) {
            for (PyDoubleStarPattern pattern : starPatterns.subList(1, starPatterns.size())) {
                this.markError((PsiElement)pattern, PyPsiBundle.message("ANN.patterns.repeated.star.pattern", new Object[0]));
            }
        }
    }

    @NotNull
    private static PyPattern unwrapGroupAndAsPatterns(@NotNull PyPattern pattern) {
        if (pattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(10);
        }
        if (pattern instanceof PyGroupPattern) {
            return PyPatternAnnotator.unwrapGroupAndAsPatterns(((PyGroupPattern)pattern).getPattern());
        }
        if (pattern instanceof PyAsPattern) {
            return PyPatternAnnotator.unwrapGroupAndAsPatterns(((PyAsPattern)pattern).getPattern());
        }
        PyPattern pyPattern = pattern;
        if (pyPattern == null) {
            PyPatternAnnotator.$$$reportNull$$$0(11);
        }
        return pyPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starPattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalPattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValuePattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseClause";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequencePattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingPattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/validation/PyPatternAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/validation/PyPatternAnnotator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapGroupAndAsPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitPySingleStarPattern";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDoubleStarPattern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyLiteralPattern";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyKeyValuePattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyOrPattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMatchStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPatternArgumentList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCaseClause";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitPySequencePattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMappingPattern";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unwrapGroupAndAsPatterns";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

