/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.toml.TomlArray;
import org.apache.tuweni.toml.TomlTable;
import org.apache.tuweni.toml.TomlType;

final class JsonSerializer {
    private JsonSerializer() {
    }

    static void toJson(TomlTable table, Appendable appendable) throws IOException {
        Objects.requireNonNull(table);
        Objects.requireNonNull(appendable);
        JsonSerializer.toJson(table, appendable, 0);
        appendable.append(System.lineSeparator());
    }

    private static void toJson(TomlTable table, Appendable appendable, int indent) throws IOException {
        if (table.isEmpty()) {
            appendable.append("{}");
            return;
        }
        JsonSerializer.appendLine(appendable, "{");
        Iterator iterator = table.keySet().stream().sorted().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JsonSerializer.append(appendable, indent + 2, "\"" + JsonSerializer.escape(key) + "\" : ");
            Object value = table.get(Collections.singletonList(key));
            assert (value != null);
            JsonSerializer.appendTomlValue(value, appendable, indent);
            if (!iterator.hasNext()) continue;
            appendable.append(",");
            appendable.append(System.lineSeparator());
        }
        appendable.append(System.lineSeparator());
        JsonSerializer.append(appendable, indent, "}");
    }

    static void toJson(TomlArray array, Appendable appendable) throws IOException {
        JsonSerializer.toJson(array, appendable, 0);
        appendable.append(System.lineSeparator());
    }

    private static void toJson(TomlArray array, Appendable appendable, int indent) throws IOException {
        if (array.isEmpty()) {
            appendable.append("[]");
            return;
        }
        if (array.containsTables()) {
            JsonSerializer.append(appendable, 0, "[");
            Iterator<Object> iterator = array.toList().iterator();
            while (iterator.hasNext()) {
                JsonSerializer.toJson((TomlTable)iterator.next(), appendable, indent);
                if (!iterator.hasNext()) continue;
                appendable.append(",");
            }
            JsonSerializer.append(appendable, 0, "]");
        } else {
            JsonSerializer.appendLine(appendable, "[");
            Iterator<Object> iterator = array.toList().iterator();
            while (iterator.hasNext()) {
                JsonSerializer.indentLine(appendable, indent + 2);
                JsonSerializer.appendTomlValue(iterator.next(), appendable, indent);
                if (!iterator.hasNext()) continue;
                appendable.append(",");
                appendable.append(System.lineSeparator());
            }
            appendable.append(System.lineSeparator());
            JsonSerializer.append(appendable, indent, "]");
        }
    }

    private static void appendTomlValue(Object value, Appendable appendable, int indent) throws IOException {
        Optional<TomlType> tomlType = TomlType.typeFor(value);
        assert (tomlType.isPresent());
        switch (tomlType.get()) {
            case STRING: {
                JsonSerializer.append(appendable, 0, "\"" + JsonSerializer.escape((String)value) + "\"");
                break;
            }
            case INTEGER: 
            case FLOAT: {
                JsonSerializer.append(appendable, 0, value.toString());
                break;
            }
            case BOOLEAN: {
                JsonSerializer.append(appendable, 0, (Boolean)value != false ? "true" : "false");
                break;
            }
            case OFFSET_DATE_TIME: 
            case LOCAL_DATE_TIME: 
            case LOCAL_DATE: 
            case LOCAL_TIME: {
                JsonSerializer.append(appendable, 0, "\"" + value.toString() + "\"");
                break;
            }
            case ARRAY: {
                JsonSerializer.toJson((TomlArray)value, appendable, indent + 2);
                break;
            }
            case TABLE: {
                JsonSerializer.toJson((TomlTable)value, appendable, indent + 2);
            }
        }
    }

    private static void append(Appendable appendable, int indent, String line2) throws IOException {
        JsonSerializer.indentLine(appendable, indent);
        appendable.append(line2);
    }

    private static void appendLine(Appendable appendable, String line2) throws IOException {
        appendable.append(line2);
        appendable.append(System.lineSeparator());
    }

    private static void indentLine(Appendable appendable, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            appendable.append(' ');
        }
    }

    private static StringBuilder escape(String text) {
        StringBuilder out = new StringBuilder(text.length());
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\"') {
                out.append("\\\"");
                continue;
            }
            if (ch >= ' ') {
                out.append(ch);
                continue;
            }
            switch (ch) {
                case '\t': {
                    out.append("\\t");
                    continue block7;
                }
                case '\b': {
                    out.append("\\b");
                    continue block7;
                }
                case '\n': {
                    out.append("\\n");
                    continue block7;
                }
                case '\r': {
                    out.append("\\r");
                    continue block7;
                }
                case '\f': {
                    out.append("\\f");
                    continue block7;
                }
                default: {
                    out.append("\\u").append(String.format("%04x", text.codePointAt(i)));
                }
            }
        }
        return out;
    }
}

