/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.data.util.VcsCommitsDataLoader;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.commit.signature.GitCommitSignature;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001(B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J*\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0005J4\u0010\u001e\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u001e\u0010!\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020\u0018\u0012\u0004\u0012\u00020\u00160\"J*\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%H\u0002JJ\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001f0\u00182\u001e\u0010!\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020\u0018\u0012\u0004\u0012\u00020\u00160\"H$R/\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/log/GitCommitSignatureLoaderBase;", "Lcom/intellij/vcs/log/data/util/VcsCommitsDataLoader;", "Lgit4idea/commit/signature/GitCommitSignature;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "Lcom/intellij/openapi/progress/ProgressIndicator;", "currentIndicator", "getCurrentIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setCurrentIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "currentIndicator$delegate", "Lkotlin/properties/ReadWriteProperty;", "createSignature", "status", "", "signer", "fingerprint", "dispose", "", "loadCommitSignatures", "", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "commits", "", "loadData", "", "Lcom/intellij/vcs/log/CommitId;", "onChange", "Lkotlin/Function1;", "parseSignatures", "lines", "Lkotlin/sequences/Sequence;", "requestData", "indicator", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitSignatureLoaderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitSignatureLoaderBase.kt\ngit4idea/log/GitCommitSignatureLoaderBase\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n33#2,3:122\n1490#3:125\n1520#3,3:126\n1523#3,3:136\n1549#3:146\n1620#3,3:147\n372#4,7:129\n526#4:139\n511#4,6:140\n31#5,2:150\n1#6:152\n11#7:153\n*S KotlinDebug\n*F\n+ 1 GitCommitSignatureLoaderBase.kt\ngit4idea/log/GitCommitSignatureLoaderBase\n*L\n26#1:122,3\n34#1:125\n34#1:126,3\n34#1:136,3\n63#1:146\n63#1:147,3\n34#1:129,7\n34#1:139\n34#1:140,6\n70#1:150,2\n110#1:153\n*E\n"})
public abstract class GitCommitSignatureLoaderBase
implements VcsCommitsDataLoader<GitCommitSignature>,
Disposable {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final ReadWriteProperty currentIndicator$delegate;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String NEW_LINE = "%n";
    @NotNull
    private static final String HASH = "%H";
    @NotNull
    private static final String SIGNATURE_STATUS = "%G?";
    @NotNull
    private static final String SIGNER = "%GS";
    @NotNull
    private static final String FINGERPRINT = "%GF";
    @NotNull
    private static final String COMMIT_SIGNATURES_FORMAT;

    public GitCommitSignatureLoaderBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Delegates delegates = Delegates.INSTANCE;
        Object initialValue$iv = null;
        boolean $i$f$observable = false;
        this.currentIndicator$delegate = (ReadWriteProperty)new ObservableProperty<ProgressIndicator>(initialValue$iv){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue2) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    ProgressIndicator cfr_ignored_0 = (ProgressIndicator)newValue2;
                    ProgressIndicator old = (ProgressIndicator)oldValue;
                    boolean bl = false;
                    ProgressIndicator progressIndicator = old;
                    if (progressIndicator == null) break block0;
                    progressIndicator.cancel();
                }
            }
        };
    }

    private final ProgressIndicator getCurrentIndicator() {
        return (ProgressIndicator)this.currentIndicator$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setCurrentIndicator(ProgressIndicator progressIndicator) {
        this.currentIndicator$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadData(@NotNull List<CommitId> commits2, @NotNull Function1<? super Map<CommitId, ? extends GitCommitSignature>, Unit> onChange) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
        this.setCurrentIndicator((ProgressIndicator)new EmptyProgressIndicator());
        ProgressIndicator progressIndicator = this.getCurrentIndicator();
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator indicator = progressIndicator;
        Object $this$groupBy$iv = commits2;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            CommitId it2 = (CommitId)element$iv$iv;
            boolean $i$a$-groupBy-GitCommitSignatureLoaderBase$loadData$commitsByRoot$32 = false;
            VirtualFile key$iv$iv = it2.getRoot();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            CommitId $i$a$-groupBy-GitCommitSignatureLoaderBase$loadData$commitsByRoot$32 = (CommitId)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl = false;
            list2.add(it.getHash());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object object = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            VirtualFile root = (VirtualFile)object.getKey();
            if (!(GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root) != null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map commitsByRoot = destination$iv$iv;
        if (commitsByRoot.isEmpty()) {
            return;
        }
        this.requestData(indicator, commitsByRoot, onChange);
    }

    protected abstract void requestData(@NotNull ProgressIndicator var1, @NotNull Map<VirtualFile, ? extends List<? extends Hash>> var2, @NotNull Function1<? super Map<CommitId, ? extends GitCommitSignature>, Unit> var3);

    public void dispose() {
        this.setCurrentIndicator(null);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    protected final Map<Hash, GitCommitSignature> loadCommitSignatures(@NotNull VirtualFile root, @NotNull Collection<? extends Hash> commits2) throws VcsException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, root);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"createGitHandler(...)");
        GitLineHandler h = gitLineHandler;
        h.setStdoutSuppressed(true);
        String[] stringArray = new String[]{GitLogUtil.getNoWalkParameter(this.project)};
        h.addParameters(stringArray);
        stringArray = new String[]{"--format=" + COMMIT_SIGNATURES_FORMAT};
        h.addParameters(stringArray);
        stringArray = new String[]{"--stdin"};
        h.addParameters(stringArray);
        h.endOptions();
        Iterable $this$map$iv = commits2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Hash hash = (Hash)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        GitLogUtil.sendHashesToStdin((List)destination$iv$iv, h);
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        String output = string;
        return this.parseSignatures(this.project, (Sequence<String>)StringsKt.lineSequence((CharSequence)output));
    }

    private final Map<Hash, GitCommitSignature> parseSignatures(Project project, Sequence<String> lines) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<VcsLogObjectsFactory> serviceClass$iv = VcsLogObjectsFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VcsLogObjectsFactory factory = (VcsLogObjectsFactory)object;
        Map result2 = new LinkedHashMap();
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            GitCommitSignature it;
            Hash hash;
            Intrinsics.checkNotNullExpressionValue((Object)factory.createHash((String)iterator.next()), (String)"createHash(...)");
            GitCommitSignature signature = this.createSignature((String)iterator.next(), (String)iterator.next(), (String)iterator.next());
            if (signature == null) continue;
            boolean bl = false;
            result2.put(hash, it);
        }
        return result2;
    }

    private final GitCommitSignature createSignature(String status, String signer, String fingerprint) {
        return switch (status) {
            case "G" -> new GitCommitSignature.Verified(signer, fingerprint);
            case "U" -> new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.UNKNOWN);
            case "X" -> new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.EXPIRED);
            case "Y" -> new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.EXPIRED_KEY);
            case "R" -> new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.REVOKED_KEY);
            case "E" -> new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.CANNOT_VERIFY);
            case "B" -> GitCommitSignature.Bad.INSTANCE;
            case "N" -> null;
            default -> {
                Object var5_5;
                Object it = var5_5 = null;
                boolean $i$a$-also-GitCommitSignatureLoaderBase$createSignature$1 = false;
                LOG.error("Unknown signature status " + status);
                yield var5_5;
            }
        };
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GitCommitSignatureLoaderBase.class, "currentIndicator", "getCurrentIndicator()Lcom/intellij/openapi/progress/ProgressIndicator;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitCommitSignatureLoaderBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{HASH, SIGNATURE_STATUS, SIGNER, FINGERPRINT};
        COMMIT_SIGNATURES_FORMAT = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)NEW_LINE, null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/log/GitCommitSignatureLoaderBase$Companion;", "", "()V", "COMMIT_SIGNATURES_FORMAT", "", "FINGERPRINT", "HASH", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NEW_LINE", "SIGNATURE_STATUS", "SIGNER", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

