/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.guest.markdown;

import com.intellij.cwm.guest.markdown.FrontendMarkdownSplitEditorProvider;
import com.intellij.cwm.guest.markdown.MarkdownFrontendEditorModelHandlerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.FileEditorModel;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextFileEditorModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorModelHandler;
import com.jetbrains.rdclient.fileEditors.FrontendTextEditorProvider;
import com.jetbrains.rdclient.fileEditors.FrontendTextFileEditor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/cwm/guest/markdown/MarkdownFrontendEditorModelHandler;", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorModelHandler;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "model", "Lcom/jetbrains/rd/ide/model/FileEditorModel;", "createEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.cwm.guest.markdown"})
public final class MarkdownFrontendEditorModelHandler
implements FrontendFileEditorModelHandler {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileEditorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (!MarkdownHtmlPanelProvider.hasAvailableProviders()) {
            MarkdownFrontendEditorModelHandlerKt.access$getLogger$p().warn("There are no available html panel providers");
            return false;
        }
        return MarkdownLanguageUtilsKt.hasMarkdownType((VirtualFile)file) || EditorUtilKt.isMarkdownScratchFile((Project)project, (VirtualFile)file);
    }

    @NotNull
    public FileEditorWithProvider createEditorWithProvider(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull VirtualFile file, @NotNull FileEditorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        TextControlId editorId = ((TextFileEditorModel)model).getEditorId();
        FrontendTextEditorProvider textEditorProvider = new FrontendTextEditorProvider(model.getProvider());
        Editor editor = FrontendTextControlHostKt.toEditor((TextControlId)editorId);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        FrontendTextFileEditor textEditor = new FrontendTextFileEditor((EditorImpl)editor, file, textEditorProvider);
        FrontendMarkdownSplitEditorProvider provider = new FrontendMarkdownSplitEditorProvider(textEditor, model.getProvider().getProviderId());
        FileEditor editor2 = provider.createEditor(project, file);
        return new FileEditorWithProvider(editor2, (FileEditorProvider)provider);
    }
}

