/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.combined.search;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.tools.combined.CombinedDiffMainUI;
import com.intellij.diff.tools.combined.CombinedDiffViewer;
import com.intellij.diff.tools.combined.CombinedDiffViewerKt;
import com.intellij.diff.tools.combined.search.CombinedDiffSearchContext;
import com.intellij.diff.tools.combined.search.CombinedDiffSearchController;
import com.intellij.diff.tools.combined.search.CombinedDiffSearchProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.combined.search.CombinedDiffSearchProviderImpl;
import com.intellij.openapi.diff.impl.combined.search.CombinedEditorSearchSession;
import com.intellij.openapi.diff.impl.combined.search.CombinedEditorSearchSessionListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedDiffSearchProviderImpl;", "Lcom/intellij/diff/tools/combined/search/CombinedDiffSearchProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "installSearch", "", "viewer", "Lcom/intellij/diff/tools/combined/CombinedDiffViewer;", "CombinedDiffSearchControllerImpl", "intellij.platform.vcs.impl"})
public final class CombinedDiffSearchProviderImpl
implements CombinedDiffSearchProvider {
    @NotNull
    private final Project project;

    public CombinedDiffSearchProviderImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public void installSearch(@NotNull CombinedDiffViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        CombinedDiffMainUI mainUI = viewer.getMainUI();
        FrameDiffTool.DiffViewer diffViewer = viewer.getCurrentDiffViewer();
        if (diffViewer == null || (diffViewer = CombinedDiffViewerKt.getCurrentEditor((FrameDiffTool.DiffViewer)diffViewer)) == null) {
            return;
        }
        FrameDiffTool.DiffViewer currentEditor = diffViewer;
        CombinedDiffSearchControllerImpl searchController2 = new CombinedDiffSearchControllerImpl(this.project, (Editor)currentEditor, viewer, (Function0<Unit>)((Function0)new Function0<Unit>((Object)mainUI){

            public final void invoke() {
                ((CombinedDiffMainUI)this.receiver).closeSearch();
            }
        }), mainUI.getComponent());
        mainUI.setSearchController((CombinedDiffSearchController)searchController2);
        searchController2.getSession().getComponent().requestFocusInTheSearchFieldAndSelectContent(this.project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u000f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedDiffSearchProviderImpl$CombinedDiffSearchControllerImpl;", "Lcom/intellij/diff/tools/combined/search/CombinedDiffSearchController;", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSessionListener;", "project", "Lcom/intellij/openapi/project/Project;", "currentEditor", "Lcom/intellij/openapi/editor/Editor;", "viewer", "Lcom/intellij/diff/tools/combined/CombinedDiffViewer;", "closeAction", "Lkotlin/Function0;", "", "parentComponent", "Ljavax/swing/JComponent;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/diff/tools/combined/CombinedDiffViewer;Lkotlin/jvm/functions/Function0;Ljavax/swing/JComponent;)V", "searchComponent", "getSearchComponent", "()Ljavax/swing/JComponent;", "session", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;", "getSession", "()Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;", "isSearchComponentInFocus", "", "onSearch", "forward", "editor", "statusTextChanged", "matches", "", "files", "update", "context", "Lcom/intellij/diff/tools/combined/search/CombinedDiffSearchContext;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCombinedDiffSearchProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedDiffSearchProviderImpl.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedDiffSearchProviderImpl$CombinedDiffSearchControllerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
    private static final class CombinedDiffSearchControllerImpl
    implements CombinedDiffSearchController,
    CombinedEditorSearchSessionListener {
        @NotNull
        private final CombinedDiffViewer viewer;
        @NotNull
        private final CombinedEditorSearchSession session;

        /*
         * WARNING - void declaration
         */
        public CombinedDiffSearchControllerImpl(@NotNull Project project2, @NotNull Editor currentEditor, @NotNull CombinedDiffViewer viewer, @NotNull Function0<Unit> closeAction, @NotNull JComponent parentComponent) {
            void it;
            CombinedEditorSearchSession combinedEditorSearchSession;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)currentEditor, (String)"currentEditor");
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            Intrinsics.checkNotNullParameter(closeAction, (String)"closeAction");
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            this.viewer = viewer;
            CombinedEditorSearchSession combinedEditorSearchSession2 = combinedEditorSearchSession = new CombinedEditorSearchSession(project2, currentEditor, closeAction, parentComponent, (Disposable)this.viewer);
            CombinedDiffSearchControllerImpl combinedDiffSearchControllerImpl = this;
            boolean bl = false;
            it.addListener(this);
            combinedDiffSearchControllerImpl.session = combinedEditorSearchSession;
            this.session.update(this.viewer.createSearchContext().getHolders(), (Function1)1.INSTANCE, currentEditor);
        }

        @NotNull
        public final CombinedEditorSearchSession getSession() {
            return this.session;
        }

        @NotNull
        public JComponent getSearchComponent() {
            return (JComponent)this.session.getComponent();
        }

        public void update(@NotNull CombinedDiffSearchContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CombinedEditorSearchSession.update$default(this.session, context.getHolders(), (Function1)update.1.INSTANCE, null, 4, null);
        }

        @Override
        public void onSearch(boolean forward, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.viewer.scrollToEditor(editor, !this.isSearchComponentInFocus());
        }

        @Override
        public void statusTextChanged(int matches, int files2) {
            int totalFilesCount = this.viewer.getDiffBlocksCount();
            String statusKey = totalFilesCount != files2 ? "diff.files.editors.search.partly.matches" : "diff.files.editors.search.matches";
            Object[] objectArray = new Object[2];
            objectArray[0] = matches;
            Object[] objectArray2 = new Object[]{files2};
            objectArray[1] = DiffBundle.message((String)"diff.files.editors.search.files.count", (Object[])objectArray2);
            String string2 = DiffBundle.message((String)statusKey, (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.session.setStatusText(string2);
        }

        private final boolean isSearchComponentInFocus() {
            return UIUtil.isFocusAncestor((Component)((Component)this.session.getComponent()));
        }
    }
}

