/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.codeInsight;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryDirectory;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryFile;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IgnoreDirectoryMarkerProvider
extends LineMarkerProviderDescriptor
implements DumbAware {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            PsiElement leafElement;
            ProgressManager.checkCanceled();
            if (!(psiElement instanceof IgnoreEntryFile)) continue;
            boolean isDirectory = psiElement instanceof IgnoreEntryDirectory;
            if (!isDirectory) {
                IgnoreEntryFile entry2 = (IgnoreEntryFile)psiElement;
                VirtualFile parent = psiElement.getContainingFile().getVirtualFile().getParent();
                Project project2 = psiElement.getProject();
                VirtualFile projectDir = project2.getBaseDir();
                if (parent == null || projectDir == null) continue;
                PatternCache patternCache = PatternCache.getInstance(psiElement.getProject());
                Pattern pattern2 = patternCache.createPattern(entry2);
                boolean bl = isDirectory = pattern2 != null && IgnoreDirectoryMarkerProvider.isDirectoryExist(parent, pattern2);
            }
            if (!isDirectory || (leafElement = IgnoreDirectoryMarkerProvider.firstLeafOrNull(psiElement)) == null) continue;
            result2.add(new LineMarkerInfo(leafElement, psiElement.getTextRange(), PlatformIcons.FOLDER_ICON, null, null, GutterIconRenderer.Alignment.CENTER));
        }
    }

    @NotNull
    public String getName() {
        String string2 = VcsBundle.message("gutter.name.version.control.ignored.directories", new Object[0]);
        if (string2 == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = PlatformIcons.FOLDER_ICON;
        if (icon2 == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(4);
        }
        return icon2;
    }

    @Nullable
    private static PsiElement firstLeafOrNull(@NotNull PsiElement element) {
        LeafElement firstLeaf;
        if (element == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(5);
        }
        return (firstLeaf = TreeUtil.findFirstLeaf((ASTNode)element.getNode())) != null ? firstLeaf.getPsi() : null;
    }

    private static boolean isDirectoryExist(@NotNull VirtualFile root, @NotNull Pattern pattern2) {
        if (root == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(6);
        }
        if (pattern2 == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(7);
        }
        Ref found = Ref.create((Object)false);
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, file -> file.isDirectory(), dir -> {
            ProgressManager.checkCanceled();
            String path2 = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)root);
            if (path2 != null && RegexUtil.match(pattern2, path2)) {
                found.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)found.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ignore/codeInsight/IgnoreDirectoryMarkerProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/codeInsight/IgnoreDirectoryMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "firstLeafOrNull";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryExist";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

