/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusActionBase
extends DumbAwareAction {
    public static final DataKey<Integer> SELECTED_OFFSET_KEY = DataKey.create((String)"VCS_LINE_MARKER_SELECTED_OFFSET_KEY");

    public void update(@NotNull AnActionEvent e) {
        int line;
        if (e == null) {
            LineStatusActionBase.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Integer selectedOffset = (Integer)e.getData(SELECTED_OFFSET_KEY);
        if (project2 == null || editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(editor.getDocument());
        if (!(tracker != null && tracker.isValid() && tracker.isAvailableAt(editor) && this.isEnabled(tracker, editor))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean isEnabled = selectedOffset != null ? tracker.getRangeForLine(line = editor.getDocument().getLineNumber(selectedOffset.intValue())) != null : LineStatusActionBase.isSomeChangeSelected(editor, tracker);
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(isEnabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            LineStatusActionBase.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            LineStatusActionBase.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Integer selectedOffset = (Integer)e.getData(SELECTED_OFFSET_KEY);
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(editor.getDocument());
        assert (tracker != null);
        Range range = null;
        if (selectedOffset != null) {
            int line = editor.getDocument().getLineNumber(selectedOffset.intValue());
            range = tracker.getRangeForLine(line);
        }
        this.doAction(tracker, editor, range);
    }

    private static boolean isSomeChangeSelected(@NotNull Editor editor, @NotNull LineStatusTrackerI<?> tracker) {
        if (editor == null) {
            LineStatusActionBase.$$$reportNull$$$0(3);
        }
        if (tracker == null) {
            LineStatusActionBase.$$$reportNull$$$0(4);
        }
        return DiffUtil.isSomeRangeSelected((Editor)editor, lines -> !ContainerUtil.isEmpty((Collection)tracker.getRangesForLines(lines)));
    }

    protected boolean isEnabled(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        if (tracker == null) {
            LineStatusActionBase.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            LineStatusActionBase.$$$reportNull$$$0(6);
        }
        return true;
    }

    protected abstract void doAction(@NotNull LineStatusTrackerI<?> var1, @NotNull Editor var2, @Nullable Range var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusActionBase";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusActionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSomeChangeSelected";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

