/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.console;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.console.VcsConsoleTabService;
import com.intellij.vcs.console.VcsConsoleView;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\n\u001a\u00020\u000b2\r\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0017J\u001a\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0017J\b\u0010\u001d\u001a\u00020\u000bH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/console/VcsConsoleTabServiceImpl;", "Lcom/intellij/vcs/console/VcsConsoleTabService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleView", "Lcom/intellij/vcs/console/VcsConsoleView;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addMessage", "", "message", "", "Lorg/jetbrains/annotations/Nls;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "line", "Lcom/intellij/openapi/vcs/VcsConsoleLine;", "createConsoleContentTab", "Lcom/intellij/ui/content/Content;", "dispose", "isConsoleEmpty", "", "isConsoleVisible", "showConsoleTab", "selectContent", "onShown", "Ljava/lang/Runnable;", "showConsoleTabAndScrollToTheEnd", "Companion", "intellij.platform.vcs.impl"})
public final class VcsConsoleTabServiceImpl
implements VcsConsoleTabService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsConsoleView consoleView;

    public VcsConsoleTabServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.consoleView = new VcsConsoleView(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.consoleView));
    }

    @Override
    public void addMessage(@Nullable String message2, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.addMessage(VcsConsoleLine.create(message2, contentType));
    }

    @Override
    public void addMessage(@Nullable VcsConsoleLine line) {
        if (line == null) {
            return;
        }
        if (this.project.isDisposed() || this.project.isDefault()) {
            return;
        }
        line.print((ConsoleView)this.consoleView);
        if (Registry.is((String)"vcs.showConsole")) {
            ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ VcsConsoleTabServiceImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.showConsoleTab(false, null);
                }
            }));
        }
    }

    @Override
    @RequiresEdt
    public boolean isConsoleVisible() {
        if (this.project.isDisposed() || this.project.isDefault()) {
            return false;
        }
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, "Console");
        if (toolWindow == null) {
            return false;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null) {
            return false;
        }
        ContentManager contentManager2 = contentManager;
        return contentManager2.getContent(this.consoleView.getComponent()) != null;
    }

    @Override
    @RequiresEdt
    public boolean isConsoleEmpty() {
        if (this.project.isDisposed() || this.project.isDefault()) {
            return true;
        }
        return this.consoleView.getContentSize() == 0;
    }

    @Override
    @RequiresEdt
    public void showConsoleTab(boolean selectContent, @Nullable Runnable onShown) {
        block3: {
            if (this.project.isDisposed() || this.project.isDefault()) {
                return;
            }
            Content contentTab = ChangesViewContentManager.Companion.getInstance(this.project).findContent("Console");
            if (contentTab == null) {
                this.createConsoleContentTab();
            }
            if (!selectContent) break block3;
            ChangesViewContentManager.Companion.getInstance(this.project).selectContent("Console");
            ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, "Console");
            if (toolWindow != null) {
                toolWindow.show(onShown);
            }
        }
    }

    @Override
    @RequiresEdt
    public void showConsoleTabAndScrollToTheEnd() {
        this.showConsoleTab(true, () -> VcsConsoleTabServiceImpl.showConsoleTabAndScrollToTheEnd$lambda$0(this));
    }

    private final Content createConsoleContentTab() {
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
        panel2.setContent(this.consoleView.getComponent());
        AnAction[] anActionArray = this.consoleView.createConsoleActions();
        DefaultActionGroup actionGroup = new DefaultActionGroup(Arrays.copyOf(anActionArray, anActionArray.length));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("VcsManager", (ActionGroup)actionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setTargetComponent(this.consoleView.getComponent());
        panel2.setToolbar(toolbar2.getComponent());
        ContentImpl contentTab = new ContentImpl((JComponent)panel2, VcsBundle.message("vcs.console.toolwindow.display.name", new Object[0]), true);
        contentTab.setCloseable(false);
        contentTab.setPreferredFocusedComponent(() -> VcsConsoleTabServiceImpl.createConsoleContentTab$lambda$1(this));
        contentTab.setTabName("Console");
        contentTab.putUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY, (Object)ChangesViewContentManager.TabOrderWeight.CONSOLE.getWeight());
        ChangesViewContentManager.Companion.getInstance(this.project).addContent((Content)contentTab);
        return (Content)contentTab;
    }

    private static final void showConsoleTabAndScrollToTheEnd$lambda$0(VcsConsoleTabServiceImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.consoleView.requestScrollingToEnd();
    }

    private static final JComponent createConsoleContentTab$lambda$1(VcsConsoleTabServiceImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.consoleView.getPreferredFocusableComponent();
    }

    @JvmStatic
    @NotNull
    public static final VcsConsoleTabService getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/console/VcsConsoleTabServiceImpl$Companion;", "", "()V", "getInstance", "Lcom/intellij/vcs/console/VcsConsoleTabService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsConsoleTabService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsConsoleTabService.kt\ncom/intellij/vcs/console/VcsConsoleTabServiceImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,168:1\n31#2,2:169\n*S KotlinDebug\n*F\n+ 1 VcsConsoleTabService.kt\ncom/intellij/vcs/console/VcsConsoleTabServiceImpl$Companion\n*L\n80#1:169,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VcsConsoleTabService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<VcsConsoleTabService> serviceClass$iv = VcsConsoleTabService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (VcsConsoleTabService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

