/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.GraphModificationUtilKt;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.history.FileHistoryData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001aN\u0010\u0003\u001a\u00020\u00042\u001e\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00070\u00062$\u0010\t\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u00040\nH\u0000\u001a(\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u001a*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u0016H\u0000\u001a>\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0014\u0012\u0004\u0012\u00020\u00040\u0016\u001a9\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010!*\b\u0012\u0004\u0012\u0002H\"0#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H!0\u0016H\u0002\u00a2\u0006\u0002\u0010%\u001a\u001e\u0010&\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00072\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(H\u0000\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"FILE_PATH_HASHING_STRATEGY", "Lcom/intellij/util/containers/HashingStrategy;", "Lcom/intellij/openapi/vcs/FilePath;", "forEach", "", "map", "", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind;", "action", "Lkotlin/Function3;", "", "hideTrivialMerge", "collapsedGraph", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "node", "singleParent", "hideTrivialMerges", "", "isCandidateNodeId", "Lkotlin/Function1;", "", "removeTrivialMerges", "controller", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "fileHistoryData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "report", "firstNotNull", "R", "E", "", "mapping", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "removeAll", "keys", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,501:1\n1855#2,2:502\n1855#2,2:504\n*S KotlinDebug\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryKt\n*L\n478#1:502,2\n487#1:504,2\n*E\n"})
public final class FileHistoryKt {
    @JvmField
    @NotNull
    public static final HashingStrategy<FilePath> FILE_PATH_HASHING_STRATEGY;

    public static final boolean removeTrivialMerges(@NotNull LinearGraphController controller, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo, @NotNull FileHistoryData fileHistoryData, @NotNull Function1<? super Set<Integer>, Unit> report) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        Intrinsics.checkNotNullParameter((Object)fileHistoryData, (String)"fileHistoryData");
        Intrinsics.checkNotNullParameter(report, (String)"report");
        IntOpenHashSet trivialCandidates = new IntOpenHashSet();
        IntOpenHashSet nonTrivialMerges = new IntOpenHashSet();
        fileHistoryData.forEach((Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<VcsLogPathsIndex.ChangeKind>, Unit>)((Function3)new Function3<FilePath, Integer, Int2ObjectMap<VcsLogPathsIndex.ChangeKind>, Unit>(trivialCandidates, nonTrivialMerges){
            final /* synthetic */ IntOpenHashSet $trivialCandidates;
            final /* synthetic */ IntOpenHashSet $nonTrivialMerges;
            {
                this.$trivialCandidates = $trivialCandidates;
                this.$nonTrivialMerges = $nonTrivialMerges;
                super(3);
            }

            public final void invoke(@NotNull FilePath filePath, int commit2, @NotNull Int2ObjectMap<VcsLogPathsIndex.ChangeKind> changes2) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(changes2, (String)"changes");
                if (changes2.size() > 1) {
                    if (changes2.containsValue((Object)((Object)VcsLogPathsIndex.ChangeKind.NOT_CHANGED))) {
                        this.$trivialCandidates.add(commit2);
                    } else {
                        this.$nonTrivialMerges.add(commit2);
                    }
                }
            }
        }));
        boolean needToRepeat2 = trivialCandidates.removeAll((IntCollection)nonTrivialMerges);
        if (!trivialCandidates.isEmpty()) {
            GraphModificationUtilKt.modifyGraph(controller, (Function1<? super CollapsedGraph, Unit>)((Function1)new Function1<CollapsedGraph, Unit>(report, fileHistoryData, trivialCandidates, permanentGraphInfo){
                final /* synthetic */ Function1<Set<Integer>, Unit> $report;
                final /* synthetic */ FileHistoryData $fileHistoryData;
                final /* synthetic */ IntOpenHashSet $trivialCandidates;
                final /* synthetic */ PermanentGraphInfo<Integer> $permanentGraphInfo;
                {
                    this.$report = $report;
                    this.$fileHistoryData = $fileHistoryData;
                    this.$trivialCandidates = $trivialCandidates;
                    this.$permanentGraphInfo = $permanentGraphInfo;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull CollapsedGraph collapsedGraph) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)collapsedGraph, (String)"collapsedGraph");
                    Set<Integer> trivialMerges2 = FileHistoryKt.hideTrivialMerges(collapsedGraph, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(this.$trivialCandidates, this.$permanentGraphInfo){
                        final /* synthetic */ IntOpenHashSet $trivialCandidates;
                        final /* synthetic */ PermanentGraphInfo<Integer> $permanentGraphInfo;
                        {
                            this.$trivialCandidates = $trivialCandidates;
                            this.$permanentGraphInfo = $permanentGraphInfo;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(int nodeId) {
                            Integer n = this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
                            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getCommitId(...)");
                            return this.$trivialCandidates.contains(((Number)n).intValue());
                        }
                    }));
                    if (!((Collection)trivialMerges2).isEmpty()) {
                        this.$report.invoke(trivialMerges2);
                    }
                    Iterable iterable = trivialMerges2;
                    PermanentGraphInfo<Integer> permanentGraphInfo = this.$permanentGraphInfo;
                    FileHistoryData fileHistoryData = this.$fileHistoryData;
                    boolean $i$f$map = false;
                    void var6_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        int n = ((Number)item$iv$iv).intValue();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Integer n2 = permanentGraphInfo.getPermanentCommitsInfo().getCommitId((int)it);
                        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getCommitId(...)");
                        collection.add(((Number)n2).intValue());
                    }
                    fileHistoryData.removeAll((List)destination$iv$iv);
                }
            }));
        }
        return needToRepeat2;
    }

    @NotNull
    public static final Set<Integer> hideTrivialMerges(@NotNull CollapsedGraph collapsedGraph, @NotNull Function1<? super Integer, Boolean> isCandidateNodeId) {
        Intrinsics.checkNotNullParameter((Object)collapsedGraph, (String)"collapsedGraph");
        Intrinsics.checkNotNullParameter(isCandidateNodeId, (String)"isCandidateNodeId");
        Set result2 = new LinkedHashSet();
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(collapsedGraph.getCompiledGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        LiteLinearGraph graph = liteLinearGraph;
        block0: for (int v = graph.nodesCount() - 1; -1 < v; --v) {
            List<Integer> downNodes;
            int nodeId = collapsedGraph.getCompiledGraph().getNodeId(v);
            if (!((Boolean)isCandidateNodeId.invoke((Object)nodeId)).booleanValue()) continue;
            Intrinsics.checkNotNullExpressionValue(graph.getNodes(v, LiteLinearGraph.NodeFilter.DOWN), (String)"getNodes(...)");
            if (downNodes.size() == 1) {
                result2.add(nodeId);
                Object object = CollectionsKt.single(downNodes);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
                FileHistoryKt.hideTrivialMerge(collapsedGraph, graph, v, ((Number)object).intValue());
                continue;
            }
            if (downNodes.size() < 2) continue;
            Iterator sortedParentsIt = CollectionsKt.sortedDescending((Iterable)downNodes).iterator();
            Integer currentParent = (Integer)sortedParentsIt.next();
            while (sortedParentsIt.hasNext()) {
                Integer nextParent = (Integer)sortedParentsIt.next();
                Integer n = currentParent;
                Intrinsics.checkNotNull((Object)n);
                int n2 = ((Number)n).intValue();
                Intrinsics.checkNotNull((Object)nextParent);
                if (!GraphUtilKt.isAncestor(graph, n2, nextParent)) continue block0;
                currentParent = nextParent;
            }
            result2.add(nodeId);
            Integer n = currentParent;
            Intrinsics.checkNotNull((Object)n);
            FileHistoryKt.hideTrivialMerge(collapsedGraph, graph, v, ((Number)n).intValue());
        }
        return result2;
    }

    private static final void hideTrivialMerge(CollapsedGraph collapsedGraph, LiteLinearGraph graph, int node, int singleParent) {
        GraphModificationUtilKt.modify(collapsedGraph, (Function1<? super CollapsedGraph.Modification, Unit>)((Function1)new Function1<CollapsedGraph.Modification, Unit>(node, graph, singleParent){
            final /* synthetic */ int $node;
            final /* synthetic */ LiteLinearGraph $graph;
            final /* synthetic */ int $singleParent;
            {
                this.$node = $node;
                this.$graph = $graph;
                this.$singleParent = $singleParent;
                super(1);
            }

            public final void invoke(@NotNull CollapsedGraph.Modification $this$modify) {
                Intrinsics.checkNotNullParameter((Object)$this$modify, (String)"$this$modify");
                GraphModificationUtilKt.hideRow($this$modify, this.$node);
                for (Integer upNode : this.$graph.getNodes(this.$node, LiteLinearGraph.NodeFilter.UP)) {
                    Intrinsics.checkNotNull((Object)upNode);
                    GraphModificationUtilKt.connectRows($this$modify, upNode, this.$singleParent);
                }
            }
        }));
    }

    public static final void forEach(@NotNull Map<FilePath, ? extends Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>>> map2, @NotNull Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<VcsLogPathsIndex.ChangeKind>, Unit> action2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        for (Map.Entry<FilePath, ? extends Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>>> entry2 : map2.entrySet()) {
            FilePath filePath = entry2.getKey();
            Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> affectedCommits = entry2.getValue();
            ObjectSet objectSet = affectedCommits.int2ObjectEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"int2ObjectEntrySet(...)");
            Iterable $this$forEach$iv = (Iterable)objectSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Int2ObjectMap.Entry entry3 = (Int2ObjectMap.Entry)element$iv;
                boolean bl = false;
                int commit2 = entry3.getIntKey();
                Int2ObjectMap changesMap = (Int2ObjectMap)entry3.getValue();
                Integer n = commit2;
                Intrinsics.checkNotNull((Object)changesMap);
                action2.invoke((Object)filePath, (Object)n, (Object)changesMap);
            }
        }
    }

    public static final void removeAll(@NotNull Int2ObjectMap<?> $this$removeAll, @NotNull List<Integer> keys) {
        Intrinsics.checkNotNullParameter($this$removeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int p0 = ((Number)element$iv).intValue();
            boolean bl = false;
            $this$removeAll.remove(p0);
        }
    }

    private static final <E, R> R firstNotNull(Collection<? extends E> $this$firstNotNull, Function1<? super E, ? extends R> mapping) {
        for (E e : $this$firstNotNull) {
            Object value2 = mapping.invoke(e);
            if (value2 == null) continue;
            return (R)value2;
        }
        return null;
    }

    public static final /* synthetic */ Object access$firstNotNull(Collection $receiver, Function1 mapping) {
        return FileHistoryKt.firstNotNull($receiver, mapping);
    }

    static {
        HashingStrategy<FilePath> hashingStrategy = ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY;
        Intrinsics.checkNotNullExpressionValue(hashingStrategy, (String)"CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY");
        FILE_PATH_HASHING_STRATEGY = hashingStrategy;
    }
}

