/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpanAttribute;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.CommitMetadataWithPath;
import com.intellij.vcs.log.history.FileHistoryFiltererKt;
import com.intellij.vcs.log.statistics.VcsLogRepoSizeCollector;
import com.intellij.vcs.log.util.RevisionCollectorTask;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020%0'H\u0016J\u000e\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006+"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryTask;", "Lcom/intellij/vcs/log/util/RevisionCollectorTask;", "Lcom/intellij/vcs/log/history/CommitMetadataWithPath;", "project", "Lcom/intellij/openapi/project/Project;", "handler", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "factory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;Lcom/intellij/vcs/log/data/VcsLogStorage;Lcom/intellij/vcs/log/VcsLogObjectsFactory;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/VcsLogFilterCollection;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getFactory", "()Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getFilters", "()Lcom/intellij/vcs/log/VcsLogFilterCollection;", "getHandler", "()Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "collectRevisions", "", "consumer", "Lkotlin/Function1;", "createCommitMetadataWithPath", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryTask\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,402:1\n30#2:403\n129#2,2:404\n31#2,2:406\n146#2:408\n132#2,12:409\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryTask\n*L\n374#1:403\n374#1:404,2\n374#1:406,2\n374#1:408\n374#1:409,12\n*E\n"})
final class FileHistoryTask
extends RevisionCollectorTask<CommitMetadataWithPath> {
    @NotNull
    private final VcsLogFileHistoryHandler handler;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final VcsLogObjectsFactory factory;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final FilePath filePath;
    @Nullable
    private final Hash hash;
    @NotNull
    private final VcsLogFilterCollection filters;

    public FileHistoryTask(@NotNull Project project2, @NotNull VcsLogFileHistoryHandler handler2, @NotNull VcsLogStorage storage, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable Hash hash2, @NotNull VcsLogFilterCollection filters, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        super(project2, indicator);
        this.handler = handler2;
        this.storage = storage;
        this.factory = factory;
        this.root = root;
        this.filePath = filePath;
        this.hash = hash2;
        this.filters = filters;
    }

    @NotNull
    public final VcsLogFileHistoryHandler getHandler() {
        return this.handler;
    }

    @NotNull
    public final VcsLogStorage getStorage() {
        return this.storage;
    }

    @NotNull
    public final VcsLogObjectsFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @Nullable
    public final Hash getHash() {
        return this.hash;
    }

    @NotNull
    public final VcsLogFilterCollection getFilters() {
        return this.filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectRevisions(@NotNull Function1<? super CommitMetadataWithPath, Unit> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogHistory.CollectingRevisionsFromHandler.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan()");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Span span2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span3 = span$iv;
                boolean bl3 = false;
                span3.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getVCS_NAME().getKey(), VcsLogRepoSizeCollector.getVcsKeySafe(this.handler.getSupportedVcs()));
                span3.setAttribute("handlerClass", this.handler.getClass().getName());
                this.handler.collectHistory(this.root, this.filePath, this.hash, this.filters, (Function1<? super VcsFileRevision, Unit>)((Function1)new Function1<VcsFileRevision, Unit>(consumer, this){
                    final /* synthetic */ Function1<CommitMetadataWithPath, Unit> $consumer;
                    final /* synthetic */ FileHistoryTask this$0;
                    {
                        this.$consumer = $consumer;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull VcsFileRevision revision) {
                        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
                        this.$consumer.invoke((Object)this.this$0.createCommitMetadataWithPath(revision));
                    }
                }));
                span2 = span3.setAttribute("commitCount", String.valueOf(this.getRevisionsCount()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Span span4 = span2;
        }
        catch (CancellationException e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv;
        }
        catch (ProcessCanceledException e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException(e$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    @NotNull
    public final CommitMetadataWithPath createCommitMetadataWithPath(@NotNull VcsFileRevision revision) {
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        return FileHistoryFiltererKt.access$createCommitMetadataWithPath(this.factory, this.storage, (VcsFileRevisionEx)revision, this.root);
    }
}

