/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogApplicationSettingsKt;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.table.column.Author;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.ui.table.column.Date;
import com.intellij.vcs.log.ui.table.column.Root;
import com.intellij.vcs.log.ui.table.column.TableColumnVisibilityProperty;
import com.intellij.vcs.log.ui.table.column.TableColumnWidthProperty;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.History.Properties", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J#\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u001c\u0010\u001c\u001a\u00020\u001d\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u000bH\u0016J\"\u0010 \u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#H\u0002J!\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180#0#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0003H\u0016J\u001c\u0010)\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u000bH\u0002J\b\u0010*\u001a\u00020\u0012H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J*\u0010,\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u000b2\u0006\u0010-\u001a\u0002H\u001eH\u0096\u0002\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r0\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryUiProperties;", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/vcs/log/history/FileHistoryUiProperties$State;", "()V", "_state", "appSettings", "Lcom/intellij/vcs/log/impl/VcsLogApplicationSettings;", "kotlin.jvm.PlatformType", "applicationLevelProperties", "", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "applicationSettingsListener", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$PropertiesChangeListener;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/annotations/NotNull;", "addChangeListener", "", "listener", "parent", "Lcom/intellij/openapi/Disposable;", "addRecentlyFilteredGroup", "filterName", "", "values", "", "addRecentlyFilteredGroup$intellij_platform_vcs_log_impl", "exists", "", "T", "property", "get", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;)Ljava/lang/Object;", "getColumnOrder", "", "getRecentlyFilteredGroups", "getRecentlyFilteredGroups$intellij_platform_vcs_log_impl", "getState", "loadState", "state", "onApplicationSettingChange", "removeAppSettingsListenerIfNeeded", "removeChangeListener", "set", "value", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;Ljava/lang/Object;)V", "State", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryUiProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryUiProperties.kt\ncom/intellij/vcs/log/history/FileHistoryUiProperties\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1549#2:165\n1620#2,3:166\n*S KotlinDebug\n*F\n+ 1 FileHistoryUiProperties.kt\ncom/intellij/vcs/log/history/FileHistoryUiProperties\n*L\n53#1:165\n53#1:166,3\n*E\n"})
public final class FileHistoryUiProperties
implements VcsLogUiProperties,
PersistentStateComponent<State> {
    @NotNull
    private final EventDispatcher<VcsLogUiProperties.PropertiesChangeListener> eventDispatcher;
    private final VcsLogApplicationSettings appSettings;
    @NotNull
    private final VcsLogUiProperties.PropertiesChangeListener applicationSettingsListener;
    @NotNull
    private final Set<VcsLogUiProperties.VcsLogUiProperty<?>> applicationLevelProperties;
    @NotNull
    private State _state;

    public FileHistoryUiProperties() {
        EventDispatcher eventDispatcher = EventDispatcher.create(VcsLogUiProperties.PropertiesChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.appSettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);
        this.applicationSettingsListener = new VcsLogUiProperties.PropertiesChangeListener(this){
            final /* synthetic */ FileHistoryUiProperties this$0;
            {
                this.this$0 = $receiver;
            }

            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
                Intrinsics.checkNotNullParameter(property2, (String)"property");
                FileHistoryUiProperties.access$onApplicationSettingChange(this.this$0, property2);
            }
        };
        Object[] objectArray = new VcsLogUiProperties.VcsLogUiProperty[4];
        Intrinsics.checkNotNullExpressionValue(CommonUiProperties.PREFER_COMMIT_DATE, (String)"PREFER_COMMIT_DATE");
        Intrinsics.checkNotNullExpressionValue(CommonUiProperties.COMPACT_REFERENCES_VIEW, (String)"COMPACT_REFERENCES_VIEW");
        Intrinsics.checkNotNullExpressionValue(CommonUiProperties.SHOW_TAG_NAMES, (String)"SHOW_TAG_NAMES");
        Intrinsics.checkNotNullExpressionValue(CommonUiProperties.LABELS_LEFT_ALIGNED, (String)"LABELS_LEFT_ALIGNED");
        this.applicationLevelProperties = SetsKt.setOf((Object[])objectArray);
        this._state = new State();
    }

    @Override
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
        Object object;
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        if (this.applicationLevelProperties.contains(property2)) {
            return this.appSettings.get(property2);
        }
        VcsLogUiProperties.VcsLogUiProperty<T> vcsLogUiProperty = property2;
        if (vcsLogUiProperty instanceof TableColumnWidthProperty) {
            Integer n = this._state.getColumnIdWidth().get(property2.getName());
            object = n != null ? n : -1;
        } else if (vcsLogUiProperty instanceof TableColumnVisibilityProperty) {
            object = VcsLogApplicationSettingsKt.isColumnVisible(this, this._state.getColumnIdVisibility(), (TableColumnVisibilityProperty)property2);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.COLUMN_ID_ORDER)) {
            object = this.getColumnOrder();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_DETAILS)) {
            object = this._state.isShowDetails();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_DIFF_PREVIEW)) {
            object = this._state.isShowDiffPreview();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT)) {
            object = this._state.isDiffPreviewVerticalSplit();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_ROOT_NAMES)) {
            object = this._state.isShowRootNames();
        } else {
            throw new UnsupportedOperationException("Unknown property " + property2);
        }
        List<String> result2 = object;
        return (T)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getColumnOrder() {
        List<String> order = this._state.getColumnIdOrder();
        Object[] objectArray = (Object[])order;
        if (objectArray == null || objectArray.isEmpty()) {
            void $this$mapTo$iv$iv;
            objectArray = new VcsLogDefaultColumn[]{Root.INSTANCE, Author.INSTANCE, Date.INSTANCE, Commit.INSTANCE};
            Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsLogDefaultColumn vcsLogDefaultColumn = (VcsLogDefaultColumn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            return (List)destination$iv$iv;
        }
        return order;
    }

    private final <T> void onApplicationSettingChange(VcsLogUiProperties.VcsLogUiProperty<T> property2) {
        if (this.applicationLevelProperties.contains(property2)) {
            ((VcsLogUiProperties.PropertiesChangeListener)this.eventDispatcher.getMulticaster()).onPropertyChanged(property2);
        }
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2, T value2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        if (this.applicationLevelProperties.contains(property2)) {
            this.appSettings.set(property2, value2);
            return;
        }
        VcsLogUiProperties.VcsLogUiProperty<T> vcsLogUiProperty = property2;
        if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_DETAILS)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this._state.setShowDetails((Boolean)value2);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.COLUMN_ID_ORDER)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            this._state.setColumnIdOrder((List)value2);
        } else if (vcsLogUiProperty instanceof TableColumnWidthProperty) {
            Map<String, Integer> map2 = this._state.getColumnIdWidth();
            String string2 = property2.getName();
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Int");
            map2.put(string2, (Integer)value2);
        } else if (vcsLogUiProperty instanceof TableColumnVisibilityProperty) {
            Map<String, Boolean> map3 = this._state.getColumnIdVisibility();
            String string3 = property2.getName();
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            map3.put(string3, (Boolean)value2);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_DIFF_PREVIEW)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this._state.setShowDiffPreview((Boolean)value2);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this._state.setDiffPreviewVerticalSplit((Boolean)value2);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_ROOT_NAMES)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this._state.setShowRootNames((Boolean)value2);
        } else {
            throw new UnsupportedOperationException("Unknown property " + property2);
        }
        ((VcsLogUiProperties.PropertiesChangeListener)this.eventDispatcher.getMulticaster()).onPropertyChanged(property2);
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        return Intrinsics.areEqual(CommonUiProperties.SHOW_DETAILS, property2) || Intrinsics.areEqual(CommonUiProperties.COLUMN_ID_ORDER, property2) || Intrinsics.areEqual(CommonUiProperties.SHOW_DIFF_PREVIEW, property2) || Intrinsics.areEqual(MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT, property2) || Intrinsics.areEqual(CommonUiProperties.SHOW_ROOT_NAMES, property2) || this.applicationLevelProperties.contains(property2) || property2 instanceof TableColumnWidthProperty || property2 instanceof TableColumnVisibilityProperty;
    }

    public final void addRecentlyFilteredGroup$intellij_platform_vcs_log_impl(@NotNull String filterName, @NotNull Collection<String> values2) {
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        VcsLogProjectTabsProperties.Companion.addRecentGroup(this._state.getRecentFilters(), filterName, values2);
    }

    @NotNull
    public final List<List<String>> getRecentlyFilteredGroups$intellij_platform_vcs_log_impl(@NotNull String filterName) {
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        return VcsLogProjectTabsProperties.Companion.getRecentGroup(this._state.getRecentFilters(), filterName);
    }

    @NotNull
    public State getState() {
        return this._state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._state = state;
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (!this.eventDispatcher.hasListeners()) {
            this.appSettings.addChangeListener(this.applicationSettingsListener);
        }
        this.eventDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!this.eventDispatcher.hasListeners()) {
            this.appSettings.addChangeListener(this.applicationSettingsListener);
            Disposer.register((Disposable)parent, () -> FileHistoryUiProperties.addChangeListener$lambda$1(this));
        }
        this.eventDispatcher.addListener((EventListener)listener2, parent);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.removeListener((EventListener)listener2);
        this.removeAppSettingsListenerIfNeeded();
    }

    private final void removeAppSettingsListenerIfNeeded() {
        if (!this.eventDispatcher.hasListeners()) {
            this.appSettings.removeChangeListener(this.applicationSettingsListener);
        }
    }

    private static final void addChangeListener$lambda$1(FileHistoryUiProperties this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeAppSettingsListenerIfNeeded();
    }

    public static final /* synthetic */ void access$onApplicationSettingChange(FileHistoryUiProperties $this, VcsLogUiProperties.VcsLogUiProperty property2) {
        $this.onApplicationSettingChange(property2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u000b8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0015\u001a\u00020\f8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u00020\f8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001c\u0010\u001b\u001a\u00020\f8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\u001c\u0010\u001d\u001a\u00020\f8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001c\u0010\u001f\u001a\u00020\f8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018R.\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\u000b8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000e\"\u0004\b%\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryUiProperties$State;", "", "()V", "columnIdOrder", "", "", "getColumnIdOrder", "()Ljava/util/List;", "setColumnIdOrder", "(Ljava/util/List;)V", "columnIdVisibility", "", "", "getColumnIdVisibility", "()Ljava/util/Map;", "setColumnIdVisibility", "(Ljava/util/Map;)V", "columnIdWidth", "", "getColumnIdWidth", "setColumnIdWidth", "isDiffPreviewVerticalSplit", "()Z", "setDiffPreviewVerticalSplit", "(Z)V", "isShowDetails", "setShowDetails", "isShowDiffPreview", "setShowDiffPreview", "isShowOtherBranches", "setShowOtherBranches", "isShowRootNames", "setShowRootNames", "recentFilters", "", "Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties$RecentGroup;", "getRecentFilters", "setRecentFilters", "intellij.platform.vcs.log.impl"})
    public static final class State {
        private boolean isShowDetails;
        private boolean isShowOtherBranches;
        @NotNull
        private Map<String, Integer> columnIdWidth = new HashMap();
        @Nullable
        private List<String> columnIdOrder = new ArrayList();
        @NotNull
        private Map<String, Boolean> columnIdVisibility = new HashMap();
        private boolean isShowDiffPreview = true;
        private boolean isDiffPreviewVerticalSplit;
        private boolean isShowRootNames;
        @NotNull
        private Map<String, List<VcsLogProjectTabsProperties.RecentGroup>> recentFilters = new HashMap();

        @OptionTag(value="SHOW_DETAILS")
        public final boolean isShowDetails() {
            return this.isShowDetails;
        }

        public final void setShowDetails(boolean bl) {
            this.isShowDetails = bl;
        }

        @OptionTag(value="SHOW_OTHER_BRANCHES")
        public final boolean isShowOtherBranches() {
            return this.isShowOtherBranches;
        }

        public final void setShowOtherBranches(boolean bl) {
            this.isShowOtherBranches = bl;
        }

        @OptionTag(value="COLUMN_ID_WIDTH")
        @NotNull
        public final Map<String, Integer> getColumnIdWidth() {
            return this.columnIdWidth;
        }

        public final void setColumnIdWidth(@NotNull Map<String, Integer> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.columnIdWidth = map2;
        }

        @OptionTag(value="COLUMN_ID_ORDER")
        @Nullable
        public final List<String> getColumnIdOrder() {
            return this.columnIdOrder;
        }

        public final void setColumnIdOrder(@Nullable List<String> list2) {
            this.columnIdOrder = list2;
        }

        @OptionTag(value="COLUMN_ID_VISIBILITY")
        @NotNull
        public final Map<String, Boolean> getColumnIdVisibility() {
            return this.columnIdVisibility;
        }

        public final void setColumnIdVisibility(@NotNull Map<String, Boolean> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.columnIdVisibility = map2;
        }

        @OptionTag(value="SHOW_DIFF_PREVIEW")
        public final boolean isShowDiffPreview() {
            return this.isShowDiffPreview;
        }

        public final void setShowDiffPreview(boolean bl) {
            this.isShowDiffPreview = bl;
        }

        @OptionTag(value="DIFF_PREVIEW_VERTICAL_SPLIT")
        public final boolean isDiffPreviewVerticalSplit() {
            return this.isDiffPreviewVerticalSplit;
        }

        public final void setDiffPreviewVerticalSplit(boolean bl) {
            this.isDiffPreviewVerticalSplit = bl;
        }

        @OptionTag(value="SHOW_ROOT_NAMES")
        public final boolean isShowRootNames() {
            return this.isShowRootNames;
        }

        public final void setShowRootNames(boolean bl) {
            this.isShowRootNames = bl;
        }

        @OptionTag(value="RECENT_FILTERS")
        @NotNull
        public final Map<String, List<VcsLogProjectTabsProperties.RecentGroup>> getRecentFilters() {
            return this.recentFilters;
        }

        public final void setRecentFilters(@NotNull Map<String, List<VcsLogProjectTabsProperties.RecentGroup>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.recentFilters = map2;
        }
    }
}

