/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThrowableConsumer;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntCollectionUtil {
    @Nullable
    public static IntSet intersect(IntSet ... sets) {
        if (sets == null) {
            IntCollectionUtil.$$$reportNull$$$0(0);
        }
        Arrays.sort(sets, (set1, set2) -> {
            if (set1 == null) {
                return -1;
            }
            if (set2 == null) {
                return 1;
            }
            return set1.size() - set2.size();
        });
        IntSet result2 = null;
        for (IntSet set : sets) {
            result2 = IntCollectionUtil.intersect(result2, set);
        }
        return result2;
    }

    public static boolean intersects(@NotNull IntSet set1, @NotNull IntSet set2) {
        if (set1 == null) {
            IntCollectionUtil.$$$reportNull$$$0(1);
        }
        if (set2 == null) {
            IntCollectionUtil.$$$reportNull$$$0(2);
        }
        if (set1.size() <= set2.size()) {
            IntIterator it = set1.intIterator();
            while (it.hasNext()) {
                int value2 = it.nextInt();
                if (!set2.contains(value2)) continue;
                return true;
            }
            return false;
        }
        return IntCollectionUtil.intersects(set2, set1);
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    @Nullable
    public static IntSet intersect(@Nullable IntSet set1, @Nullable IntSet set2) {
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        if (set1.size() < set2.size()) {
            IntCollectionUtil.intersectTo(set1, set2, (IntSet)result2);
        } else {
            IntCollectionUtil.intersectTo(set2, set1, (IntSet)result2);
        }
        return result2;
    }

    private static void intersectTo(@NotNull IntSet small, @NotNull IntSet big, @NotNull IntSet result2) {
        if (small == null) {
            IntCollectionUtil.$$$reportNull$$$0(3);
        }
        if (big == null) {
            IntCollectionUtil.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            IntCollectionUtil.$$$reportNull$$$0(5);
        }
        IntIterator iterator = small.iterator();
        while (iterator.hasNext()) {
            int value2 = iterator.nextInt();
            if (!big.contains(value2)) continue;
            result2.add(value2);
        }
    }

    @NotNull
    public static IntSet union(@NotNull Collection<? extends IntSet> sets) {
        if (sets == null) {
            IntCollectionUtil.$$$reportNull$$$0(6);
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        for (IntSet intSet : sets) {
            result2.addAll((IntCollection)intSet);
        }
        IntOpenHashSet intOpenHashSet = result2;
        if (intOpenHashSet == null) {
            IntCollectionUtil.$$$reportNull$$$0(7);
        }
        return intOpenHashSet;
    }

    @NotNull
    public static <T> List<T> map2List(@NotNull IntSet set, @NotNull IntFunction<? extends T> function) {
        if (set == null) {
            IntCollectionUtil.$$$reportNull$$$0(8);
        }
        if (function == null) {
            IntCollectionUtil.$$$reportNull$$$0(9);
        }
        List list2 = set.intStream().mapToObj(function).collect(Collectors.toList());
        if (list2 == null) {
            IntCollectionUtil.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public static <T> IntSet map2IntSet(@NotNull Collection<? extends T> collection, @NotNull ToIntFunction<? super T> function) {
        if (collection == null) {
            IntCollectionUtil.$$$reportNull$$$0(11);
        }
        if (function == null) {
            IntCollectionUtil.$$$reportNull$$$0(12);
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        for (T t : collection) {
            result2.add(function.applyAsInt(t));
        }
        IntOpenHashSet intOpenHashSet = result2;
        if (intOpenHashSet == null) {
            IntCollectionUtil.$$$reportNull$$$0(13);
        }
        return intOpenHashSet;
    }

    @NotNull
    public static <T> Map<T, IntSet> groupByAsIntSet(@NotNull IntCollection collection, @NotNull IntFunction<? extends T> function) {
        if (collection == null) {
            IntCollectionUtil.$$$reportNull$$$0(14);
        }
        if (function == null) {
            IntCollectionUtil.$$$reportNull$$$0(15);
        }
        HashMap result2 = new HashMap();
        collection.forEach(it -> {
            Object key2 = function.apply(it);
            IntSet values2 = result2.computeIfAbsent(key2, __ -> new IntOpenHashSet());
            values2.add(it);
        });
        HashMap hashMap = result2;
        if (hashMap == null) {
            IntCollectionUtil.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    public static void processBatches(@NotNull IntStream stream, int batchSize, @NotNull ThrowableConsumer<? super IntSet, ? extends VcsException> consumer) throws VcsException {
        if (stream == null) {
            IntCollectionUtil.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            IntCollectionUtil.$$$reportNull$$$0(18);
        }
        Ref batch = new Ref((Object)new IntOpenHashSet());
        Ref exception = new Ref();
        stream.forEach(commit2 -> {
            ((IntSet)batch.get()).add(commit2);
            if (((IntSet)batch.get()).size() >= batchSize) {
                try {
                    consumer.consume(batch.get());
                }
                catch (VcsException e) {
                    exception.set((Object)e);
                }
                finally {
                    batch.set((Object)new IntOpenHashSet());
                }
            }
        });
        if (!((IntSet)batch.get()).isEmpty()) {
            consumer.consume(batch.get());
        }
        if (!exception.isNull()) {
            throw (VcsException)exception.get();
        }
    }

    public static <T> void add(@NotNull Map<? super T, IntSet> targetMap, @NotNull T key2, int value2) {
        if (targetMap == null) {
            IntCollectionUtil.$$$reportNull$$$0(19);
        }
        if (key2 == null) {
            IntCollectionUtil.$$$reportNull$$$0(20);
        }
        IntSet set = targetMap.computeIfAbsent(key2, __ -> new IntOpenHashSet());
        set.add(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "small";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "big";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/IntCollectionUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/IntCollectionUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "map2IntSet";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByAsIntSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intersectTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "map2IntSet";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "groupByAsIntSet";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processBatches";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 10, 13, 16 -> new IllegalStateException(string2);
        };
    }
}

