/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import org.jetbrains.annotations.NonNls;

final class Base64VLQ {
    private static final int VLQ_BASE_SHIFT = 5;
    private static final int VLQ_BASE = 32;
    private static final int VLQ_BASE_MASK = 31;
    private static final int VLQ_CONTINUATION_BIT = 32;

    private Base64VLQ() {
    }

    public static int decode(CharIterator in) {
        int digit;
        int result2 = 0;
        int shift = 0;
        do {
            digit = Base64.BASE64_DECODE_MAP[in.next()];
            assert (digit != -1) : "invalid char";
            result2 += (digit & 0x1F) << shift;
            shift += 5;
        } while ((digit & 0x20) != 0);
        boolean negate = (result2 & 1) == 1;
        return negate ? -result2 : (result2 >>= 1);
    }

    private static final class Base64 {
        @NonNls
        private static final String BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        private static final int[] BASE64_DECODE_MAP = new int[256];

        private Base64() {
        }

        static {
            for (int i = 0; i < BASE64_MAP.length(); ++i) {
                Base64.BASE64_DECODE_MAP[BASE64_MAP.charAt((int)i)] = i;
            }
        }
    }

    static interface CharIterator {
        public boolean hasNext();

        public char next();
    }
}

