/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.jmxDriver;

import com.intellij.driver.impl.Invoker;
import com.intellij.driver.impl.InvokerMBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.util.PlatformUtils;
import com.jetbrains.performancePlugin.jmxDriver.RemoteDevInvoker;
import io.opentelemetry.context.Context;
import java.lang.management.ManagementFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ:\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r2\u0010\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/jmxDriver/InvokerService;", "", "()V", "<set-?>", "Lcom/intellij/driver/impl/InvokerMBean;", "invoker", "getInvoker", "()Lcom/intellij/driver/impl/InvokerMBean;", "isReady", "", "register", "", "tracerSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "timedContextSupplier", "Lio/opentelemetry/context/Context;", "screenshotAction", "Ljava/util/function/Consumer;", "", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nInvokerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvokerService.kt\ncom/jetbrains/performancePlugin/jmxDriver/InvokerService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class InvokerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private InvokerMBean invoker;
    @NotNull
    private static final String BACKEND_JMX_PORT_PROPERTY = "rdct.tests.backendJmxPort";
    @NotNull
    private static final String JMX_BACKEND_IP = "127.0.0.1";
    private static final String jmxBackendPort = System.getProperty("rdct.tests.backendJmxPort");
    @NotNull
    private static final Logger log;

    @Nullable
    public final InvokerMBean getInvoker() {
        return this.invoker;
    }

    public final boolean isReady() {
        return this.invoker != null;
    }

    public final void register(@NotNull Supplier<? extends IJTracer> tracerSupplier, @NotNull Supplier<? extends Context> timedContextSupplier, @NotNull Consumer<String> screenshotAction) throws JMException {
        String remoteJmxAddress;
        Intrinsics.checkNotNullParameter(tracerSupplier, (String)"tracerSupplier");
        Intrinsics.checkNotNullParameter(timedContextSupplier, (String)"timedContextSupplier");
        Intrinsics.checkNotNullParameter(screenshotAction, (String)"screenshotAction");
        ObjectName objectName = new ObjectName("com.intellij.driver:type=Invoker");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Invoker localInvoker = new Invoker("v", tracerSupplier, timedContextSupplier, screenshotAction);
        String string = jmxBackendPort;
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = "127.0.0.1:" + it;
        } else {
            v1 = remoteJmxAddress = null;
        }
        if (PlatformUtils.isJetBrainsClient() && remoteJmxAddress != null) {
            log.info("Remote Dev Mode");
            this.invoker = new RemoteDevInvoker(localInvoker, remoteJmxAddress);
        } else {
            this.invoker = localInvoker;
        }
        server.registerMBean(this.invoker, objectName);
    }

    @JvmStatic
    @NotNull
    public static final InvokerService getInstance() {
        return Companion.getInstance();
    }

    static {
        Logger logger = Logger.getInstance(InvokerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/jmxDriver/InvokerService$Companion;", "", "()V", "BACKEND_JMX_PORT_PROPERTY", "", "JMX_BACKEND_IP", "jmxBackendPort", "kotlin.jvm.PlatformType", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/jetbrains/performancePlugin/jmxDriver/InvokerService;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InvokerService getInstance() {
            Object object = ApplicationManager.getApplication().getService(InvokerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (InvokerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

