/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.problems.secrets;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.problems.secrets.Secret;
import org.jetbrains.security.project.CodeSnippet;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/security/problems/secrets/SecretLink;", "Lorg/jetbrains/security/problems/secrets/Secret;", "token", "", "pathToFile", "Ljava/nio/file/Path;", "code", "Lorg/jetbrains/security/project/CodeSnippet;", "type", "(Ljava/lang/String;Ljava/nio/file/Path;Lorg/jetbrains/security/project/CodeSnippet;Ljava/lang/String;)V", "getCode", "()Lorg/jetbrains/security/project/CodeSnippet;", "getPathToFile", "()Ljava/nio/file/Path;", "getToken", "()Ljava/lang/String;", "getType", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "model"})
public final class SecretLink
implements Secret {
    @NotNull
    private final String token;
    @NotNull
    private final Path pathToFile;
    @NotNull
    private final CodeSnippet code;
    @NotNull
    private final String type;

    public SecretLink(@NotNull String token, @NotNull Path pathToFile, @NotNull CodeSnippet code, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)pathToFile, (String)"pathToFile");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.token = token;
        this.pathToFile = pathToFile;
        this.code = code;
        this.type = type;
    }

    @Override
    @NotNull
    public String getToken() {
        return this.token;
    }

    @Override
    @NotNull
    public Path getPathToFile() {
        return this.pathToFile;
    }

    @Override
    @NotNull
    public CodeSnippet getCode() {
        return this.code;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public final String component1() {
        return this.getToken();
    }

    @NotNull
    public final Path component2() {
        return this.getPathToFile();
    }

    @NotNull
    public final CodeSnippet component3() {
        return this.getCode();
    }

    @NotNull
    public final String component4() {
        return this.getType();
    }

    @NotNull
    public final SecretLink copy(@NotNull String token, @NotNull Path pathToFile, @NotNull CodeSnippet code, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)pathToFile, (String)"pathToFile");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new SecretLink(token, pathToFile, code, type);
    }

    public static /* synthetic */ SecretLink copy$default(SecretLink secretLink, String string, Path path, CodeSnippet codeSnippet, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = secretLink.getToken();
        }
        if ((n & 2) != 0) {
            path = secretLink.getPathToFile();
        }
        if ((n & 4) != 0) {
            codeSnippet = secretLink.getCode();
        }
        if ((n & 8) != 0) {
            string2 = secretLink.getType();
        }
        return secretLink.copy(string, path, codeSnippet, string2);
    }

    @NotNull
    public String toString() {
        return "SecretLink(token=" + this.getToken() + ", pathToFile=" + this.getPathToFile() + ", code=" + this.getCode() + ", type=" + this.getType() + ')';
    }

    public int hashCode() {
        int result = this.getToken().hashCode();
        result = result * 31 + ((Object)this.getPathToFile()).hashCode();
        result = result * 31 + this.getCode().hashCode();
        result = result * 31 + this.getType().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SecretLink)) {
            return false;
        }
        SecretLink secretLink = (SecretLink)other;
        if (!Intrinsics.areEqual((Object)this.getToken(), (Object)secretLink.getToken())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPathToFile(), (Object)secretLink.getPathToFile())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCode(), (Object)secretLink.getCode())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getType(), (Object)secretLink.getType());
    }
}

