/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.python;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptNumber;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.coverage.CoverageEngine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.python.pro.coverage.PyCoverageEngine;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBase;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\u0019H\u0016R \u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Lorg/jetbrains/qodana/python/PyCoverageInspection;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase;", "()V", "fileThreshold", "", "getFileThreshold$annotations", "getFileThreshold", "()I", "setFileThreshold", "(I)V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "file", "Lcom/jetbrains/python/psi/PyFile;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "report", "Lcom/intellij/rt/coverage/data/ProjectData;", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "pathsMap", "", "", "checker", "", "Lcom/intellij/psi/PsiFile;", "problemsHolder", "cleanup", "computeRealFunctionRange", "Lcom/intellij/openapi/util/TextRange;", "node", "Lcom/jetbrains/python/psi/PyFunction;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "loadCoverage", "loadNormalizedPaths", "validateFileType", "", "Companion", "intellij.qodana.python"})
@SourceDebugExtension(value={"SMAP\nPyCoverageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyCoverageInspection.kt\norg/jetbrains/qodana/python/PyCoverageInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,114:1\n1282#2,2:115\n1964#2,5:117\n*S KotlinDebug\n*F\n+ 1 PyCoverageInspection.kt\norg/jetbrains/qodana/python/PyCoverageInspection\n*L\n107#1:115,2\n109#1:117,5\n*E\n"})
public final class PyCoverageInspection
extends CoverageInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int fileThreshold = 50;
    @NotNull
    private static final Key<Lazy<ProjectData>> py;
    @NotNull
    private static final Key<Lazy<Map<String, String>>> normalizedPaths;

    public final int getFileThreshold() {
        return this.fileThreshold;
    }

    public final void setFileThreshold(int n) {
        this.fileThreshold = n;
    }

    public static /* synthetic */ void getFileThreshold$annotations() {
    }

    @Override
    public void loadCoverage(@NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        globalContext.putUserData(py, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<ProjectData>(this, globalContext){
            final /* synthetic */ PyCoverageInspection this$0;
            final /* synthetic */ QodanaGlobalInspectionContext $globalContext;
            {
                this.this$0 = $receiver;
                this.$globalContext = $globalContext;
                super(0);
            }

            @Nullable
            public final ProjectData invoke() {
                ProjectData projectData;
                ProjectData projectData2 = this.this$0.computeCoverageData(this.$globalContext, (KClass<? extends CoverageEngine>)Reflection.getOrCreateKotlinClass(PyCoverageEngine.class));
                if (projectData2 != null) {
                    ProjectData projectData3 = projectData2;
                    PyCoverageInspection pyCoverageInspection = this.this$0;
                    QodanaGlobalInspectionContext qodanaGlobalInspectionContext = this.$globalContext;
                    ProjectData it = projectData3;
                    boolean bl = false;
                    PyCoverageInspection.access$loadNormalizedPaths(pyCoverageInspection, qodanaGlobalInspectionContext, it);
                    projectData = projectData3;
                } else {
                    projectData = null;
                }
                return projectData;
            }
        })));
    }

    @Override
    public void checker(@NotNull PsiFile file, @NotNull ProblemsHolder problemsHolder, @NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Lazy lazy = (Lazy)globalContext.getUserData(py);
        if (lazy == null || (lazy = (ProjectData)lazy.getValue()) == null) {
            return;
        }
        Lazy report2 = lazy;
        Object object = (Lazy)globalContext.getUserData(normalizedPaths);
        if (object == null || (object = (Map)object.getValue()) == null) {
            return;
        }
        Object pathsMap = object;
        UtilsKt.iterateContents(file, this.buildVisitor((PyFile)file, problemsHolder, (ProjectData)report2, globalContext, (Map<String, String>)pathsMap));
    }

    @Override
    public boolean validateFileType(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof PyFile;
    }

    @Override
    public void cleanup(@NotNull QodanaGlobalInspectionContext globalContext) {
        ProjectData data2;
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Lazy lazy = (Lazy)globalContext.getUserData(py);
        Object object = data2 = lazy != null ? (ProjectData)lazy.getValue() : null;
        if (data2 != null) {
            String string = PyCoverageEngine.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            this.saveCoverageData(globalContext, string, UtilsKt.removePrefixFromCoverage(data2, globalContext.getConfig().getProjectPath()));
        }
        globalContext.putUserData(py, null);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Object[] objectArray = this.defaultThresholdOpts();
        OptNumber optNumber = OptPane.number((String)"fileThreshold", (String)QodanaBundle.message("file.coverage.threshold.value", new Object[0]), (int)1, (int)100);
        Intrinsics.checkNotNullExpressionValue((Object)optNumber, (String)"number(...)");
        spreadBuilder.addSpread((Object)ArraysKt.plus((Object[])objectArray, (Object)optNumber));
        spreadBuilder.add((Object)this.missingCoverageOpt());
        OptPane optPane = OptPane.pane((OptRegularComponent[])((OptRegularComponent[])spreadBuilder.toArray((Object[])new OptRegularComponent[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    private final void loadNormalizedPaths(QodanaGlobalInspectionContext globalContext, ProjectData report2) {
        globalContext.putUserData(normalizedPaths, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Map<String, ? extends String>>(report2){
            final /* synthetic */ ProjectData $report;
            {
                this.$report = $report;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, String> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.$report.getClasses().keySet();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    String string = (String)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    map2.put(UtilsKt.normalizeFilePath((String)it), element$iv$iv);
                }
                return destination$iv$iv;
            }
        })));
    }

    private final PsiElementVisitor buildVisitor(PyFile file, ProblemsHolder holder, ProjectData report2, QodanaGlobalInspectionContext globalContext, Map<String, String> pathsMap) {
        String string = file.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String normalizedPath = UtilsKt.normalizeFilePath(string);
        String path = pathsMap.getOrDefault(normalizedPath, normalizedPath);
        ClassData data2 = report2.getClassData(path);
        if (data2 == null && !this.getWarnMissingCoverage()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        VirtualFile virtualFile2 = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        UtilsKt.loadClassData(data2, virtualFile2, globalContext);
        PsiFile psiFile2 = (PsiFile)file;
        TextRange textRange = file.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (UtilsKt.issueWithClassCoverage$default(data2, psiFile2, textRange, project, this.fileThreshold, this.getWarnMissingCoverage(), false, 64, null)) {
            PsiElement psiElement = file.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
            Object[] objectArray = new Object[]{file.getVirtualFile().getPresentableName(), this.fileThreshold};
            String string2 = QodanaBundle.message("file.coverage.below.threshold", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            UtilsKt.reportElement(holder, psiElement, string2);
        }
        return (PsiElementVisitor)new PyElementVisitor(data2, file, this, holder, globalContext){
            final /* synthetic */ ClassData $data;
            final /* synthetic */ PyFile $file;
            final /* synthetic */ PyCoverageInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ QodanaGlobalInspectionContext $globalContext;
            {
                this.$data = $data;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$globalContext = $globalContext;
            }

            public void visitPyFunction(@NotNull PyFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                PsiFile psiFile2 = (PsiFile)this.$file;
                TextRange textRange = PyCoverageInspection.access$computeRealFunctionRange(this.this$0, function);
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (UtilsKt.issueWithMethodCoverage(this.$data, psiFile2, textRange, project, this.this$0.getMethodThreshold(), this.this$0.getWarnMissingCoverage(), this.$globalContext)) {
                    String string;
                    if (Intrinsics.areEqual((Object)function.getName(), (Object)"__init__")) {
                        PyClass clazz = function.getContainingClass();
                        String fqn = clazz != null ? clazz.getName() : "__init__";
                        Object[] objectArray = new Object[]{fqn, this.this$0.getMethodThreshold()};
                        string = QodanaBundle.message("constructor.coverage.below.threshold", objectArray);
                    } else {
                        Object[] objectArray = new Object[]{function.getName(), this.this$0.getMethodThreshold()};
                        string = QodanaBundle.message("method.coverage.below.threshold", objectArray);
                    }
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)string2);
                    String message = string2;
                    UtilsKt.reportElement(this.$holder, PyCoverageInspection.access$highlightedElement(this.this$0, (PsiElement)function), message);
                }
            }

            public void visitPyClass(@NotNull PyClass aClass) {
                Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                PsiFile psiFile2 = (PsiFile)this.$file;
                TextRange textRange = aClass.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (UtilsKt.issueWithClassCoverage$default(this.$data, psiFile2, textRange, project, this.this$0.getClassThreshold(), this.this$0.getWarnMissingCoverage(), false, 64, null)) {
                    PsiElement psiElement = PyCoverageInspection.access$highlightedElement(this.this$0, (PsiElement)aClass);
                    Object[] objectArray = new Object[]{aClass.getName(), this.this$0.getClassThreshold()};
                    String string = QodanaBundle.message("class.coverage.below.threshold", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    UtilsKt.reportElement(this.$holder, psiElement, string);
                }
            }
        };
    }

    private final TextRange computeRealFunctionRange(PyFunction node) {
        PsiElement first;
        PsiElement[] children2;
        TextRange range;
        block4: {
            PsiElement psiElement;
            range = node.getTextRange();
            PsiElement[] psiElementArray = node.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            PsiElement[] $this$firstOrNull$iv = children2 = psiElementArray;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiElement element$iv;
                PsiElement it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(it instanceof PyStatement)) continue;
                psiElement = element$iv;
                break block4;
            }
            psiElement = first = null;
        }
        if (first != null) {
            PsiElement element$iv;
            block5: {
                PsiElement[] $this$last$iv = children2;
                boolean $i$f$last = false;
                int n = $this$last$iv.length + -1;
                if (0 <= n) {
                    do {
                        int index$iv = n--;
                        PsiElement it = element$iv = $this$last$iv[index$iv];
                        boolean bl = false;
                        if (it instanceof PyStatement) break block5;
                    } while (0 <= n);
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            PsiElement psiElement = element$iv;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"last(...)");
            PsiElement last = psiElement;
            range = TextRange.create((int)first.getTextRange().getStartOffset(), (int)last.getTextRange().getEndOffset());
        }
        TextRange textRange = range;
        Intrinsics.checkNotNull((Object)textRange);
        return textRange;
    }

    public static final /* synthetic */ void access$loadNormalizedPaths(PyCoverageInspection $this, QodanaGlobalInspectionContext globalContext, ProjectData report2) {
        $this.loadNormalizedPaths(globalContext, report2);
    }

    public static final /* synthetic */ TextRange access$computeRealFunctionRange(PyCoverageInspection $this, PyFunction node) {
        return $this.computeRealFunctionRange(node);
    }

    public static final /* synthetic */ PsiElement access$highlightedElement(PyCoverageInspection $this, PsiElement element2) {
        return $this.highlightedElement(element2);
    }

    static {
        Key key = Key.create((String)"qodana.python.coverage");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        py = key;
        Key key2 = Key.create((String)"qodana.python.normalizedPaths");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        normalizedPaths = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RE\u0010\u0003\u001a9\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006 \b*\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\n\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b \b*\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/python/PyCoverageInspection$Companion;", "", "()V", "normalizedPaths", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Lazy;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "py", "Lcom/intellij/rt/coverage/data/ProjectData;", "intellij.qodana.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

