/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.incubator.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.extension.incubator.propagation.ExtendedContextPropagators;
import io.opentelemetry.extension.incubator.trace.SpanCallable;
import io.opentelemetry.extension.incubator.trace.SpanRunnable;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public final class ExtendedSpanBuilder
implements SpanBuilder {
    private final SpanBuilder delegate;

    ExtendedSpanBuilder(SpanBuilder delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExtendedSpanBuilder setParent(Context context) {
        this.delegate.setParent(context);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setNoParent() {
        this.delegate.setNoParent();
        return this;
    }

    @Override
    public ExtendedSpanBuilder addLink(SpanContext spanContext) {
        this.delegate.addLink(spanContext);
        return this;
    }

    @Override
    public ExtendedSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        this.delegate.addLink(spanContext, attributes);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, String value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, long value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, double value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setAttribute(String key, boolean value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    @Override
    public <T> ExtendedSpanBuilder setAttribute(AttributeKey<T> key, T value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setAllAttributes(Attributes attributes) {
        this.delegate.setAllAttributes(attributes);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setSpanKind(SpanKind spanKind) {
        this.delegate.setSpanKind(spanKind);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        this.delegate.setStartTimestamp(startTimestamp, unit);
        return this;
    }

    @Override
    public ExtendedSpanBuilder setStartTimestamp(Instant startTimestamp) {
        this.delegate.setStartTimestamp(startTimestamp);
        return this;
    }

    public ExtendedSpanBuilder setParentFrom(ContextPropagators propagators, Map<String, String> carrier) {
        this.setParent(ExtendedContextPropagators.extractTextMapPropagationContext(carrier, propagators));
        return this;
    }

    @Override
    public Span startSpan() {
        return this.delegate.startSpan();
    }

    public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable) throws E {
        return this.startAndCall(spanCallable, ExtendedSpanBuilder::setSpanError);
    }

    public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable, BiConsumer<Span, Throwable> handleException) throws E {
        Span span = this.startSpan();
        try {
            T t;
            block11: {
                Scope unused = span.makeCurrent();
                try {
                    t = spanCallable.callInSpan();
                    if (unused == null) break block11;
                    unused.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (unused != null) {
                            try {
                                unused.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        handleException.accept(span, e);
                        throw e;
                    }
                }
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable) throws E {
        this.startAndRun(runnable, ExtendedSpanBuilder::setSpanError);
    }

    public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable, BiConsumer<Span, Throwable> handleException) throws E {
        this.startAndCall(() -> {
            runnable.runInSpan();
            return null;
        }, handleException);
    }

    private static void setSpanError(Span span, Throwable exception) {
        span.setStatus(StatusCode.ERROR);
        span.recordException(exception);
    }
}

