/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.GHCompatibilityUtil;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final Condition<@Nullable VirtualFile> FILE_WITH_CONTENT = f -> f != null && !f.getFileType().isBinary();

    protected GithubCreateGistAction() {
        super(GithubBundle.messagePointer("create.gist.action.title", new Object[0]), GithubBundle.messagePointer("create.gist.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GithubCreateGistAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean hasFilesWithContent;
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GHAccountManager accountManager = (GHAccountManager)((Object)ApplicationManager.getApplication().getService(GHAccountManager.class));
        GHHostedRepositoriesManager hostedRepositoriesManager = (GHHostedRepositoriesManager)project.getService(GHHostedRepositoriesManager.class);
        if (((Set)hostedRepositoriesManager.getKnownRepositoriesState().getValue()).isEmpty() && ((Set)accountManager.getAccountsState().getValue()).isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        boolean bl = hasFilesWithContent = FILE_WITH_CONTENT.value((Object)file) || files != null && ContainerUtil.exists((Object[])files, FILE_WITH_CONTENT);
        if (!hasFilesWithContent || editor != null && editor.getDocument().getTextLength() == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        GithubCreateGistAction.createGistAction(project, editor, (VirtualFile)(FILE_WITH_CONTENT.value((Object)file) ? file : null), GithubCreateGistAction.filterFilesWithContent(files));
    }

    private static VirtualFile @Nullable [] filterFilesWithContent(@Nullable @Nullable VirtualFile @Nullable [] files) {
        if (files == null) {
            return null;
        }
        return ContainerUtil.filter((Object[])files, FILE_WITH_CONTENT).toArray(VirtualFile.EMPTY_ARRAY);
    }

    private static void createGistAction(final @NotNull Project project, final @Nullable Editor editor, final @Nullable VirtualFile file, final VirtualFile @Nullable [] files) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(3);
        }
        GithubSettings settings = GithubSettings.getInstance();
        final GithubCreateGistDialog dialog = new GithubCreateGistDialog(project, GithubCreateGistAction.getFileName(editor, files), settings.isPrivateGist(), settings.isOpenInBrowserGist(), settings.isCopyURLGist());
        if (!dialog.showAndGet()) {
            return;
        }
        settings.setPrivateGist(dialog.isSecret());
        settings.setOpenInBrowserGist(dialog.isOpenInBrowser());
        settings.setCopyURLGist(dialog.isCopyURL());
        final GithubAccount account = Objects.requireNonNull(dialog.getAccount());
        final Ref url = new Ref();
        new Task.Backgroundable(project, GithubBundle.message("create.gist.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                String token2;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((token2 = GHCompatibilityUtil.getOrRequestToken(account, project)) == null) {
                    return;
                }
                GithubApiRequestExecutor requestExecutor = GithubApiRequestExecutor.Factory.getInstance().create(account.getServer(), token2);
                List<GithubGistRequest.FileContent> contents = GithubCreateGistAction.collectContents(project, editor, file, files);
                if (contents.isEmpty()) {
                    return;
                }
                String gistUrl = GithubCreateGistAction.createGist(project, requestExecutor, indicator, account.getServer(), contents, dialog.isSecret(), dialog.getDescription(), dialog.getFileName());
                url.set((Object)gistUrl);
            }

            public void onSuccess() {
                if (url.isNull()) {
                    return;
                }
                if (dialog.isCopyURL()) {
                    StringSelection stringSelection = new StringSelection((String)url.get());
                    CopyPasteManager.getInstance().setContents((Transferable)stringSelection);
                }
                if (dialog.isOpenInBrowser()) {
                    BrowserUtil.browse((String)((String)url.get()));
                } else {
                    GithubNotifications.showInfoURL(project, "github.gist.created", GithubBundle.message("create.gist.success", new Object[0]), GithubBundle.message("create.gist.url", new Object[0]), (String)url.get());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreateGistAction$1", "run"));
            }
        }.queue();
    }

    @Nullable
    private static String getFileName(@Nullable Editor editor, VirtualFile @Nullable [] files) {
        if (files != null && files.length == 1 && !files[0].isDirectory()) {
            return files[0].getName();
        }
        if (editor != null) {
            return "";
        }
        return null;
    }

    @NotNull
    static List<GithubGistRequest.FileContent> collectContents(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, VirtualFile @Nullable [] files) {
        String content2;
        boolean isBackedFile;
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(4);
        }
        boolean bl = isBackedFile = file != null && file instanceof BackedVirtualFile;
        if (editor != null && (content2 = GithubCreateGistAction.getContentFromEditor(editor, isBackedFile)) != null) {
            if (file != null) {
                List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent(file.getName(), content2));
                if (list == null) {
                    GithubCreateGistAction.$$$reportNull$$$0(5);
                }
                return list;
            }
            List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent("", content2));
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (files != null) {
            ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
            for (VirtualFile vf : files) {
                contents.addAll(GithubCreateGistAction.getContentFromFile(vf, project, null));
            }
            ArrayList<GithubGistRequest.FileContent> arrayList = contents;
            if (arrayList == null) {
                GithubCreateGistAction.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        if (file != null) {
            return GithubCreateGistAction.getContentFromFile(file, project, null);
        }
        LOG.error("File, files and editor can't be null all at once!");
        throw new IllegalStateException("File, files and editor can't be null all at once!");
    }

    @Nullable
    static String createGist(@NotNull Project project, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, boolean isSecret, @NotNull String description, @Nullable String filename) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(8);
        }
        if (executor == null) {
            GithubCreateGistAction.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            GithubCreateGistAction.$$$reportNull$$$0(10);
        }
        if (server == null) {
            GithubCreateGistAction.$$$reportNull$$$0(11);
        }
        if (contents == null) {
            GithubCreateGistAction.$$$reportNull$$$0(12);
        }
        if (description == null) {
            GithubCreateGistAction.$$$reportNull$$$0(13);
        }
        if (contents.isEmpty()) {
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.empty", new Object[0]));
            return null;
        }
        if (contents.size() == 1 && filename != null) {
            GithubGistRequest.FileContent entry = contents.iterator().next();
            contents = Collections.singletonList(new GithubGistRequest.FileContent(filename, entry.getContent()));
        }
        try {
            return executor.execute(indicator, GithubApiRequests.Gists.create(server, contents, description, !isSecret)).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), e);
            return null;
        }
    }

    @Nullable
    private static String getContentFromEditor(@NotNull Editor editor, boolean onlySelection) {
        String text;
        if (editor == null) {
            GithubCreateGistAction.$$$reportNull$$$0(14);
        }
        if ((text = (String)ReadAction.compute(() -> editor.getSelectionModel().getSelectedText())) == null && !onlySelection) {
            text = editor.getDocument().getText();
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        return text;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromFile(@NotNull VirtualFile file, @NotNull Project project, @Nullable String prefix) {
        VirtualFile realFile;
        if (file == null) {
            GithubCreateGistAction.$$$reportNull$$$0(15);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(16);
        }
        if ((realFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file)).isDirectory()) {
            return GithubCreateGistAction.getContentFromDirectory(realFile, project, prefix);
        }
        if (realFile.getFileType().isBinary()) {
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.binary.file", realFile.getName()));
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(17);
            }
            return list;
        }
        String content2 = (String)WriteAction.computeAndWait(() -> {
            try {
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Document document = fileDocumentManager.getDocument(realFile);
                if (document != null) {
                    fileDocumentManager.saveDocument(document);
                    return document.getText();
                }
                return new String(realFile.contentsToByteArray(), realFile.getCharset());
            }
            catch (IOException e) {
                LOG.info("Couldn't read contents of the file " + realFile, (Throwable)e);
                return null;
            }
        });
        if (content2 == null) {
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.content.read", realFile.getName()));
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (StringUtil.isEmptyOrSpaces((String)content2)) {
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(19);
            }
            return list;
        }
        String filename = GithubCreateGistAction.addPrefix(realFile.getName(), prefix, false);
        List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent(filename, content2));
        if (list == null) {
            GithubCreateGistAction.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromDirectory(@NotNull VirtualFile dir, @NotNull Project project, @Nullable String prefix) {
        if (dir == null) {
            GithubCreateGistAction.$$$reportNull$$$0(21);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(22);
        }
        ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
        for (VirtualFile file : dir.getChildren()) {
            if (GithubCreateGistAction.isFileIgnored(file, project)) continue;
            String pref = GithubCreateGistAction.addPrefix(dir.getName(), prefix, true);
            contents.addAll(GithubCreateGistAction.getContentFromFile(file, project, pref));
        }
        ArrayList<GithubGistRequest.FileContent> arrayList = contents;
        if (arrayList == null) {
            GithubCreateGistAction.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static String addPrefix(@NotNull String name, @Nullable String prefix, boolean addTrailingSlash) {
        if (name == null) {
            GithubCreateGistAction.$$$reportNull$$$0(24);
        }
        Object pref = prefix == null ? "" : prefix;
        pref = (String)pref + name;
        if (addTrailingSlash) {
            pref = (String)pref + "_";
        }
        return pref;
    }

    private static boolean isFileIgnored(@NotNull VirtualFile file, @NotNull Project project) {
        ChangeListManager manager;
        if (file == null) {
            GithubCreateGistAction.$$$reportNull$$$0(25);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(26);
        }
        return (manager = ChangeListManager.getInstance((Project)project)).isIgnoredFile(file) || FileTypeManager.getInstance().isFileIgnored(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 21, 22, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectContents";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createGistAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectContents";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createGist";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromEditor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addPrefix";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 21, 22, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }
}

