/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.PasswordAuthentication;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;

public class ProxyCallback
extends AuthCallbackCase {
    private static final Logger LOG = Logger.getInstance(ProxyCallback.class);
    @NonNls
    private static final String CANNOT_AUTHENTICATE_TO_PROXY = "Could not authenticate to proxy server";
    @NonNls
    private static final String PROXY_AUTHENTICATION_FAILED = "Proxy authentication failed";
    private PasswordAuthentication myProxyAuthentication;

    ProxyCallback(@NotNull AuthenticationService authenticationService, Url url) {
        if (authenticationService == null) {
            ProxyCallback.$$$reportNull$$$0(0);
        }
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.contains(CANNOT_AUTHENTICATE_TO_PROXY) || error.contains(PROXY_AUTHENTICATION_FAILED);
    }

    @Override
    boolean getCredentials(String errText) {
        boolean result = false;
        if (this.myUrl == null) {
            LOG.info("Proxy callback could handle error text, but repository url is null", new Throwable());
            result = true;
        } else if (this.myAuthenticationService.haveDataForTmpConfig()) {
            this.myProxyAuthentication = this.myAuthenticationService.getProxyAuthentication(this.myUrl);
            result = this.myProxyAuthentication != null;
        }
        return result;
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        String proxyHostParameter;
        if (command == null) {
            ProxyCallback.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmpty((String)(proxyHostParameter = (String)ContainerUtil.find(command.getParameters(), s -> s.contains("http-proxy-port")))) && this.myUrl != null && this.myProxyAuthentication != null) {
            String group = ProxyCallback.getHostGroup(proxyHostParameter);
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-username=%s", group, this.myProxyAuthentication.getUserName()));
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-password=%s", group, String.valueOf(this.myProxyAuthentication.getPassword())));
        }
    }

    @NotNull
    private static String getHostGroup(@NotNull String proxyHostParameter) {
        if (proxyHostParameter == null) {
            ProxyCallback.$$$reportNull$$$0(2);
        }
        int start = proxyHostParameter.indexOf(":");
        int finish = proxyHostParameter.indexOf(":", start + 1);
        String string = proxyHostParameter.substring(start + 1, finish);
        if (string == null) {
            ProxyCallback.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyHostParameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/ProxyCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/ProxyCallback";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHostGroup";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

