/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.parsers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.startup.importSettings.db.WindowsEnvVariables;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.providers.vswin.mappings.FontsAndColorsMappings;
import com.intellij.ide.startup.importSettings.providers.vswin.mappings.VisualStudioPluginsMapping;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSRegistryParserNew;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHive;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHiveDetourFileNotFoundException;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSProfileDetectorUtils;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSProfileSettingsFileNotFound;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.IRegistryKey;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.impl.PrivateRegistryRoot;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.impl.RegistryRoot;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.FileUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010.\u001a\u00020\bH\u0002J\u0018\u0010/\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\nH\u0002J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J\b\u00101\u001a\u000202H\u0002J\n\u00103\u001a\u0004\u0018\u00010\u0011H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u00105\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0002J\u0010\u00106\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0002J\n\u00107\u001a\u0004\u0018\u00010\bH\u0002J\n\u00108\u001a\u0004\u0018\u00010&H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR'\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010!\u001a\u0004\u0018\u00010\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000e\u001a\u0004\b\"\u0010#R\u001d\u0010%\u001a\u0004\u0018\u00010&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u000e\u001a\u0004\b'\u0010(R\u001d\u0010*\u001a\u0004\u0018\u00010\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u000e\u001a\u0004\b+\u0010,\u00a8\u0006;"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSRegistryParserNew;", "", "hive", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "(Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;)V", "appDataHiveFolder", "Ljava/nio/file/Path;", "detourFile", "Ljava/io/File;", "envPath", "Lkotlin/Pair;", "getEnvPath", "()Lkotlin/Pair;", "envPath$delegate", "Lkotlin/Lazy;", "extensions", "", "", "Lcom/intellij/ide/startup/importSettings/models/FeatureInfo;", "getExtensions", "()Ljava/util/Map;", "extensions$delegate", "getHive", "()Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "recentProjects", "", "Lcom/intellij/ide/startup/importSettings/models/RecentPathInfo;", "getRecentProjects", "()Ljava/util/List;", "recentProjects$delegate", "registryRootKey", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/registryUtils/IRegistryKey;", "registryRootKeyConfig", "settingsFile", "getSettingsFile", "()Ljava/io/File;", "settingsFile$delegate", "theme", "Lcom/intellij/ide/startup/importSettings/models/ILookAndFeel;", "getTheme", "()Lcom/intellij/ide/startup/importSettings/models/ILookAndFeel;", "theme$delegate", "vsLocation", "getVsLocation", "()Ljava/lang/String;", "vsLocation$delegate", "detourFileInit", "envPathInit", "extensionsListInit", "isRegistryDetourRequired", "", "loadCodeContainersFromConfig", "loadCodeContainersFromRegistry", "recentProjectsInit", "recentProjectsNewVSInit", "settingsFileInit", "themeInit", "vsLocationInit", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSRegistryParserNew.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSRegistryParserNew.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSRegistryParserNew\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,353:1\n1603#2,9:354\n1855#2:363\n1856#2:365\n1612#2:366\n1603#2,9:368\n1855#2:377\n1856#2:379\n1612#2:380\n1054#2:381\n1549#2:382\n1620#2,3:383\n1#3:364\n1#3:367\n1#3:378\n1#3:396\n1#3:399\n135#4,9:386\n215#4:395\n216#4:397\n144#4:398\n60#5,3:400\n11#5:403\n*S KotlinDebug\n*F\n+ 1 VSRegistryParserNew.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSRegistryParserNew\n*L\n101#1:354,9\n101#1:363\n101#1:365\n101#1:366\n205#1:368,9\n205#1:377\n205#1:379\n205#1:380\n220#1:381\n222#1:382\n222#1:383,3\n101#1:364\n205#1:378\n268#1:396\n268#1:386,9\n268#1:395\n268#1:397\n268#1:398\n314#1:400,3\n41#1:403\n*E\n"})
public final class VSRegistryParserNew {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VSHive hive;
    @NotNull
    private final Path appDataHiveFolder;
    @Nullable
    private final File detourFile;
    @NotNull
    private final Lazy envPath$delegate;
    @NotNull
    private final Lazy settingsFile$delegate;
    @NotNull
    private final Lazy vsLocation$delegate;
    @NotNull
    private final Lazy recentProjects$delegate;
    @NotNull
    private final Lazy extensions$delegate;
    @NotNull
    private final Lazy theme$delegate;
    @NotNull
    private final IRegistryKey registryRootKey;
    @NotNull
    private final IRegistryKey registryRootKeyConfig;
    @NotNull
    private static final Lifetime veryBadLifetime = Lifetime.Companion.getEternal();
    @NotNull
    private static final Logger logger;

    private VSRegistryParserNew(VSHive hive) {
        RegistryRoot registryRoot;
        this.hive = hive;
        Path path = Paths.get(WindowsEnvVariables.INSTANCE.getLocalApplicationData() + "\\Microsoft\\VisualStudio\\" + this.hive.getHiveString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.appDataHiveFolder = path;
        this.detourFile = this.isRegistryDetourRequired() ? this.detourFileInit() : null;
        this.envPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair<? extends Path, ? extends File>>(this){
            final /* synthetic */ VSRegistryParserNew this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Pair<Path, File> invoke() {
                return VSRegistryParserNew.access$envPathInit(this.this$0);
            }
        }));
        this.settingsFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ VSRegistryParserNew this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final File invoke() {
                return VSRegistryParserNew.access$settingsFileInit(this.this$0);
            }
        }));
        this.vsLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ VSRegistryParserNew this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return VSRegistryParserNew.access$vsLocationInit(this.this$0);
            }
        }));
        this.recentProjects$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<RecentPathInfo>>(this){
            final /* synthetic */ VSRegistryParserNew this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<RecentPathInfo> invoke() {
                List list = VSRegistryParserNew.access$recentProjectsInit(this.this$0);
                if (list == null) {
                    list = new ArrayList<E>();
                }
                return list;
            }
        }));
        this.extensions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends FeatureInfo>>(this){
            final /* synthetic */ VSRegistryParserNew this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, FeatureInfo> invoke() {
                return VSRegistryParserNew.access$extensionsListInit(this.this$0);
            }
        }));
        this.theme$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ILookAndFeel>(this){
            final /* synthetic */ VSRegistryParserNew this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ILookAndFeel invoke() {
                return VSRegistryParserNew.access$themeInit(this.this$0);
            }
        }));
        if (this.isRegistryDetourRequired()) {
            if (this.detourFile == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            registryRoot = PrivateRegistryRoot.Companion.getOrCreate(this.detourFile, veryBadLifetime);
        } else {
            WinReg.HKEY hKEY = WinReg.HKEY_CURRENT_USER;
            Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"HKEY_CURRENT_USER");
            registryRoot = new RegistryRoot(hKEY, veryBadLifetime);
        }
        this.registryRootKey = registryRoot.fromKey("SOFTWARE\\Microsoft\\VisualStudio\\" + this.hive.getHiveString());
        this.registryRootKeyConfig = this.registryRootKey.withSuffix("_Config");
    }

    @NotNull
    public final VSHive getHive() {
        return this.hive;
    }

    @NotNull
    public final Pair<Path, File> getEnvPath() {
        Lazy lazy = this.envPath$delegate;
        return (Pair)lazy.getValue();
    }

    @Nullable
    public final File getSettingsFile() {
        Lazy lazy = this.settingsFile$delegate;
        return (File)lazy.getValue();
    }

    @Nullable
    public final String getVsLocation() {
        Lazy lazy = this.vsLocation$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final List<RecentPathInfo> getRecentProjects() {
        Lazy lazy = this.recentProjects$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Map<String, FeatureInfo> getExtensions() {
        Lazy lazy = this.extensions$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final ILookAndFeel getTheme() {
        Lazy lazy = this.theme$delegate;
        return (ILookAndFeel)lazy.getValue();
    }

    private final boolean isRegistryDetourRequired() {
        return this.hive.getInstanceId() != null;
    }

    private final ILookAndFeel themeInit() {
        String string;
        try {
            String string2;
            String string3 = this.registryRootKey.inChild("General").getStringValue("CurrentTheme");
            if (string3 != null) {
                String string4 = string3.toUpperCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Throwable throwable) {
            return null;
        }
        String regValue = string;
        if (regValue == null) {
            return FontsAndColorsMappings.VsTheme.Dark.toRiderTheme();
        }
        return FontsAndColorsMappings.VsTheme.Companion.fromString(regValue).toRiderTheme();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, FeatureInfo> extensionsListInit() {
        Map map2;
        Object object;
        IRegistryKey packagesKey = this.registryRootKeyConfig.inChild("Packages");
        try {
            Object object2;
            List<String> list = packagesKey.getKeys();
            if (list != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                object = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String string;
                    Map<String, Object> a;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    Map<String, Object> map3 = a = packagesKey.inChild(it).getValues();
                    Object compName = map3 != null ? map3.get("CompanyName") : null;
                    Map<String, Object> map4 = a;
                    if (map4 == null || (map4 = map4.get("ProductName")) == null) {
                        string = null;
                    } else {
                        Map<String, Object> productName = map4;
                        string = compName + "|" + productName;
                    }
                    if (string == null) continue;
                    String it$iv$iv = string;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                object2 = (List)destination$iv$iv;
            } else {
                object2 = null;
            }
            map2 = object2;
        }
        catch (Throwable t) {
            logger.warn("error in new method");
            logger.warn(t);
            return MapsKt.emptyMap();
        }
        Map preParsed = map2;
        Map map5 = preParsed;
        logger.info("Installed plugins in " + this.hive.getHiveString() + ": " + (map5 != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)map5)), null, null, null, (int)0, null, (Function1)extensionsListInit.1.INSTANCE, (int)31, null) : null));
        Map $this$extensionsListInit_u24lambda_u241 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        if (preParsed != null) {
            object = preParsed.iterator();
            while (object.hasNext()) {
                String id = (String)object.next();
                FeatureInfo plugin = VisualStudioPluginsMapping.INSTANCE.get(id);
                if (plugin == null) continue;
                $this$extensionsListInit_u24lambda_u241.put(id, plugin);
            }
        }
        return MapsKt.build((Map)map2);
    }

    private final Pair<Path, File> envPathInit() {
        String string;
        String string2;
        Path envDir = null;
        File devEnv = null;
        IRegistryKey setupVSKey = this.registryRootKeyConfig.div("Setup").div("VS");
        try {
            string2 = setupVSKey.getStringValue("EnvironmentDirectory");
        }
        catch (Throwable t) {
            logger.warn("Failed to obtain path to EnvDir (probably vs is corrupted)");
            logger.debug(t);
            return new Pair(null, null);
        }
        String fileDirStr = string2;
        if (fileDirStr == null) {
            logger.warn("EnvDir is null");
        }
        try {
            string = setupVSKey.getStringValue("EnvironmentPath");
        }
        catch (Throwable t) {
            logger.warn("Failed to obtain path to EnvPath (probably vs is corrupted)");
            logger.debug(t);
            return new Pair(null, null);
        }
        String filePathStr = string;
        if (filePathStr == null) {
            logger.warn("EnvPath is null");
        }
        if (fileDirStr != null) {
            Path path = Paths.get(fileDirStr, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            envDir = path;
            if (!Files.exists(envDir, new LinkOption[0])) {
                logger.info("envDir was not found in fs");
                envDir = null;
            }
        }
        if (filePathStr != null) {
            devEnv = new File(filePathStr);
        }
        return new Pair(envDir, (Object)devEnv);
    }

    private final File settingsFileInit() {
        File file;
        String path;
        String string;
        try {
            string = this.registryRootKey.inChild("Profile").getStringValue("AutoSaveFile");
        }
        catch (Win32Exception win32Exception) {
            throw new VSProfileSettingsFileNotFound("A problem occurred while trying to work with registry. Probably key does not exist.", null, 2, null);
        }
        String string2 = string;
        if (string2 == null) {
            throw new Exception("Unknown registry error");
        }
        String unexpandedPath = string2;
        String string3 = path = VSProfileDetectorUtils.INSTANCE.expandPath(unexpandedPath, this.hive);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        return file;
    }

    private final String vsLocationInit() {
        return this.registryRootKey.getStringValue("VisualStudioLocation");
    }

    /*
     * Unable to fully structure code
     */
    private final List<RecentPathInfo> recentProjectsNewVSInit() {
        v0 = this.loadCodeContainersFromConfig();
        if (v0 == null && (v0 = this.loadCodeContainersFromRegistry()) == null) {
            return null;
        }
        dataSource = v0;
        try {
            var3_2 = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS)).readTree(dataSource);
        }
        catch (Throwable t) {
            VSRegistryParserNew.logger.warn(t);
            return null;
        }
        root = var3_2;
        Intrinsics.checkNotNull((Object)root);
        $this$mapNotNull$iv = (Iterable)root;
        $i$f$mapNotNull = false;
        var6_7 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var11_13 = $this$forEach$iv$iv$iv.iterator();
        while (var11_13.hasNext()) {
            block9: {
                block8: {
                    element$iv$iv = element$iv$iv$iv = var11_13.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (JsonNode)element$iv$iv;
                    $i$a$-mapNotNull-VSRegistryParserNew$recentProjectsNewVSInit$preItems$1 = false;
                    if (it.get("Value").get("IsLocal").asBoolean()) break block8;
                    v1 = null;
                    break block9;
                }
                date = it.get("Value").get("LastAccessed").asText();
                path = it.get("Value").get("LocalProperties").get("FullPath").asText();
                Intrinsics.checkNotNull((Object)path);
                pathExpanded = VSProfileDetectorUtils.INSTANCE.expandPath(path, this.hive);
                if (pathExpanded == null) ** GOTO lbl-1000
                v2 = Paths.get(pathExpanded, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                v3 = new LinkOption[]{};
                if (!Files.exists(v2, Arrays.copyOf(v3, v3.length))) lbl-1000:
                // 2 sources

                {
                    v1 = null;
                } else {
                    $this$recentProjectsNewVSInit_u24lambda_u244_u24lambda_u243 = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(date);
                    $i$a$-run-VSRegistryParserNew$recentProjectsNewVSInit$preItems$1$dateParser$1 = false;
                    dateParser = Instant.from($this$recentProjectsNewVSInit_u24lambda_u244_u24lambda_u243);
                    dateConverted = Date.from(dateParser);
                    v1 = new Pair((Object)pathExpanded, (Object)dateConverted);
                }
            }
            if (v1 == null) continue;
            it$iv$iv = v1;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        preItems = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Date)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Date)it.getSecond()));
            }
        });
        $this$map$iv = preItems;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_13 = (Pair)item$iv$iv;
            var26_30 = destination$iv$iv;
            $i$a$-map-VSRegistryParserNew$recentProjectsNewVSInit$1 = false;
            v4 = VSProfileDetectorUtils.INSTANCE.expandPath((String)it.getFirst(), this.hive);
            Intrinsics.checkNotNull((Object)v4);
            pathExp = new File(v4);
            $this$recentProjectsNewVSInit_u24lambda_u247_u24lambda_u246 = var14_18 = new RecentProjectMetaInfo();
            $i$a$-apply-VSRegistryParserNew$recentProjectsNewVSInit$1$info$1 = false;
            $this$recentProjectsNewVSInit_u24lambda_u247_u24lambda_u246.setMetadata(null);
            if (pathExp.isDirectory()) {
                $this$recentProjectsNewVSInit_u24lambda_u247_u24lambda_u246.setMetadata("folder|");
            }
            $this$recentProjectsNewVSInit_u24lambda_u247_u24lambda_u246.setDisplayName(pathExp.getName());
            $this$recentProjectsNewVSInit_u24lambda_u247_u24lambda_u246.setProjectOpenTimestamp(((Date)it.getSecond()).getTime());
            $this$recentProjectsNewVSInit_u24lambda_u247_u24lambda_u246.setBuildTimestamp(((Date)it.getSecond()).getTime());
            info = var14_18;
            var26_30.add(new RecentPathInfo(FileUtilKt.getSystemIndependentPath((File)pathExp), info));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<RecentPathInfo> recentProjectsInit() {
        void $this$mapNotNullTo$iv$iv;
        Map<String, Object> map2;
        List<RecentPathInfo> newMethod = this.recentProjectsNewVSInit();
        if (newMethod != null) {
            return newMethod;
        }
        logger.info("New proj detection method failed");
        try {
            try {
                map2 = this.registryRootKey.div("MRUItems").div("{a9c4a31f-f9cb-47a9-abc0-49ce82d0b3ac}").div("Items").getValues();
            }
            catch (Throwable t2) {
                logger.info("Failed to get recent projects using new method, trying old one");
                logger.debug(t2);
                map2 = this.registryRootKey.div("ProjectMRUList").getValues();
            }
        }
        catch (Throwable t) {
            logger.warn("Sorry, no recent projects for you");
            logger.debug(t);
            return null;
        }
        Map<String, Object> registry2 = map2;
        if (registry2 == null) {
            logger.info("No recent projects found (no registry keys)");
            return null;
        }
        Map<String, Object> $this$mapNotNull$iv = registry2;
        boolean $i$f$mapNotNull = false;
        Map<String, Object> map3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            RecentPathInfo recentPathInfo;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry2 = element$iv$iv;
            boolean bl2 = false;
            Object item = entry2.getValue();
            if (!(item instanceof String)) {
                logger.warn("Got not strings for keys for some unknown reason");
                recentPathInfo = null;
            } else {
                char[] cArray = new char[]{'|', ';'};
                List spl = StringsKt.split$default((CharSequence)((CharSequence)item), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                String path = (String)spl.get(0);
                String name = (String)spl.get(3);
                if (((CharSequence)path).length() == 0) {
                    logger.warn("path is empty");
                    recentPathInfo = null;
                } else {
                    RecentProjectMetaInfo recentProjectMetaInfo;
                    long i = 0L;
                    i = System.currentTimeMillis();
                    String string = VSProfileDetectorUtils.INSTANCE.expandPath(path, this.hive);
                    Intrinsics.checkNotNull((Object)string);
                    File pathExp = new File(string);
                    RecentProjectMetaInfo $this$recentProjectsInit_u24lambda_u249_u24lambda_u248 = recentProjectMetaInfo = new RecentProjectMetaInfo();
                    boolean bl3 = false;
                    i -= (long)1000;
                    $this$recentProjectsInit_u24lambda_u249_u24lambda_u248.setMetadata(null);
                    if (pathExp.isDirectory()) {
                        $this$recentProjectsInit_u24lambda_u249_u24lambda_u248.setMetadata("folder|");
                    }
                    $this$recentProjectsInit_u24lambda_u249_u24lambda_u248.setProjectOpenTimestamp(i);
                    $this$recentProjectsInit_u24lambda_u249_u24lambda_u248.setBuildTimestamp(i);
                    $this$recentProjectsInit_u24lambda_u249_u24lambda_u248.setDisplayName(name);
                    RecentProjectMetaInfo info = recentProjectMetaInfo;
                    recentPathInfo = new RecentPathInfo(FileUtilKt.getSystemIndependentPath((File)pathExp), info);
                }
            }
            if (recentPathInfo == null) continue;
            RecentPathInfo it$iv$iv = recentPathInfo;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private final File detourFileInit() {
        if (!this.isRegistryDetourRequired()) {
            boolean bl = false;
            String string = "Calling getDetourFile for old VS";
            throw new IllegalStateException(string.toString());
        }
        File file = this.appDataHiveFolder.resolve("privateregistry.bin").toFile();
        if (!file.exists()) {
            logger.warn("detour file is not found. did you delete it or its not vs<=17?");
            throw new VSHiveDetourFileNotFoundException();
        }
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    private final String loadCodeContainersFromConfig() {
        Object object;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Object factory;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Path configFile = this.appDataHiveFolder.resolve("ApplicationPrivateSettings.xml");
            Intrinsics.checkNotNull((Object)configFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            try {
                factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder2 = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                factory = builder2.parse(configFile.toFile());
            }
            catch (Throwable e) {
                VSRegistryParserNew.logger.info("Error reading the XML config file.", e);
                return null;
            }
            Object document = factory;
            XPathExpression query = XPathFactory.newInstance().newXPath().compile("/content/indexed/collection[@name='CodeContainers.Offline']");
            Object object2 = query.evaluate(document, XPathConstants.NODE);
            Node node = object2 instanceof Node ? (Node)object2 : null;
            if (node == null) {
                VSRegistryParserNew $this$loadCodeContainersFromConfig_u24lambda_u2412_u24lambda_u2411 = this;
                boolean bl3 = false;
                VSRegistryParserNew.logger.info("\"" + configFile + "\" has no CodeContainers defined.");
                return null;
            }
            Node element = node;
            object = Result.constructor-impl((Object)element.getTextContent());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private final String loadCodeContainersFromRegistry() {
        String string;
        try {
            string = this.registryRootKey.div("ApplicationPrivateSettings").div("_metadata").div("baselines").div("CodeContainers").getStringValue("Offline");
        }
        catch (Throwable t2) {
            logger.info("Super new method of getting projects failed");
            logger.debug(t2);
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        String regInfo = string2;
        String regInfo2 = !StringsKt.startsWith$default((CharSequence)regInfo, (char)'{', (boolean)false, (int)2, null) ? StringsKt.drop((String)regInfo, (int)1) : regInfo;
        return regInfo2;
    }

    public /* synthetic */ VSRegistryParserNew(VSHive hive, DefaultConstructorMarker $constructor_marker) {
        this(hive);
    }

    public static final /* synthetic */ Pair access$envPathInit(VSRegistryParserNew $this) {
        return $this.envPathInit();
    }

    public static final /* synthetic */ File access$settingsFileInit(VSRegistryParserNew $this) {
        return $this.settingsFileInit();
    }

    public static final /* synthetic */ String access$vsLocationInit(VSRegistryParserNew $this) {
        return $this.vsLocationInit();
    }

    public static final /* synthetic */ List access$recentProjectsInit(VSRegistryParserNew $this) {
        return $this.recentProjectsInit();
    }

    public static final /* synthetic */ Map access$extensionsListInit(VSRegistryParserNew $this) {
        return $this.extensionsListInit();
    }

    public static final /* synthetic */ ILookAndFeel access$themeInit(VSRegistryParserNew $this) {
        return $this.themeInit();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSRegistryParserNew.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VSRegistryParserNew.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSRegistryParserNew$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "veryBadLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "create", "Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSRegistryParserNew;", "hive", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VSRegistryParserNew create(@NotNull VSHive hive) {
            VSRegistryParserNew vSRegistryParserNew;
            Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
            try {
                vSRegistryParserNew = new VSRegistryParserNew(hive, null);
            }
            catch (VSHiveDetourFileNotFoundException t) {
                throw t;
            }
            catch (Throwable t) {
                logger.warn("Failed to initialize registry");
                logger.warn(t);
                vSRegistryParserNew = null;
            }
            return vSRegistryParserNew;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

