/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.tensor;

import io.kinference.attribute.Attribute;
import io.kinference.core.data.tensor.KITensor;
import io.kinference.core.data.tensor.TensorExtensionsKt;
import io.kinference.core.operators.tensor.Range;
import io.kinference.data.ONNXData;
import io.kinference.graph.Contexts;
import io.kinference.ndarray.arrays.DoubleNDArray;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.LongNDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.NDArrayUtilsKt;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.ndarray.arrays.ShortNDArray;
import io.kinference.operator.IOInfo;
import io.kinference.operator.OperatorInfo;
import io.kinference.operator.VersionInfo;
import io.kinference.primitives.types.DataType;
import io.kinference.protobuf.UtilsKt;
import io.kinference.protobuf.message.TensorProto;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bJF\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\t\"\u0010\b\u0000\u0010\u000e*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\tH\u0096@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lio/kinference/core/operators/tensor/RangeVer11;", "Lio/kinference/core/operators/tensor/Range;", "name", "", "attributes", "", "Lio/kinference/attribute/Attribute;", "", "inputs", "", "outputs", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "apply", "Lio/kinference/core/data/tensor/KITensor;", "D", "Lio/kinference/data/ONNXData;", "contexts", "Lio/kinference/graph/Contexts;", "(Lio/kinference/graph/Contexts;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "inference-core"})
@SourceDebugExtension(value={"SMAP\nRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Range.kt\nio/kinference/core/operators/tensor/RangeVer11\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class RangeVer11
extends Range {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<TensorProto.DataType> TYPE_CONSTRAINTS;
    @NotNull
    private static final List<IOInfo> INPUTS_INFO;
    @NotNull
    private static final List<IOInfo> OUTPUTS_INFO;
    @NotNull
    private static final VersionInfo VERSION;
    @NotNull
    private static final OperatorInfo INFO;

    public RangeVer11(@NotNull String name, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        super(name, INFO, attributes, inputs, outputs, null);
    }

    @Override
    @Nullable
    public <D extends ONNXData<?, ?>> Object apply(@NotNull Contexts<D> contexts, @NotNull List<KITensor> inputs, @NotNull Continuation<? super List<KITensor>> $completion) {
        KITensor kITensor = inputs.get(0);
        Intrinsics.checkNotNull((Object)kITensor);
        NDArrayCore start2 = kITensor.getData();
        KITensor kITensor2 = inputs.get(1);
        Intrinsics.checkNotNull((Object)kITensor2);
        NDArrayCore limit = kITensor2.getData();
        KITensor kITensor3 = inputs.get(2);
        Intrinsics.checkNotNull((Object)kITensor3);
        NDArrayCore delta = kITensor3.getData();
        if (!(start2.getType() == limit.getType() && limit.getType() == delta.getType())) {
            boolean $i$a$-require-RangeVer11$apply$42 = false;
            String $i$a$-require-RangeVer11$apply$42 = "Start, limit and delta tensors must have the same data type";
            throw new IllegalArgumentException($i$a$-require-RangeVer11$apply$42.toString());
        }
        if (!(NDArrayUtilsKt.isScalar(start2) && NDArrayUtilsKt.isScalar(limit) && NDArrayUtilsKt.isScalar(delta))) {
            boolean bl = false;
            String string = "Start, limit and delta tensors must be scalars";
            throw new IllegalArgumentException(string.toString());
        }
        KITensor kITensor4 = inputs.get(0);
        Intrinsics.checkNotNull((Object)kITensor4);
        return CollectionsKt.listOf((Object)TensorExtensionsKt.asTensor(RangeVer11.Companion.range(kITensor4.getData().getType(), start2.singleValue(), limit.singleValue(), delta.singleValue()), "output"));
    }

    static {
        Object[] objectArray = new TensorProto.DataType[]{TensorProto.DataType.DOUBLE, TensorProto.DataType.FLOAT, TensorProto.DataType.INT16, TensorProto.DataType.INT32, TensorProto.DataType.INT64};
        TYPE_CONSTRAINTS = SetsKt.setOf((Object[])objectArray);
        objectArray = new IOInfo[]{new IOInfo(0, TYPE_CONSTRAINTS, "start", false, null, true, null, 80, null), new IOInfo(1, TYPE_CONSTRAINTS, "limit", false, null, true, null, 80, null), new IOInfo(2, TYPE_CONSTRAINTS, "delta", false, null, true, null, 80, null)};
        INPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        OUTPUTS_INFO = CollectionsKt.listOf((Object)new IOInfo(0, TYPE_CONSTRAINTS, "output", false, null, false, null, 112, null));
        VERSION = new VersionInfo(5, 14);
        INFO = new OperatorInfo("Range", MapsKt.emptyMap(), INPUTS_INFO, OUTPUTS_INFO, VERSION, "ai.onnx");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00122\u0006\u0010\u0016\u001a\u0002H\u00122\u0006\u0010\u0017\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lio/kinference/core/operators/tensor/RangeVer11$Companion;", "", "()V", "INFO", "Lio/kinference/operator/OperatorInfo;", "INPUTS_INFO", "", "Lio/kinference/operator/IOInfo;", "OUTPUTS_INFO", "TYPE_CONSTRAINTS", "", "Lio/kinference/protobuf/message/TensorProto$DataType;", "VERSION", "Lio/kinference/operator/VersionInfo;", "getVERSION$inference_core", "()Lio/kinference/operator/VersionInfo;", "range", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "T", "type", "Lio/kinference/primitives/types/DataType;", "start", "limit", "delta", "(Lio/kinference/primitives/types/DataType;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "inference-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionInfo getVERSION$inference_core() {
            return VERSION;
        }

        private final <T> NumberNDArrayCore range(DataType type, T start2, T limit, T delta) {
            return switch (WhenMappings.$EnumSwitchMapping$0[UtilsKt.resolveProtoDataType(type).ordinal()]) {
                case 1 -> {
                    Intrinsics.checkNotNull(start2, (String)"null cannot be cast to non-null type kotlin.Double");
                    (Double)start2;
                    Intrinsics.checkNotNull(limit, (String)"null cannot be cast to non-null type kotlin.Double");
                    (Double)limit;
                    Intrinsics.checkNotNull(delta, (String)"null cannot be cast to non-null type kotlin.Double");
                    (Double)delta;
                    int size = (int)Math.ceil((((Number)limit).doubleValue() - ((Number)start2).doubleValue()) / ((Number)delta).doubleValue());
                    int[] var6_10 = new int[]{size};
                    yield new DoubleNDArray(var6_10, (Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(start2, delta){
                        final /* synthetic */ T $start;
                        final /* synthetic */ T $delta;
                        {
                            this.$start = $start;
                            this.$delta = $delta;
                            super(1);
                        }

                        @NotNull
                        public final Double invoke(int it) {
                            return ((Number)this.$start).doubleValue() + (double)it * ((Number)this.$delta).doubleValue();
                        }
                    }));
                }
                case 2 -> {
                    Intrinsics.checkNotNull(start2, (String)"null cannot be cast to non-null type kotlin.Float");
                    (Float)start2;
                    Intrinsics.checkNotNull(limit, (String)"null cannot be cast to non-null type kotlin.Float");
                    (Float)limit;
                    Intrinsics.checkNotNull(delta, (String)"null cannot be cast to non-null type kotlin.Float");
                    (Float)delta;
                    int size = (int)Math.ceil((((Number)limit).floatValue() - ((Number)start2).floatValue()) / ((Number)delta).floatValue());
                    int[] var6_11 = new int[]{size};
                    yield new FloatNDArray(var6_11, (Function1<? super Integer, Float>)((Function1)new Function1<Integer, Float>(start2, delta){
                        final /* synthetic */ T $start;
                        final /* synthetic */ T $delta;
                        {
                            this.$start = $start;
                            this.$delta = $delta;
                            super(1);
                        }

                        @NotNull
                        public final Float invoke(int it) {
                            return Float.valueOf(((Number)this.$start).floatValue() + (float)it * ((Number)this.$delta).floatValue());
                        }
                    }));
                }
                case 3 -> {
                    Intrinsics.checkNotNull(start2, (String)"null cannot be cast to non-null type kotlin.Short");
                    (Short)start2;
                    Intrinsics.checkNotNull(limit, (String)"null cannot be cast to non-null type kotlin.Short");
                    (Short)limit;
                    Intrinsics.checkNotNull(delta, (String)"null cannot be cast to non-null type kotlin.Short");
                    (Short)delta;
                    int size = (int)Math.ceil((double)(((Number)limit).intValue() - ((Number)start2).intValue()) / ((Number)delta).doubleValue());
                    int[] var6_12 = new int[]{size};
                    yield new ShortNDArray(var6_12, (Function1<? super Integer, Short>)((Function1)new Function1<Integer, Short>(start2, delta){
                        final /* synthetic */ T $start;
                        final /* synthetic */ T $delta;
                        {
                            this.$start = $start;
                            this.$delta = $delta;
                            super(1);
                        }

                        @NotNull
                        public final Short invoke(int it) {
                            return (short)(((Number)this.$start).intValue() + it * ((Number)this.$delta).intValue());
                        }
                    }));
                }
                case 4 -> {
                    Intrinsics.checkNotNull(start2, (String)"null cannot be cast to non-null type kotlin.Int");
                    (Integer)start2;
                    Intrinsics.checkNotNull(limit, (String)"null cannot be cast to non-null type kotlin.Int");
                    (Integer)limit;
                    Intrinsics.checkNotNull(delta, (String)"null cannot be cast to non-null type kotlin.Int");
                    (Integer)delta;
                    int size = (int)Math.ceil((double)(((Number)limit).intValue() - ((Number)start2).intValue()) / ((Number)delta).doubleValue());
                    int[] var6_13 = new int[]{size};
                    yield new IntNDArray(var6_13, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(start2, delta){
                        final /* synthetic */ T $start;
                        final /* synthetic */ T $delta;
                        {
                            this.$start = $start;
                            this.$delta = $delta;
                            super(1);
                        }

                        @NotNull
                        public final Integer invoke(int it) {
                            return ((Number)this.$start).intValue() + it * ((Number)this.$delta).intValue();
                        }
                    }));
                }
                case 5 -> {
                    Intrinsics.checkNotNull(start2, (String)"null cannot be cast to non-null type kotlin.Long");
                    (Long)start2;
                    Intrinsics.checkNotNull(limit, (String)"null cannot be cast to non-null type kotlin.Long");
                    (Long)limit;
                    Intrinsics.checkNotNull(delta, (String)"null cannot be cast to non-null type kotlin.Long");
                    (Long)delta;
                    int size = (int)Math.ceil((double)(((Number)limit).longValue() - ((Number)start2).longValue()) / ((Number)delta).doubleValue());
                    int[] var6_14 = new int[]{size};
                    yield new LongNDArray(var6_14, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>(start2, delta){
                        final /* synthetic */ T $start;
                        final /* synthetic */ T $delta;
                        {
                            this.$start = $start;
                            this.$delta = $delta;
                            super(1);
                        }

                        @NotNull
                        public final Long invoke(int it) {
                            return ((Number)this.$start).longValue() + (long)it * ((Number)this.$delta).longValue();
                        }
                    }));
                }
                default -> throw new IllegalStateException(("Unsupported data type: " + type).toString());
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TensorProto.DataType.values().length];
                try {
                    nArray[TensorProto.DataType.DOUBLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TensorProto.DataType.FLOAT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TensorProto.DataType.INT16.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TensorProto.DataType.INT32.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TensorProto.DataType.INT64.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

