/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;

@ApiStatus.Internal
public abstract class RuleSet {
    private volatile Set<String> ruleIds;

    public abstract List<Rule> allRules();

    public abstract List<Rule> rulesForSentence(AnalyzedSentence var1);

    public Set<String> allRuleIds() {
        Set<String> result2 = this.ruleIds;
        if (result2 == null) {
            this.ruleIds = result2 = Collections.unmodifiableSet(this.allRules().stream().map(Rule::getId).collect(Collectors.toSet()));
        }
        return result2;
    }

    public static RuleSet plain(List<Rule> rules2) {
        final List<Rule> allRules2 = Collections.unmodifiableList(rules2);
        return new RuleSet(){

            @Override
            public List<Rule> allRules() {
                return allRules2;
            }

            @Override
            public List<Rule> rulesForSentence(AnalyzedSentence sentence) {
                return allRules2;
            }
        };
    }

    public static RuleSet textLemmaHinted(List<? extends Rule> rules2) {
        return RuleSet.hinted(rules2, true);
    }

    public static RuleSet textHinted(List<? extends Rule> rules2) {
        return RuleSet.hinted(rules2, false);
    }

    private static RuleSet hinted(List<? extends Rule> rules2, boolean withLemmaHints) {
        final List<? extends Rule> allRules2 = Collections.unmodifiableList(rules2);
        final HashMap byToken = new HashMap();
        final HashMap<String, BitSet> byLemma = new HashMap<String, BitSet>();
        final BitSet unclassified = new BitSet();
        for (int i = 0; i < allRules2.size(); ++i) {
            Rule rule = allRules2.get(i);
            boolean classified = false;
            if (rule instanceof AbstractTokenBasedRule) {
                AbstractTokenBasedRule.TokenHint firstHint;
                AbstractTokenBasedRule.TokenHint[] tokenHints = ((AbstractTokenBasedRule)rule).tokenHints;
                AbstractTokenBasedRule.TokenHint tokenHint = tokenHints == null ? null : (firstHint = withLemmaHints ? tokenHints[0] : (AbstractTokenBasedRule.TokenHint)Arrays.stream(tokenHints).filter(th -> !th.inflected).findFirst().orElse(null));
                if (firstHint != null) {
                    classified = true;
                    HashMap<String, BitSet> map = firstHint.inflected ? byLemma : byToken;
                    for (String hint : firstHint.lowerCaseValues) {
                        map.computeIfAbsent(hint, __ -> new BitSet()).set(i);
                    }
                }
            }
            if (classified) continue;
            unclassified.set(i);
        }
        return new RuleSet(){

            @Override
            public List<Rule> allRules() {
                return allRules2;
            }

            @Override
            public List<Rule> rulesForSentence(AnalyzedSentence sentence) {
                BitSet set;
                BitSet included = new BitSet();
                included.or(unclassified);
                if (!byLemma.isEmpty()) {
                    for (String lemma : sentence.getLemmaSet()) {
                        set = (BitSet)byLemma.get(lemma);
                        if (set == null) continue;
                        included.or(set);
                    }
                }
                for (String token : sentence.getTokenSet()) {
                    set = (BitSet)byToken.get(token);
                    if (set == null) continue;
                    included.or(set);
                }
                return 2.filterList(included, allRules2);
            }
        };
    }

    @ApiStatus.Internal
    public static <T> List<T> filterList(BitSet includedIndices, List<T> list) {
        ArrayList<T> result2 = new ArrayList<T>();
        int i = -1;
        while ((i = includedIndices.nextSetBit(i + 1)) >= 0) {
            result2.add(list.get(i));
        }
        return result2;
    }
}

