/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdInitialCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdPatchExtension;
import com.jetbrains.rd.ide.model.RdPatchInitialCaretStateHintExtension;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.requests.PatchItemOperationType;
import com.jetbrains.rd.platform.Range;
import com.jetbrains.rd.platform.RangeKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.patchItemHandlers.FrontendSelectionChangeHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContextKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "()V", "apply", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "(Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "redo", "rollback", "step", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendSelectionChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 FrontendRdPatchHandlerContext.kt\ncom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n53#2,4:86\n53#2,4:97\n53#2,4:101\n53#2,4:105\n30#3:90\n31#3,3:92\n34#3:96\n1855#4:91\n1856#4:95\n*S KotlinDebug\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n*L\n24#1:86,4\n45#1:97,4\n50#1:101,4\n54#1:105,4\n44#1:90\n44#1:92,3\n44#1:96\n44#1:91\n44#1:95\n*E\n"})
public final class FrontendSelectionChangeHandler
implements FrontendRdPatchItemHandler<RdPatchItemVersion, RdSelectionChangeBase> {
    @Override
    @Nullable
    public Object apply(@NotNull RdSelectionChangeBase item, @NotNull FrontendRdPatchHandlerContext context, @NotNull Continuation<? super Unit> $completion) {
        Logger $this$trace$iv = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Applying selection change step: " + item.getEditorId() + " with operation type " + context.getOperation());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[context.getOperation().ordinal()]) {
            case 1: {
                this.rollback(item, context);
                break;
            }
            case 2: {
                Object object = this.redo(item, context, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            default: {
                Editor editor2 = FrontendTextControlHostKt.toEditorOrNull(item.getEditorId());
                if (editor2 == null) {
                    FrontendSelectionChangeHandler $this$apply_u24lambda_u241 = this;
                    boolean bl = false;
                    FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + item.getEditorId());
                    return Unit.INSTANCE;
                }
                Editor editor3 = editor2;
                EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor3);
                Intrinsics.checkNotNull((Object)editorSynchronizer);
                editorSynchronizer.receiveSelection((RdCaretModelChange)item);
            }
        }
        return Unit.INSTANCE;
    }

    private final void rollback(RdSelectionChangeBase step, FrontendRdPatchHandlerContext context) {
        Unit unit;
        boolean $i$f$trace;
        Logger $this$trace$iv;
        RdInitialCaretStateSnapshot rdInitialCaretStateSnapshot;
        block9: {
            FrontendRdPatchHandlerContext this_$iv = context;
            boolean $i$f$getExtension = false;
            Iterable $this$forEach$iv$iv = this_$iv.getPatch().getExtensions();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                RdPatchExtension it$iv = (RdPatchExtension)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof RdPatchInitialCaretStateHintExtension)) continue;
                RdPatchInitialCaretStateHintExtension it = (RdPatchInitialCaretStateHintExtension)it$iv;
                boolean bl2 = false;
                rdInitialCaretStateSnapshot = it.getInitialCaretStateHint();
                break block9;
            }
            rdInitialCaretStateSnapshot = null;
        }
        if (Intrinsics.areEqual((Object)(rdInitialCaretStateSnapshot != null ? rdInitialCaretStateSnapshot.getEditorId() : null), (Object)step.getEditorId())) {
            Logger $this$trace$iv2 = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                Logger logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Do not rollback initial caret state hint: " + step.getEditorId() + " - RdPatchInitialCaretStateHintExtension for " + step.getEditorId() + " is not present");
            }
            return;
        }
        Editor editor2 = FrontendTextControlHostKt.toEditorOrNull(step.getEditorId());
        if (editor2 == null) {
            $this$trace$iv = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Do not rollback caret state change: " + step.getEditorId() + " with operation type " + context.getOperation() + " because editor does not exist");
            }
            return;
        }
        $this$trace$iv = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Rollback caret state change: " + step.getEditorId() + " with operation type " + context.getOperation());
        }
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor2);
        if (editorSynchronizer != null) {
            editorSynchronizer.receiveSelection((RdCaretModelChange)UtilKt.reverse((RdSelectionChangeBase)step));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("editor synchronizer is null".toString());
        }
    }

    private final Object redo(RdSelectionChangeBase item, FrontendRdPatchHandlerContext context, Continuation<? super Unit> $completion) {
        Editor editor2 = FrontendTextControlHostKt.toEditor(item.getEditorId());
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        DocumentSynchronizer documentSynchronizer2 = DocumentExKt.getFirstDocumentSynchronizer(document, context.getSession());
        if (documentSynchronizer2 == null || (documentSynchronizer2 = documentSynchronizer2.createRangeShifter()) == null) {
            throw new IllegalStateException("No range shifter".toString());
        }
        DocumentSynchronizer shifter = documentSynchronizer2;
        RdDocumentVersion expectedVersion = FrontendRdPatchHandlerContextKt.getExpectedDocumentVersion(context, item.getEditorId().getDocumentId());
        RdCaretState actualState = UtilKt.getActualState((RdSelectionChangeBase)item);
        for (RdCaret rdCaret : actualState.getCarets()) {
            int newOffset = Math.min(shifter.shiftOnePoint((AbstractDocumentVersion)expectedVersion, rdCaret.getOffset().getOffset(), false), editor2.getDocument().getTextLength());
            Range newRange = RangeKt.truncate((Range)shifter.shiftRange((AbstractDocumentVersion)expectedVersion, RangeUtilKt.toRange(rdCaret.getSelection()), false, false, false), (int)editor2.getDocument().getTextLength());
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            Caret caret = UtilKt.getCaretById((CaretModel)caretModel, (RdCaretId)rdCaret.getId());
            if (caret == null) {
                LogicalPosition newLogicalPosition;
                boolean isPrimary = Intrinsics.areEqual((Object)rdCaret.getId(), (Object)actualState.getPrimaryCaretId());
                Intrinsics.checkNotNullExpressionValue((Object)editor2.offsetToLogicalPosition(rdCaret.getOffset().getOffset()), (String)"offsetToLogicalPosition(...)");
                Caret caret2 = caret = editor2.getCaretModel().addCaret(newLogicalPosition, isPrimary);
                if (caret2 != null) {
                    UtilKt.setId((Caret)caret2, (RdCaretId)rdCaret.getId());
                }
            }
            if (newOffset != -1) {
                Caret caret3 = caret;
                if (caret3 != null) {
                    caret3.moveToOffset(newOffset);
                }
            }
            if (!newRange.isValid()) continue;
            Caret caret4 = caret;
            if (caret4 == null) continue;
            caret4.setSelection(newRange.getStart(), newRange.getEnd());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$redo(FrontendSelectionChangeHandler $this, RdSelectionChangeBase item, FrontendRdPatchHandlerContext context, Continuation $completion) {
        return $this.redo(item, context, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PatchItemOperationType.values().length];
            try {
                nArray[PatchItemOperationType.Rollback.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatchItemOperationType.Redo.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

