/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.reflection.StringSearchResult;
import org.pentaho.di.job.JobEntryLoader;
import org.pentaho.di.trans.StepLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSearcher {
    private static final String LOCAL_PACKAGE = "org.pentaho.di";
    private static final String[] JAVA_PACKAGES = new String[]{"java.util"};
    private static String[] stepPluginPackages;
    private static String[] jobEntryPluginPackages;

    public static final void findMetaData(Object object, int level, List<StringSearchResult> stringList, Object parentObject, Object grandParentObject) {
        if (level > 5) {
            return;
        }
        if (stepPluginPackages == null) {
            stepPluginPackages = StepLoader.getInstance().getPluginPackages();
        }
        if (jobEntryPluginPackages == null) {
            jobEntryPluginPackages = JobEntryLoader.getInstance().getPluginPackages();
        }
        Class<?> baseClass = object.getClass();
        Field[] fields = baseClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int x;
            Field field = fields[i];
            boolean processThisOne = true;
            if ((field.getModifiers() & 0x10) > 0) {
                processThisOne = false;
            }
            if ((field.getModifiers() & 8) > 0) {
                processThisOne = false;
            }
            boolean sanctionedPackage = false;
            if (field.toString().indexOf(LOCAL_PACKAGE) >= 0) {
                sanctionedPackage = true;
            }
            for (x = 0; x < JAVA_PACKAGES.length && !sanctionedPackage; ++x) {
                if (field.toString().indexOf(JAVA_PACKAGES[x]) < 0) continue;
                sanctionedPackage = true;
            }
            for (x = 0; x < stepPluginPackages.length && !sanctionedPackage; ++x) {
                if (field.toString().indexOf(stepPluginPackages[x]) < 0) continue;
                sanctionedPackage = true;
            }
            for (x = 0; x < jobEntryPluginPackages.length && !sanctionedPackage; ++x) {
                if (field.toString().indexOf(jobEntryPluginPackages[x]) < 0) continue;
                sanctionedPackage = true;
            }
            if (!sanctionedPackage) {
                processThisOne = false;
            }
            if (!processThisOne) continue;
            try {
                Object obj = field.get(object);
                if (obj == null) continue;
                StringSearcher.stringSearchInObject(obj, level, stringList, parentObject, grandParentObject, field);
                continue;
            }
            catch (IllegalAccessException e) {
                Method method = StringSearcher.findMethod(baseClass, field.getName());
                if (method == null) continue;
                String fullMethod = baseClass.getName() + "." + method.getName() + "()";
                try {
                    Object string = method.invoke(object, (Object[])null);
                    if (string == null) continue;
                    StringSearcher.stringSearchInObject(string, level, stringList, parentObject, grandParentObject, field);
                    continue;
                }
                catch (Exception ex) {
                    LogWriter.getInstance().logDebug("StringSearcher", Const.rightPad((String)" ", (int)level) + "    Unable to get access to method " + fullMethod + " : " + e.toString(), new Object[0]);
                }
            }
        }
    }

    private static void stringSearchInObject(Object obj, int level, List<StringSearchResult> stringList, Object parentObject, Object grandParentObject, Field field) {
        if (obj instanceof String) {
            stringList.add(new StringSearchResult((String)obj, parentObject, grandParentObject, field.getName()));
        } else if (obj instanceof String[]) {
            String[] array = (String[])obj;
            for (int x = 0; x < array.length; ++x) {
                if (array[x] == null) continue;
                stringList.add(new StringSearchResult(array[x], parentObject, grandParentObject, field.getName() + " #" + (x + 1)));
            }
        } else if (obj instanceof Boolean) {
            stringList.add(new StringSearchResult(((Boolean)obj).toString(), parentObject, grandParentObject, field.getName() + " (Boolean)"));
        } else if (obj instanceof Condition) {
            stringList.add(new StringSearchResult(((Condition)obj).toString(), parentObject, grandParentObject, field.getName() + " (Condition)"));
        } else if (obj instanceof DatabaseInterface) {
            DatabaseInterface databaseInterface = (DatabaseInterface)obj;
            StringSearcher.findMapMetaData(databaseInterface.getAttributes(), level + 1, stringList, parentObject, grandParentObject, field);
            StringSearcher.findMetaData(obj, level + 1, stringList, parentObject, grandParentObject);
        } else if (obj instanceof Map) {
            StringSearcher.findMapMetaData((Map)obj, level, stringList, parentObject, grandParentObject, field);
        } else if (obj instanceof Object[]) {
            for (int j = 0; j < ((Object[])obj).length; ++j) {
                StringSearcher.findMetaData(((Object[])obj)[j], level + 1, stringList, parentObject, grandParentObject);
            }
        } else {
            StringSearcher.findMetaData(obj, level + 1, stringList, parentObject, grandParentObject);
        }
    }

    private static void findMapMetaData(Map map, int level, List<StringSearchResult> stringList, Object parentObject, Object grandParentObject, Field field) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (key != null) {
                stringList.add(new StringSearchResult(key.toString(), parentObject, grandParentObject, field.getName() + " (Map key)"));
            }
            if (value == null) continue;
            stringList.add(new StringSearchResult(value.toString(), parentObject, grandParentObject, field.getName() + " (Map value)"));
        }
    }

    private static Method findMethod(Class<? extends Object> baseClass, String name) {
        String getter;
        Method[] methods = baseClass.getDeclaredMethods();
        Method method = null;
        if (method == null) {
            getter = StringSearcher.constructGetter(name);
            method = StringSearcher.searchGetter(getter, baseClass, methods);
        }
        if (method == null) {
            getter = StringSearcher.constructIsGetter(name);
            method = StringSearcher.searchGetter(getter, baseClass, methods);
        }
        if (method == null) {
            getter = name;
            method = StringSearcher.searchGetter(getter, baseClass, methods);
        }
        return method;
    }

    private static Method searchGetter(String getter, Class<?> baseClass, Method[] methods) {
        Method method = null;
        try {
            method = baseClass.getMethod(getter, new Class[0]);
        }
        catch (Exception e) {
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].getName();
                if (!methodName.equalsIgnoreCase(getter)) continue;
                return methods[i];
            }
        }
        return method;
    }

    public static final String constructGetter(String name) {
        StringBuffer buf = new StringBuffer();
        buf.append("get");
        buf.append(name.substring(0, 1).toUpperCase());
        buf.append(name.substring(1));
        return buf.toString();
    }

    public static final String constructIsGetter(String name) {
        StringBuffer buf = new StringBuffer();
        buf.append("is");
        buf.append(name.substring(0, 1).toUpperCase());
        buf.append(name.substring(1));
        return buf.toString();
    }
}

