/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public abstract class JRCalculator {
    protected Map parsm = null;
    protected Map fldsm = null;
    protected Map varsm = null;
    protected JRFillVariable[] variables = null;
    protected JRFillGroup[] groups = null;
    protected JRFillChartDataset[] datasets = null;
    private JRFillParameter resourceBundle = null;
    private JRFillVariable pageNumber = null;
    private JRFillVariable columnNumber = null;
    protected JRBaseFiller filler;

    protected JRCalculator() {
    }

    protected void init(JRBaseFiller parentFiller) throws JRException {
        this.filler = parentFiller;
        this.parsm = this.filler.parametersMap;
        this.fldsm = this.filler.fieldsMap;
        this.varsm = this.filler.variablesMap;
        this.variables = this.filler.variables;
        this.groups = this.filler.groups;
        this.datasets = this.filler.datasets;
        this.resourceBundle = (JRFillParameter)this.parsm.get("REPORT_RESOURCE_BUNDLE");
        this.pageNumber = (JRFillVariable)this.varsm.get("PAGE_NUMBER");
        this.columnNumber = (JRFillVariable)this.varsm.get("COLUMN_NUMBER");
        this.customizedInit(this.parsm, this.fldsm, this.varsm);
    }

    protected abstract void customizedInit(Map var1, Map var2, Map var3) throws JRException;

    public JRFillVariable getPageNumber() {
        return this.pageNumber;
    }

    public JRFillVariable getColumnNumber() {
        return this.columnNumber;
    }

    public void calculateVariables() throws JRException {
        int i;
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                Object expressionValue = this.evaluate(variable.getExpression());
                Object newValue = variable.getIncrementer().increment(variable, expressionValue, AbstractValueProvider.getCurrentValueProvider());
                variable.setValue(newValue);
                variable.setInitialized(false);
                if (variable.getIncrementType() != 5) continue;
                variable.setIncrementedValue(variable.getValue());
            }
        }
        if (this.datasets != null && this.datasets.length > 0) {
            for (i = 0; i < this.datasets.length; ++i) {
                JRFillChartDataset dataset = this.datasets[i];
                dataset.evaluate(this);
                if (dataset.getIncrementType() != 5) continue;
                dataset.increment();
            }
        }
    }

    public void estimateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            JRFillVariable variable = null;
            Object expressionValue = null;
            Object newValue = null;
            for (int i = 0; i < this.variables.length; ++i) {
                variable = this.variables[i];
                expressionValue = this.evaluateEstimated(variable.getExpression());
                newValue = variable.getIncrementer().increment(variable, expressionValue, AbstractValueProvider.getEstimatedValueProvider());
                variable.setEstimatedValue(newValue);
            }
        }
    }

    public void estimateGroupRuptures() throws JRException {
        this.estimateVariables();
        JRFillGroup group = null;
        Object oldValue = null;
        Object estimatedValue = null;
        boolean groupHasChanged = false;
        boolean isTopLevelChange = false;
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                group = this.groups[i];
                isTopLevelChange = false;
                if (!groupHasChanged) {
                    oldValue = this.evaluateOld(group.getExpression());
                    estimatedValue = this.evaluateEstimated(group.getExpression());
                    if (oldValue == null && estimatedValue != null || oldValue != null && !oldValue.equals(estimatedValue)) {
                        groupHasChanged = true;
                        isTopLevelChange = true;
                    }
                }
                group.setHasChanged(groupHasChanged);
                group.setTopLevelChange(isTopLevelChange);
            }
        }
    }

    public void initializeVariables(byte resetType) throws JRException {
        int i;
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                this.incrementVariable(this.variables[i], resetType);
                this.initializeVariable(this.variables[i], resetType);
            }
        }
        if (this.datasets != null && this.datasets.length > 0) {
            for (i = 0; i < this.datasets.length; ++i) {
                this.incrementDataset(this.datasets[i], resetType);
                this.initializeDataset(this.datasets[i], resetType);
            }
        }
    }

    private void incrementVariable(JRFillVariable variable, byte incrementType) {
        if (variable.getIncrementType() != 5) {
            boolean toIncrement = false;
            switch (incrementType) {
                case 1: {
                    toIncrement = true;
                    break;
                }
                case 2: {
                    toIncrement = variable.getIncrementType() == 2 || variable.getIncrementType() == 3;
                    break;
                }
                case 3: {
                    toIncrement = variable.getIncrementType() == 3;
                    break;
                }
                case 4: {
                    if (variable.getIncrementType() != 4) break;
                    JRFillGroup group = (JRFillGroup)variable.getIncrementGroup();
                    toIncrement = group.hasChanged();
                    break;
                }
            }
            if (toIncrement) {
                variable.setIncrementedValue(variable.getValue());
            }
        } else {
            variable.setIncrementedValue(variable.getValue());
        }
    }

    private void incrementDataset(JRFillChartDataset dataset, byte incrementType) {
        if (dataset.getIncrementType() != 5) {
            boolean toIncrement = false;
            switch (incrementType) {
                case 1: {
                    toIncrement = true;
                    break;
                }
                case 2: {
                    toIncrement = dataset.getIncrementType() == 2 || dataset.getIncrementType() == 3;
                    break;
                }
                case 3: {
                    toIncrement = dataset.getIncrementType() == 3;
                    break;
                }
                case 4: {
                    if (dataset.getIncrementType() != 4) break;
                    JRFillGroup group = (JRFillGroup)dataset.getIncrementGroup();
                    toIncrement = group.hasChanged();
                    break;
                }
            }
            if (toIncrement) {
                dataset.increment();
            }
        }
    }

    private void initializeVariable(JRFillVariable variable, byte resetType) throws JRException {
        if (variable.getResetType() != 5) {
            boolean toInitialize = false;
            switch (resetType) {
                case 1: {
                    toInitialize = true;
                    break;
                }
                case 2: {
                    toInitialize = variable.getResetType() == 2 || variable.getResetType() == 3;
                    break;
                }
                case 3: {
                    toInitialize = variable.getResetType() == 3;
                    break;
                }
                case 4: {
                    if (variable.getResetType() != 4) break;
                    JRFillGroup group = (JRFillGroup)variable.getResetGroup();
                    toInitialize = group.hasChanged();
                    break;
                }
            }
            if (toInitialize) {
                variable.setValue(this.evaluate(variable.getInitialValueExpression()));
                variable.setInitialized(true);
                variable.setIncrementedValue(null);
            }
        } else {
            variable.setValue(this.evaluate(variable.getExpression()));
            variable.setIncrementedValue(variable.getValue());
        }
    }

    private void initializeDataset(JRFillChartDataset dataset, byte resetType) {
        boolean toInitialize = false;
        switch (resetType) {
            case 1: {
                toInitialize = true;
                break;
            }
            case 2: {
                toInitialize = dataset.getResetType() == 2 || dataset.getResetType() == 3;
                break;
            }
            case 3: {
                toInitialize = dataset.getResetType() == 3;
                break;
            }
            case 4: {
                if (dataset.getResetType() != 4) break;
                JRFillGroup group = (JRFillGroup)dataset.getResetGroup();
                toInitialize = group.hasChanged();
                break;
            }
        }
        if (toInitialize) {
            dataset.initialize();
        }
    }

    protected Object evaluate(JRExpression expression, byte evaluationType) throws JRException {
        Object value = null;
        switch (evaluationType) {
            case 1: {
                value = this.evaluateOld(expression);
                break;
            }
            case 2: {
                value = this.evaluateEstimated(expression);
                break;
            }
            default: {
                value = this.evaluate(expression);
            }
        }
        return value;
    }

    public Object evaluateOld(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        try {
            value = this.evaluateOld(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JRExpressionEvalException(expression, e);
        }
        return value;
    }

    public Object evaluateEstimated(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        try {
            value = this.evaluateEstimated(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JRExpressionEvalException(expression, e);
        }
        return value;
    }

    public Object evaluate(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        try {
            value = this.evaluate(expression.getId());
        }
        catch (NullPointerException e) {
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JRExpressionEvalException(expression, e);
        }
        return value;
    }

    protected abstract Object evaluateOld(int var1) throws Throwable;

    protected abstract Object evaluateEstimated(int var1) throws Throwable;

    protected abstract Object evaluate(int var1) throws Throwable;

    public String str(String key) {
        String str = null;
        try {
            str = ((ResourceBundle)this.resourceBundle.getValue()).getString(key);
        }
        catch (NullPointerException e) {
            str = this.handleMissingResource(key, e);
        }
        catch (MissingResourceException e) {
            str = this.handleMissingResource(key, e);
        }
        return str;
    }

    public String msg(String pattern, Object arg0) {
        return MessageFormat.format(pattern, arg0);
    }

    public String msg(String pattern, Object arg0, Object arg1) {
        return MessageFormat.format(pattern, arg0, arg1);
    }

    public String msg(String pattern, Object arg0, Object arg1, Object arg2) {
        return MessageFormat.format(pattern, arg0, arg1, arg2);
    }

    protected String handleMissingResource(String key, Exception e) throws JRRuntimeException {
        String str;
        switch (this.filler.whenResourceMissingType) {
            case 2: {
                str = "";
                break;
            }
            case 3: {
                str = key;
                break;
            }
            case 4: {
                throw new JRRuntimeException("Resource nout found for key \"" + key + "\".", e);
            }
            default: {
                str = null;
            }
        }
        return str;
    }
}

