/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.serializer.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNamePairSerializier
extends Serializer<ServerNamePair> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerNamePair pair;

    public ServerNamePairSerializier(ServerNamePair pair) {
        this.pair = pair;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing ServerNamePair");
        this.writeServerNameType(this.pair);
        this.writeServerNameLength(this.pair);
        this.writeServerName(this.pair);
        return this.getAlreadySerialized();
    }

    private void writeServerNameType(ServerNamePair pair) {
        this.appendByte((Byte)pair.getServerNameType().getValue());
        LOGGER.debug("ServerNameType: " + pair.getServerNameType().getValue());
    }

    private void writeServerNameLength(ServerNamePair pair) {
        this.appendInt((Integer)pair.getServerNameLength().getValue(), 2);
        LOGGER.debug("ServerNameLength: " + pair.getServerNameLength().getValue());
    }

    private void writeServerName(ServerNamePair pair) {
        this.appendBytes((byte[])pair.getServerName().getValue());
        LOGGER.debug("ServerName: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getServerName().getValue())));
    }
}

