/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.ZapTextArea;

public class NotesAddDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private ZapTextArea txtDisplay = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private HistoryReference historyRef;
    private JScrollPane jScrollPane = null;

    public NotesAddDialog() throws HeadlessException {
        this.initialize();
    }

    public NotesAddDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("history.addnote.title"));
        this.setContentPane(this.getJPanel());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(407, 407);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NotesAddDialog.this.clearAndDispose();
            }
        });
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            JLabel jLabel2 = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(new Dimension(400, 400));
            this.jPanel.setMinimumSize(new Dimension(400, 400));
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 13;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 10);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 5;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.insets = new Insets(2, 10, 2, 5);
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints15.gridwidth = 3;
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 2;
            gridBagConstraints15.anchor = 18;
            gridBagConstraints15.ipadx = 0;
            gridBagConstraints15.ipady = 10;
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints15);
            this.jPanel.add((Component)jLabel2, gridBagConstraints13);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnOk(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private ZapTextArea getTxtDisplay() {
        if (this.txtDisplay == null) {
            this.txtDisplay = new ZapTextArea("");
        }
        return this.txtDisplay;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(Constant.messages.getString("all.button.save"));
            this.btnOk.setMinimumSize(new Dimension(75, 30));
            this.btnOk.setPreferredSize(new Dimension(75, 30));
            this.btnOk.setMaximumSize(new Dimension(100, 40));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotesAddDialog.this.historyRef.setNote(NotesAddDialog.this.getTxtDisplay().getText());
                    NotesAddDialog.this.clearAndDispose();
                }
            });
        }
        return this.btnOk;
    }

    private void clearAndDispose() {
        this.setNote("");
        this.historyRef = null;
        this.dispose();
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.setMaximumSize(new Dimension(100, 40));
            this.btnCancel.setMinimumSize(new Dimension(70, 30));
            this.btnCancel.setPreferredSize(new Dimension(70, 30));
            this.btnCancel.setEnabled(true);
            this.btnCancel.addActionListener(e -> this.clearAndDispose());
        }
        return this.btnCancel;
    }

    @Deprecated
    public void setPlugin(ExtensionHistory plugin) {
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setViewportView(this.getTxtDisplay());
        }
        return this.jScrollPane;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyRef) {
        this.historyRef = historyRef;
    }

    public void setNote(String note) {
        this.getTxtDisplay().setText(note);
        this.getTxtDisplay().discardAllEdits();
    }
}

