/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.ModelsContext;

public class FetchProfileAnnotation
implements FetchProfile {
    private String name;
    private FetchProfile.FetchOverride[] fetchOverrides;

    public FetchProfileAnnotation(ModelsContext modelContext) {
        this.fetchOverrides = new FetchProfile.FetchOverride[0];
    }

    public FetchProfileAnnotation(FetchProfile annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.fetchOverrides = (FetchProfile.FetchOverride[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.FETCH_PROFILE, "fetchOverrides", modelContext);
    }

    public FetchProfileAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.fetchOverrides = (FetchProfile.FetchOverride[])attributeValues.get("fetchOverrides");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return FetchProfile.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public FetchProfile.FetchOverride[] fetchOverrides() {
        return this.fetchOverrides;
    }

    public void fetchOverrides(FetchProfile.FetchOverride[] value) {
        this.fetchOverrides = value;
    }
}

