/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Objects;
import twitter4j.EntityIndex;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.TwitterException;
import twitter4j.v1.URLEntity;

final class QuotedStatusPermalinkJSONImpl
extends EntityIndex
implements URLEntity {
    private static final long serialVersionUID = -9029983811168784541L;
    private String url;
    private String expandedURL;
    private String displayURL;

    QuotedStatusPermalinkJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    QuotedStatusPermalinkJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            if (!json.isNull("url")) {
                this.url = json.getString("url");
            }
            this.expandedURL = !json.isNull("expanded") ? json.getString("expanded") : this.url;
            this.displayURL = !json.isNull("display") ? json.getString("display") : this.url;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public String getText() {
        return this.url;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getExpandedURL() {
        return this.expandedURL;
    }

    @Override
    public String getDisplayURL() {
        return this.displayURL;
    }

    @Override
    public int getStart() {
        return super.getStart();
    }

    @Override
    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuotedStatusPermalinkJSONImpl that = (QuotedStatusPermalinkJSONImpl)o;
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.expandedURL, that.expandedURL)) {
            return false;
        }
        return Objects.equals(this.displayURL, that.displayURL);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.expandedURL != null ? this.expandedURL.hashCode() : 0);
        result = 31 * result + (this.displayURL != null ? this.displayURL.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "QuotedStatusPermalinkJSONImpl{url='" + this.url + '\'' + ", expandedURL='" + this.expandedURL + '\'' + ", displayURL='" + this.displayURL + '\'' + '}';
    }
}

