/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.semantics;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.semantics.Equipment;
import org.openhab.core.semantics.Location;
import org.openhab.core.semantics.Point;
import org.openhab.core.semantics.Property;
import org.openhab.core.semantics.Tag;
import org.openhab.core.types.StateDescription;

@NonNullByDefault
public class SemanticTags {
    private static final Map<String, Class<? extends Tag>> TAGS = Collections.synchronizedMap(new TreeMap());

    static {
        SemanticTags.addTagSet("Location", Location.class);
        SemanticTags.addTagSet("Equipment", Equipment.class);
        SemanticTags.addTagSet("Point", Point.class);
        SemanticTags.addTagSet("Property", Property.class);
    }

    public static @Nullable Class<? extends Tag> getById(String tagId) {
        return TAGS.get(tagId);
    }

    public static @Nullable Class<? extends Tag> getSemanticType(Item item) {
        for (String tag : item.getTags()) {
            Class<? extends Tag> type = SemanticTags.getById(tag);
            if (type == null || Property.class.isAssignableFrom(type)) continue;
            return type;
        }
        if (SemanticTags.getProperty(item) != null) {
            StateDescription stateDescription = item.getStateDescription();
            if (stateDescription != null && stateDescription.isReadOnly()) {
                return SemanticTags.getById("Point_Measurement");
            }
            return SemanticTags.getById("Point_Control");
        }
        return null;
    }

    public static @Nullable Class<? extends Tag> getSemanticRoot(Class<? extends Tag> type) {
        if (type == null) {
            return null;
        }
        if (Point.class.isAssignableFrom(type)) {
            return Point.class;
        }
        if (Property.class.isAssignableFrom(type)) {
            return Property.class;
        }
        if (Location.class.isAssignableFrom(type)) {
            return Location.class;
        }
        if (Equipment.class.isAssignableFrom(type)) {
            return Equipment.class;
        }
        return null;
    }

    public static String getSemanticRootName(Class<? extends Tag> type) {
        Class<? extends Tag> semanticRoot = SemanticTags.getSemanticRoot(type);
        if (semanticRoot != null) {
            return semanticRoot.getSimpleName();
        }
        return "";
    }

    public static @Nullable Class<? extends Property> getProperty(Item item) {
        for (String tag : item.getTags()) {
            Class<? extends Tag> type = SemanticTags.getById(tag);
            if (type == null || !Property.class.isAssignableFrom(type)) continue;
            return type;
        }
        return null;
    }

    public static @Nullable Class<? extends Point> getPoint(Item item) {
        Set tags = item.getTags();
        for (String tag : tags) {
            Class<? extends Tag> type = SemanticTags.getById(tag);
            if (type == null || !Point.class.isAssignableFrom(type)) continue;
            return type;
        }
        return null;
    }

    public static @Nullable Class<? extends Equipment> getEquipment(Item item) {
        for (String tag : item.getTags()) {
            Class<? extends Tag> type = SemanticTags.getById(tag);
            if (type == null || !Equipment.class.isAssignableFrom(type)) continue;
            return type;
        }
        return null;
    }

    public static @Nullable Class<? extends Location> getLocation(Item item) {
        for (String tag : item.getTags()) {
            Class<? extends Tag> type = SemanticTags.getById(tag);
            if (type == null || !Location.class.isAssignableFrom(type)) continue;
            return type;
        }
        return null;
    }

    public static void addTagSet(String id, Class<? extends Tag> tagSet) {
        TAGS.put(id, tagSet);
    }

    public static void removeTagSet(String id, Class<? extends Tag> tagSet) {
        TAGS.remove(id, tagSet);
    }
}

