/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.encoder.mqtt3.Mqtt3MessageEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttStatefulSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.mqtt.mqtt3.message.Mqtt3MessageType;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt3SubscribeEncoder
extends Mqtt3MessageEncoder<MqttStatefulSubscribe> {
    private static final int FIXED_HEADER = Mqtt3MessageType.SUBSCRIBE.getCode() << 4 | 2;
    private static final int VARIABLE_HEADER_FIXED_LENGTH = 2;

    @Inject
    Mqtt3SubscribeEncoder() {
    }

    @Override
    int remainingLength(@NotNull MqttStatefulSubscribe message) {
        int remainingLength = 2;
        List subscriptions = ((MqttSubscribe)message.stateless()).getSubscriptions();
        for (int i = 0; i < subscriptions.size(); ++i) {
            remainingLength += ((MqttSubscription)subscriptions.get(i)).getTopicFilter().encodedLength() + 1;
        }
        return remainingLength;
    }

    @Override
    void encode(@NotNull MqttStatefulSubscribe message, @NotNull ByteBuf out, int remainingLength) {
        this.encodeFixedHeader(out, remainingLength);
        this.encodeVariableHeader(message, out);
        this.encodePayload(message, out);
    }

    private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulSubscribe message, @NotNull ByteBuf out) {
        out.writeShort(message.getPacketIdentifier());
    }

    private void encodePayload(@NotNull MqttStatefulSubscribe message, @NotNull ByteBuf out) {
        List subscriptions = ((MqttSubscribe)message.stateless()).getSubscriptions();
        for (int i = 0; i < subscriptions.size(); ++i) {
            MqttSubscription subscription = (MqttSubscription)subscriptions.get(i);
            subscription.getTopicFilter().encode(out);
            out.writeByte(subscription.getQos().getCode());
        }
    }
}

